/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.iterator;

import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.LimitFilterBuilder;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class EdgeScanIterator<K, VV, EV>
implements Iterator<IEdge<K, EV>> {
    private Supplier<IGraphFilter> filterFun;
    private final Iterator<Tuple<byte[], byte[]>> iterator;
    private final BiFunction<byte[], byte[], IEdge<K, EV>> edgeDecoder;
    private IEdge<K, EV> nextValue;
    private K lastKey = null;
    private IGraphFilter filter = null;

    public EdgeScanIterator(Iterator<Tuple<byte[], byte[]>> iterator, IStatePushDown pushdown, BiFunction<byte[], byte[], IEdge<K, EV>> decoderFun) {
        IGraphFilter filter = (IGraphFilter)pushdown.getFilter();
        IEdgeLimit limit = pushdown.getEdgeLimit();
        this.filterFun = limit == null ? () -> filter : () -> LimitFilterBuilder.build((IGraphFilter)filter, (IEdgeLimit)limit);
        this.iterator = iterator;
        this.edgeDecoder = decoderFun;
    }

    @Override
    public boolean hasNext() {
        while (this.iterator.hasNext()) {
            Tuple<byte[], byte[]> pair = this.iterator.next();
            this.nextValue = this.edgeDecoder.apply((byte[])pair.f0, (byte[])pair.f1);
            if (!this.nextValue.getSrcId().equals(this.lastKey)) {
                this.filter = this.filterFun.get();
                this.lastKey = this.nextValue.getSrcId();
            }
            if (!this.filter.filterEdge(this.nextValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEdge<K, EV> next() {
        return this.nextValue;
    }
}

