/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.iterator;

import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.iterator.IOneDegreeGraphIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.store.rocksdb.iterator.EdgeListScanIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OneDegreeGraphScanIterator<K, VV, EV>
implements IOneDegreeGraphIterator<K, VV, EV> {
    private final Iterator<IVertex<K, VV>> vertexIterator;
    private final Iterator<List<IEdge<K, EV>>> edgeListIterator;
    private final IType<K> keyType;
    private IGraphFilter filter;
    private OneDegreeGraph<K, VV, EV> nextValue;
    private List<IEdge<K, EV>> candidateEdges;
    private IVertex<K, VV> candidateVertex;

    public OneDegreeGraphScanIterator(IType<K> keyType, Iterator<IVertex<K, VV>> vertexIterator, Iterator<IEdge<K, EV>> edgeIterator, IStatePushDown pushdown) {
        this.keyType = keyType;
        this.vertexIterator = vertexIterator;
        this.edgeListIterator = new EdgeListScanIterator<K, EV>(edgeIterator);
        this.filter = (IGraphFilter)pushdown.getFilter();
    }

    private IVertex<K, VV> getVertexFromIterator() {
        if (this.vertexIterator.hasNext()) {
            return this.vertexIterator.next();
        }
        return null;
    }

    public boolean hasNext() {
        do {
            IVertex<K, VV> iVertex = this.candidateVertex = this.candidateVertex == null ? this.getVertexFromIterator() : this.candidateVertex;
            if (this.candidateEdges == null && this.edgeListIterator.hasNext()) {
                this.candidateEdges = this.edgeListIterator.next();
            } else if (this.candidateEdges == null) {
                this.candidateEdges = new ArrayList<IEdge<K, EV>>();
            }
            if (this.candidateEdges.size() > 0 && this.candidateVertex != null) {
                Object vertexKey;
                Object edgeKey = this.candidateEdges.get(0).getSrcId();
                int res = this.keyType.compare(edgeKey, vertexKey = this.candidateVertex.getId());
                if (res < 0) {
                    this.nextValue = new OneDegreeGraph(edgeKey, null, this.candidateEdges.iterator());
                    this.candidateEdges = null;
                    continue;
                }
                if (res == 0) {
                    this.nextValue = new OneDegreeGraph(vertexKey, this.candidateVertex, this.candidateEdges.iterator());
                    this.candidateVertex = null;
                    this.candidateEdges = null;
                    continue;
                }
                this.nextValue = new OneDegreeGraph(vertexKey, this.candidateVertex, Collections.emptyIterator());
                this.candidateVertex = null;
                continue;
            }
            if (this.candidateEdges.size() > 0) {
                this.nextValue = new OneDegreeGraph(this.candidateEdges.get(0).getSrcId(), null, this.candidateEdges.iterator());
                this.candidateEdges = null;
                continue;
            }
            if (this.candidateVertex != null) {
                this.nextValue = new OneDegreeGraph(this.candidateVertex.getId(), this.candidateVertex, Collections.emptyIterator());
                this.candidateVertex = null;
                continue;
            }
            return false;
        } while (!this.filter.filterOneDegreeGraph(this.nextValue));
        return true;
    }

    public OneDegreeGraph<K, VV, EV> next() {
        return this.nextValue;
    }
}

