/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.iterator;

import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.utils.ByteUtils;
import java.io.Closeable;
import java.util.Iterator;
import org.rocksdb.RocksIterator;

public class RocksdbIterator
implements Iterator<Tuple<byte[], byte[]>>,
Closeable {
    private final RocksIterator rocksIt;
    private byte[] prefix;
    private Tuple<byte[], byte[]> next;
    private boolean isClosed = false;

    public RocksdbIterator(RocksIterator iterator) {
        this.rocksIt = iterator;
        this.rocksIt.seekToFirst();
    }

    public RocksdbIterator(RocksIterator iterator, byte[] prefix) {
        this.rocksIt = iterator;
        this.prefix = prefix;
        this.rocksIt.seek(prefix);
    }

    private boolean isValid(byte[] key) {
        return this.prefix == null || ByteUtils.isStartsWith((byte[])key, (byte[])this.prefix);
    }

    @Override
    public boolean hasNext() {
        this.next = null;
        if (!this.isClosed && this.rocksIt.isValid()) {
            this.next = Tuple.of((Object)this.rocksIt.key(), (Object)this.rocksIt.value());
        }
        if (this.next == null || !this.isValid((byte[])this.next.f0)) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public Tuple<byte[], byte[]> next() {
        this.rocksIt.next();
        return this.next;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.rocksIt.close();
            this.isClosed = true;
        }
    }
}

