/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.proxy;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.StateConfigKeys;
import com.antgroup.geaflow.state.graph.encoder.IGraphKVEncoder;
import com.antgroup.geaflow.store.rocksdb.RocksdbClient;
import com.antgroup.geaflow.store.rocksdb.proxy.AsyncGraphMultiVersionedProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.AsyncGraphRocksdbProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.IGraphMultiVersionedRocksdbProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.IGraphRocksdbProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.SyncGraphMultiVersionedProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.SyncGraphRocksdbProxy;

public class ProxyBuilder {
    public static <K, VV, EV> IGraphRocksdbProxy<K, VV, EV> build(Configuration config, RocksdbClient rocksdbClient, IGraphKVEncoder<K, VV, EV> encoder) {
        if (config.getBoolean(StateConfigKeys.STATE_WRITE_ASYNC_ENABLE)) {
            return new AsyncGraphRocksdbProxy<K, VV, EV>(rocksdbClient, encoder, config);
        }
        return new SyncGraphRocksdbProxy<K, VV, EV>(rocksdbClient, encoder, config);
    }

    public static <K, VV, EV> IGraphMultiVersionedRocksdbProxy<K, VV, EV> buildMultiVersioned(Configuration config, RocksdbClient rocksdbClient, IGraphKVEncoder<K, VV, EV> encoder) {
        if (config.getBoolean(StateConfigKeys.STATE_WRITE_ASYNC_ENABLE)) {
            return new AsyncGraphMultiVersionedProxy<K, VV, EV>(rocksdbClient, encoder, config);
        }
        return new SyncGraphMultiVersionedProxy<K, VV, EV>(rocksdbClient, encoder, config);
    }
}

