/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.state.pushdown.inner.CodeGenFilterConverter;
import com.antgroup.geaflow.state.pushdown.inner.DirectFilterConverter;
import com.antgroup.geaflow.state.pushdown.inner.IFilterConverter;
import com.antgroup.geaflow.store.api.graph.IPushDownStore;
import com.antgroup.geaflow.store.config.StoreConfigKeys;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.rocksdb.BaseRocksdbStore;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class BaseRocksdbGraphStore
extends BaseRocksdbStore
implements IPushDownStore {
    protected IFilterConverter filterConverter;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        boolean codegenEnable = storeContext.getConfig().getBoolean(StoreConfigKeys.STORE_FILTER_CODEGEN_ENABLE);
        this.filterConverter = codegenEnable ? new CodeGenFilterConverter() : new DirectFilterConverter();
    }

    public IFilterConverter getFilterConverter() {
        return this.filterConverter;
    }

    @Override
    protected Path getRemotePath() {
        return Paths.get(this.root, this.storeContext.getName(), Integer.toString(this.shardId));
    }
}

