/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.state.serializer.IKVSerializer;
import com.antgroup.geaflow.store.api.key.IKVStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.rocksdb.BaseRocksdbStore;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;

public class KVRocksdbStore<K, V>
extends BaseRocksdbStore
implements IKVStore<K, V> {
    private IKVSerializer<K, V> kvSerializer;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        this.kvSerializer = (IKVSerializer)Preconditions.checkNotNull((Object)storeContext.getKeySerializer(), (Object)"keySerializer must be set");
    }

    @Override
    protected List<String> getCfList() {
        return Arrays.asList("default");
    }

    public void put(K key, V value) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] valueArray = this.kvSerializer.serializeValue(value);
        this.rocksdbClient.write("default", keyArray, valueArray);
    }

    public void remove(K key) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        this.rocksdbClient.delete("default", keyArray);
    }

    public V get(K key) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] valueArray = this.rocksdbClient.get("default", keyArray);
        if (valueArray == null) {
            return null;
        }
        return (V)this.kvSerializer.deserializeValue(valueArray);
    }
}

