/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.iterator;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.iterator.IVertexIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import java.util.function.BiFunction;

public class VertexScanIterator<K, VV, EV>
implements IVertexIterator<K, VV> {
    private final CloseableIterator<Tuple<byte[], byte[]>> iterator;
    private final IGraphFilter filter;
    private final BiFunction<byte[], byte[], IVertex<K, VV>> vertexDecoder;
    private boolean isClosed = false;
    private IVertex<K, VV> nextValue;

    public VertexScanIterator(CloseableIterator<Tuple<byte[], byte[]>> iterator, IStatePushDown pushdown, BiFunction<byte[], byte[], IVertex<K, VV>> decoderFun) {
        this.vertexDecoder = decoderFun;
        this.iterator = iterator;
        this.filter = (IGraphFilter)pushdown.getFilter();
    }

    public boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        while (this.iterator.hasNext()) {
            Tuple pair = (Tuple)this.iterator.next();
            this.nextValue = this.vertexDecoder.apply((byte[])pair.f0, (byte[])pair.f1);
            if (!this.filter.filterVertex(this.nextValue)) continue;
            return true;
        }
        return false;
    }

    public IVertex<K, VV> next() {
        return this.nextValue;
    }

    public void close() {
        this.iterator.close();
    }
}

