/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.options;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.store.rocksdb.RocksdbConfigKeys;
import com.antgroup.geaflow.store.rocksdb.options.IRocksDBOptions;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.FlushOptions;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;

public class DefaultGraphOptions
implements IRocksDBOptions {
    protected Statistics statistics;
    protected Options options = new Options();
    protected DBOptions dbOptions = new DBOptions();
    protected WriteOptions writeOptions = new WriteOptions();
    protected ReadOptions readOptions = new ReadOptions();
    protected FlushOptions flushOptions = new FlushOptions();
    protected boolean closed;
    private int maxWriteBufferNumber;
    private long blockSize;
    private long blockCacheSize;
    private long writeBufferSize;
    private long targetFileSize;

    protected void initOption() {
        this.options.setUseDirectIoForFlushAndCompaction(true);
        this.options.setCreateIfMissing(true);
        this.options.setCreateMissingColumnFamilies(true);
        this.options.setMergeOperator((MergeOperator)new StringAppendOperator());
        this.options.setTableFormatConfig((TableFormatConfig)this.buildBlockBasedTableConfig());
        this.options.setMaxWriteBufferNumber(this.maxWriteBufferNumber);
        this.options.setWriteBufferSize(this.writeBufferSize);
        this.options.setTargetFileSizeBase(this.targetFileSize);
        this.options.setMaxBackgroundFlushes(2);
        this.options.setMaxBackgroundCompactions(2);
        this.options.setLevelZeroFileNumCompactionTrigger(20);
        this.options.setLevelZeroSlowdownWritesTrigger(30);
        this.options.setLevelZeroStopWritesTrigger(40);
        this.options.setNumLevels(4);
        this.options.setMaxManifestFileSize(51200L);
        this.dbOptions.setCreateIfMissing(true);
        this.dbOptions.setCreateMissingColumnFamilies(true);
        this.dbOptions.setMaxBackgroundFlushes(2);
        this.dbOptions.setMaxBackgroundCompactions(6);
        this.dbOptions.setMaxManifestFileSize(51200L);
        this.writeOptions.setDisableWAL(true);
        this.flushOptions.setWaitForFlush(true);
    }

    @Override
    public void init(Configuration config) {
        this.maxWriteBufferNumber = config.getInteger(RocksdbConfigKeys.ROCKSDB_OPTIONS_MAX_WRITER_BUFFER_NUM);
        this.writeBufferSize = config.getLong(RocksdbConfigKeys.ROCKSDB_OPTIONS_WRITER_BUFFER_SIZE);
        this.targetFileSize = config.getLong(RocksdbConfigKeys.ROCKSDB_OPTIONS_TARGET_FILE_SIZE);
        this.blockSize = config.getLong(RocksdbConfigKeys.ROCKSDB_OPTIONS_TABLE_BLOCK_SIZE);
        this.blockCacheSize = config.getLong(RocksdbConfigKeys.ROCKSDB_OPTIONS_TABLE_BLOCK_CACHE_SIZE);
        this.initOption();
    }

    public BlockBasedTableConfig buildBlockBasedTableConfig() {
        BlockBasedTableConfig tableOptions = new BlockBasedTableConfig();
        tableOptions.setBlockSize(this.blockSize);
        tableOptions.setBlockCacheSize(this.blockCacheSize);
        tableOptions.setFilter((Filter)new BloomFilter(10.0, false));
        tableOptions.setCacheIndexAndFilterBlocks(true);
        tableOptions.setPinL0FilterAndIndexBlocksInCache(true);
        return tableOptions;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    @Override
    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    @Override
    public FlushOptions getFlushOptions() {
        return this.flushOptions;
    }

    @Override
    public DBOptions getDbOptions() {
        return this.dbOptions;
    }

    @Override
    public ColumnFamilyOptions buildFamilyOptions() {
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        columnFamilyOptions.setWriteBufferSize(this.writeBufferSize);
        columnFamilyOptions.setTargetFileSizeBase(this.targetFileSize);
        columnFamilyOptions.setLevelZeroFileNumCompactionTrigger(20);
        columnFamilyOptions.setLevelZeroSlowdownWritesTrigger(30);
        columnFamilyOptions.setLevelZeroStopWritesTrigger(40);
        BlockBasedTableConfig tableConfig = this.buildBlockBasedTableConfig();
        tableConfig.setBlockSize(this.blockSize);
        tableConfig.setBlockCacheSize(this.blockCacheSize);
        columnFamilyOptions.setTableFormatConfig((TableFormatConfig)tableConfig);
        columnFamilyOptions.setMaxWriteBufferNumber(2);
        return columnFamilyOptions;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void enableParanoidCheck() {
        this.options.setParanoidChecks(true);
    }

    @Override
    public void enableStatistics() {
        this.statistics = new Statistics();
        this.statistics.setStatsLevel(StatsLevel.ALL);
        this.options.setStatistics(this.statistics);
    }

    @Override
    public void close() {
        this.options.close();
        if (this.statistics != null) {
            this.statistics.close();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

