/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.proxy;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.graph.encoder.IEdgeKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.IGraphKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.IVertexKVEncoder;
import com.antgroup.geaflow.state.iterator.IteratorWithClose;
import com.antgroup.geaflow.state.iterator.IteratorWithFlatFn;
import com.antgroup.geaflow.state.iterator.IteratorWithFn;
import com.antgroup.geaflow.state.iterator.IteratorWithFnThenFilter;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.StatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.GraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;
import com.antgroup.geaflow.store.iterator.KeysIterator;
import com.antgroup.geaflow.store.rocksdb.RocksdbClient;
import com.antgroup.geaflow.store.rocksdb.iterator.EdgeListScanIterator;
import com.antgroup.geaflow.store.rocksdb.iterator.EdgeScanIterator;
import com.antgroup.geaflow.store.rocksdb.iterator.OneDegreeGraphScanIterator;
import com.antgroup.geaflow.store.rocksdb.iterator.RocksdbIterator;
import com.antgroup.geaflow.store.rocksdb.iterator.VertexScanIterator;
import com.antgroup.geaflow.store.rocksdb.proxy.IGraphRocksdbProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class SyncGraphRocksdbProxy<K, VV, EV>
implements IGraphRocksdbProxy<K, VV, EV> {
    protected final Configuration config;
    protected final IVertexKVEncoder<K, VV> vertexEncoder;
    protected final IEdgeKVEncoder<K, EV> edgeEncoder;
    protected IGraphKVEncoder<K, VV, EV> encoder;
    protected final RocksdbClient rocksdbClient;

    public SyncGraphRocksdbProxy(RocksdbClient rocksdbClient, IGraphKVEncoder<K, VV, EV> encoder, Configuration config) {
        this.encoder = encoder;
        this.vertexEncoder = this.encoder.getVertexEncoder();
        this.edgeEncoder = this.encoder.getEdgeEncoder();
        this.rocksdbClient = rocksdbClient;
        this.config = config;
    }

    @Override
    public RocksdbClient getClient() {
        return this.rocksdbClient;
    }

    public void addVertex(IVertex<K, VV> vertex) {
        Tuple tuple = this.vertexEncoder.format(vertex);
        this.rocksdbClient.write("default", (byte[])tuple.f0, (byte[])tuple.f1);
    }

    public void addEdge(IEdge<K, EV> edge) {
        Tuple tuple = this.edgeEncoder.format(edge);
        this.rocksdbClient.write("e", (byte[])tuple.f0, (byte[])tuple.f1);
    }

    public IVertex<K, VV> getVertex(K sid, IStatePushDown pushdown) {
        byte[] key = this.encoder.getKeyType().serialize(sid);
        byte[] value = this.rocksdbClient.get("default", key);
        if (value != null) {
            IVertex vertex = this.vertexEncoder.getVertex(key, value);
            if (pushdown == null || ((IGraphFilter)pushdown.getFilter()).filterVertex(vertex)) {
                return vertex;
            }
        }
        return null;
    }

    public List<IEdge<K, EV>> getEdges(K sid, IStatePushDown pushdown) {
        IGraphFilter filter = GraphFilter.of((IFilter)pushdown.getFilter(), (IEdgeLimit)pushdown.getEdgeLimit());
        return this.getEdges(sid, filter);
    }

    protected List<IEdge<K, EV>> getEdges(K sid, IGraphFilter filter) {
        ArrayList<IEdge<K, EV>> list = new ArrayList<IEdge<K, EV>>();
        byte[] prefix = this.edgeEncoder.getScanBytes(sid);
        try (RocksdbIterator it = new RocksdbIterator(this.rocksdbClient.getIterator("e"), prefix);){
            while (it.hasNext()) {
                Tuple<byte[], byte[]> pair = it.next();
                IEdge edge = this.edgeEncoder.getEdge((byte[])pair.f0, (byte[])pair.f1);
                if (filter.filterEdge(edge)) {
                    list.add(edge);
                }
                if (!filter.dropAllRemaining()) continue;
                break;
            }
        }
        return list;
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        OneDegreeGraph oneDegreeGraph;
        IVertex<K, VV> vertex = this.getVertex(sid, pushdown);
        List<IEdge<K, EV>> edgeList = this.getEdges(sid, pushdown);
        IGraphFilter filter = GraphFilter.of((IFilter)pushdown.getFilter(), (IEdgeLimit)pushdown.getEdgeLimit());
        if (filter.filterOneDegreeGraph(oneDegreeGraph = new OneDegreeGraph(sid, vertex, (CloseableIterator)IteratorWithClose.wrap(edgeList.iterator())))) {
            return oneDegreeGraph;
        }
        return null;
    }

    public CloseableIterator<K> vertexIDIterator() {
        this.flush();
        RocksdbIterator it = new RocksdbIterator(this.rocksdbClient.getIterator("default"));
        return new IteratorWithFnThenFilter((CloseableIterator)it, tuple2 -> this.vertexEncoder.getVertexID((byte[])tuple2.f0), new Predicate<K>(){
            K last = null;

            @Override
            public boolean test(K k) {
                boolean res = k.equals(this.last);
                this.last = k;
                return !res;
            }
        });
    }

    public CloseableIterator<K> vertexIDIterator(IStatePushDown pushDown) {
        if (pushDown.getFilter() == null) {
            return this.vertexIDIterator();
        }
        return new IteratorWithFn(this.getVertexIterator(pushDown), IVertex::getId);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(IStatePushDown pushdown) {
        this.flush();
        RocksdbIterator it = new RocksdbIterator(this.rocksdbClient.getIterator("default"));
        return new VertexScanIterator(it, pushdown, (arg_0, arg_1) -> this.vertexEncoder.getVertex(arg_0, arg_1));
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(List<K> keys, IStatePushDown pushdown) {
        return new KeysIterator(keys, this::getVertex, pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(IStatePushDown pushdown) {
        this.flush();
        RocksdbIterator it = new RocksdbIterator(this.rocksdbClient.getIterator("e"));
        return new EdgeScanIterator((Iterator<Tuple<byte[], byte[]>>)((Object)it), pushdown, (arg_0, arg_1) -> this.edgeEncoder.getEdge(arg_0, arg_1));
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(List<K> keys, IStatePushDown pushdown) {
        return new IteratorWithFlatFn((CloseableIterator)new KeysIterator(keys, this::getEdges, pushdown), List::iterator);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        this.flush();
        return new OneDegreeGraphScanIterator<K, VV, EV>(this.encoder.getKeyType(), this.getVertexIterator(pushdown), this.getEdgeIterator(pushdown), pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(List<K> keys, IStatePushDown pushdown) {
        return new KeysIterator(keys, this::getOneDegreeGraph, pushdown);
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        this.flush();
        return new IteratorWithFn(this.getEdgeIterator(pushdown), e -> Tuple.of((Object)e.getSrcId(), (Object)pushdown.getProjector().project(e)));
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(List<K> keys, IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return new IteratorWithFn(this.getEdgeIterator(keys, pushdown), e -> Tuple.of((Object)e.getSrcId(), (Object)pushdown.getProjector().project(e)));
    }

    public Map<K, Long> getAggResult(IStatePushDown pushdown) {
        HashMap<Object, Long> res = new HashMap<Object, Long>();
        EdgeListScanIterator<K, EV> it = new EdgeListScanIterator<K, EV>(this.getEdgeIterator(pushdown));
        while (it.hasNext()) {
            List edges = (List)it.next();
            Object key = ((IEdge)edges.get(0)).getSrcId();
            res.put(key, Long.valueOf(edges.size()));
        }
        return res;
    }

    public Map<K, Long> getAggResult(List<K> keys, IStatePushDown pushdown) {
        HashMap<K, Long> res = new HashMap<K, Long>(keys.size());
        Function<Object, IStatePushDown> pushdownFun = pushdown.getFilters() == null ? key -> pushdown : key -> StatePushDown.of().withFilter((IFilter)pushdown.getFilters().get(key));
        for (K key2 : keys) {
            List<IEdge<K, EV>> list = this.getEdges(key2, pushdownFun.apply(key2));
            res.put(key2, Long.valueOf(list.size()));
        }
        return res;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

