/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.utils;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.utils.RetryCommand;
import com.antgroup.geaflow.utils.client.HttpResponse;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Callable;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Gson GSON = new Gson();
    private static final int DEFAULT_RETRY_TIMES = 3;

    public static Object post(String url, String json) {
        return HttpUtil.post(url, json, Object.class);
    }

    public static Object post(String url, String json, Map<String, String> headers) {
        return HttpUtil.post(url, json, headers, Object.class);
    }

    public static <T> T post(String url, String json, Class<T> resultClass) {
        return HttpUtil.post(url, json, null, resultClass);
    }

    public static <T> T post(final String url, String body, Map<String, String> headers, final Class<T> resultClass) {
        LOGGER.info("post url: {} body: {}", (Object)url, (Object)body);
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (String)body);
        Request.Builder builder = HttpUtil.getRequestBuilder(url, headers);
        final Request request = builder.post(requestBody).build();
        final long t = System.currentTimeMillis();
        final OkHttpClient client = new OkHttpClient();
        return (T)RetryCommand.run((Callable)new Callable<T>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T call() throws Exception {
                try (Response response = client.newCall(request).execute();){
                    String msg;
                    ResponseBody responseBody = response.body();
                    String string = msg = responseBody != null ? responseBody.string() : "{}";
                    if (!response.isSuccessful()) {
                        throw new GeaflowRuntimeException(RuntimeErrors.INST.undefinedError(msg));
                    }
                    HttpResponse httpResponse = (HttpResponse)GSON.fromJson(msg, HttpResponse.class);
                    if (!httpResponse.isSuccess()) {
                        throw new GeaflowRuntimeException(RuntimeErrors.INST.undefinedError(msg));
                    }
                    Object result = GSON.fromJson(httpResponse.getData(), resultClass);
                    LOGGER.info("post {} response cost {}ms: {}", new Object[]{url, System.currentTimeMillis() - t, msg});
                    Object object = result;
                    return object;
                }
                catch (IOException e) {
                    LOGGER.info("execute post failed: {}", (Object)e.getCause(), (Object)e);
                    throw new GeaflowRuntimeException((Throwable)e);
                }
            }
        }, (int)3);
    }

    public static <T> T get(String url, Map<String, String> headers, Class<T> resultClass) {
        return HttpUtil.get(url, headers, resultClass);
    }

    public static <T> T get(final String url, Map<String, String> headers, final Type typeOfT) {
        LOGGER.info("get url: {}", (Object)url);
        Request.Builder builder = HttpUtil.getRequestBuilder(url, headers);
        final Request request = builder.get().build();
        final long t = System.currentTimeMillis();
        final OkHttpClient client = new OkHttpClient();
        return (T)RetryCommand.run((Callable)new Callable<T>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T call() throws Exception {
                try (Response response = client.newCall(request).execute();){
                    String msg;
                    ResponseBody responseBody = response.body();
                    String string = msg = responseBody != null ? responseBody.string() : "{}";
                    if (!response.isSuccessful()) {
                        throw new GeaflowRuntimeException(RuntimeErrors.INST.undefinedError(msg));
                    }
                    HttpResponse httpResponse = (HttpResponse)GSON.fromJson(msg, HttpResponse.class);
                    if (!httpResponse.isSuccess()) {
                        throw new GeaflowRuntimeException(RuntimeErrors.INST.undefinedError(msg));
                    }
                    Object result = GSON.fromJson(httpResponse.getData(), typeOfT);
                    LOGGER.info("get {} response cost {}ms: {}", new Object[]{url, System.currentTimeMillis() - t, msg});
                    Object object = result;
                    return object;
                }
                catch (IOException e) {
                    LOGGER.info("execute get failed: {}", (Object)e.getCause(), (Object)e);
                    throw new GeaflowRuntimeException((Throwable)e);
                }
            }
        }, (int)3);
    }

    public static boolean delete(String url) {
        return HttpUtil.delete(url, null);
    }

    public static boolean delete(final String url, Map<String, String> headers) {
        LOGGER.info("delete url: {}", (Object)url);
        final OkHttpClient client = new OkHttpClient();
        Request.Builder requestBuilder = HttpUtil.getRequestBuilder(url, headers);
        final Request request = requestBuilder.delete().build();
        final long t = System.currentTimeMillis();
        return (Boolean)RetryCommand.run((Callable)new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                try (Response response = client.newCall(request).execute();){
                    String msg;
                    ResponseBody body = response.body();
                    String string = msg = body != null ? body.string() : "{}";
                    if (!response.isSuccessful()) {
                        throw new GeaflowRuntimeException(RuntimeErrors.INST.undefinedError(msg));
                    }
                    LOGGER.info("delete {} cost {}ms", (Object)url, (Object)(System.currentTimeMillis() - t));
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    LOGGER.info("execute delete failed: {}", (Object)e.getCause(), (Object)e);
                    throw new GeaflowRuntimeException((Throwable)e);
                }
            }
        }, (int)3);
    }

    private static Request.Builder getRequestBuilder(String url, Map<String, String> headers) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (headers != null) {
            Headers requestHeaders = Headers.of(headers);
            requestBuilder.headers(requestHeaders);
        }
        return requestBuilder;
    }
}

