/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.utils.download;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadUtil.class);

    public static void downloadJarFile(String jarUrl, String destination) throws Exception {
        try (InputStream is = null;){
            LOGGER.info("download {} to local {}", (Object)jarUrl, (Object)destination);
            File targetFile = new File(destination);
            if (targetFile.exists() && targetFile.isFile()) {
                LOGGER.info("file is already downloaded");
                return;
            }
            is = DownloadUtil.getDownloadInputStream(jarUrl);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)targetFile);
            LOGGER.info("download done");
        }
    }

    private static InputStream getDownloadInputStream(String uploadUrl) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        int status = connection.getResponseCode();
        if (status == 403) {
            String msg = String.format("Down jar failed, invalid url: %s", uploadUrl);
            LOGGER.error(msg);
            throw new GeaflowRuntimeException("DOWNLOAD_JAR_ERROR:" + msg);
        }
        InputStream is = connection.getInputStream();
        return is;
    }
}

