/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.utils.download;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.OSSObject;
import com.antgroup.geaflow.utils.download.OssConf;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OssUtil.class);
    private final OSSClient ossClient;
    private final String downLoadUrl;
    private final OssConf ossConf;

    public OssUtil(OssConf ossConf) {
        this.ossClient = new OSSClient(ossConf.getEndPoint(), (CredentialsProvider)new DefaultCredentialProvider(ossConf.getAccessKeyId(), ossConf.getSecretAccessKey()), null);
        this.ossConf = ossConf;
        this.downLoadUrl = this.getDownLoadUrl("");
    }

    public InputStream download(String path) throws Exception {
        if (path.startsWith("http")) {
            if (path.startsWith(this.downLoadUrl)) {
                path = path.substring(this.downLoadUrl.length());
            } else {
                LOGGER.error("download oss path is wrong,path is {}", (Object)path);
                throw new RuntimeException("ERROR_UPLOAD_PATH,path:" + path);
            }
        }
        OSSObject ossObject = this.ossClient.getObject(this.ossConf.getBucket(), path);
        return ossObject.getObjectContent();
    }

    private String getDownLoadUrl(String path) {
        StringBuilder sb = new StringBuilder("http://").append(this.ossConf.getEndPoint());
        sb.insert(sb.indexOf("//") + 2, this.ossConf.getBucket() + ".");
        sb.append("/");
        sb.append(path);
        return sb.toString();
    }
}

