/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.utils.keygroup;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class KeyGroup
implements Serializable {
    private final int startKeyGroup;
    private final int endKeyGroup;

    public KeyGroup(int startKeyGroup, int endKeyGroup) {
        Preconditions.checkArgument((startKeyGroup >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startKeyGroup <= endKeyGroup ? 1 : 0) != 0);
        this.startKeyGroup = startKeyGroup;
        this.endKeyGroup = endKeyGroup;
        Preconditions.checkArgument((this.getNumberOfKeyGroups() >= 0 ? 1 : 0) != 0, (Object)"Potential overflow detected.");
    }

    public int getNumberOfKeyGroups() {
        return 1 + this.endKeyGroup - this.startKeyGroup;
    }

    public int getStartKeyGroup() {
        return this.startKeyGroup;
    }

    public int getEndKeyGroup() {
        return this.endKeyGroup;
    }

    public int hashCode() {
        return Objects.hash(this.startKeyGroup, this.endKeyGroup);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyGroup)) {
            return false;
        }
        KeyGroup keyGroup = (KeyGroup)obj;
        return this.startKeyGroup == keyGroup.getStartKeyGroup() && this.endKeyGroup == keyGroup.getEndKeyGroup();
    }

    public String toString() {
        return "KeyGroup{startKeyGroup=" + this.startKeyGroup + ", endKeyGroup=" + this.endKeyGroup + '}';
    }
}

