/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.utils.keygroup;

import com.antgroup.geaflow.utils.keygroup.KeyGroup;
import com.antgroup.geaflow.utils.math.MathUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class KeyGroupAssignment {
    public static KeyGroup computeKeyGroupRangeForOperatorIndex(int maxParallelism, int parallelism, int index) {
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0, (Object)"maxParallelism should be > 0");
        if (parallelism > maxParallelism) {
            throw new IllegalArgumentException("Maximum parallelism " + maxParallelism + " must not be smaller than parallelism " + parallelism);
        }
        int start = index == 0 ? 0 : (index * maxParallelism - 1) / parallelism + 1;
        int end = ((index + 1) * maxParallelism - 1) / parallelism;
        return new KeyGroup(start, end);
    }

    public static int assignKeyToParallelTask(Object key, int maxParallelism, int parallelism) {
        return KeyGroupAssignment.computeTaskIndexForKeyGroup(maxParallelism, parallelism, KeyGroupAssignment.assignToKeyGroup(key, maxParallelism));
    }

    public static int computeTaskIndexForKeyGroup(int maxParallelism, int parallelism, int keyGroupId) {
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0, (Object)"maxParallelism should be > 0");
        if (parallelism > maxParallelism) {
            throw new IllegalArgumentException("Maximum parallelism " + maxParallelism + " must not be smaller than parallelism " + parallelism);
        }
        return keyGroupId * parallelism / maxParallelism;
    }

    public static int assignToKeyGroup(Object key, int maxParallelism) {
        return KeyGroupAssignment.computeKeyGroupForKeyHash(key.hashCode(), maxParallelism);
    }

    public static int computeKeyGroupForKeyHash(int keyHash, int maxParallelism) {
        return MathUtil.murmurHash(keyHash) % maxParallelism;
    }

    @VisibleForTesting
    public static Map<Integer, List<Integer>> computeKeyGroupToTask(int maxParallelism, List<Integer> targetTasks) {
        ConcurrentHashMap<Integer, List<Integer>> keyGroupToTask = new ConcurrentHashMap<Integer, List<Integer>>();
        for (int index = 0; index < targetTasks.size(); ++index) {
            KeyGroup taskKeyGroup = KeyGroupAssignment.computeKeyGroupRangeForOperatorIndex(maxParallelism, targetTasks.size(), index);
            for (int groupId = taskKeyGroup.getStartKeyGroup(); groupId <= taskKeyGroup.getEndKeyGroup(); ++groupId) {
                keyGroupToTask.put(groupId, (List<Integer>)ImmutableList.of((Object)targetTasks.get(index)));
            }
        }
        return keyGroupToTask;
    }
}

