/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.utils.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MathUtil {
    public static final long SECOND_IN_MS = 1000L;
    public static final long MINUTE_IN_MS = 60000L;
    public static final long HOUR_IN_MS = 3600000L;
    public static final long MINUTE = 60L;
    public static final long HOUR = 3600L;
    public static final int MAXIMUM_CAPACITY = 0x40000000;

    private MathUtil() {
    }

    public static int[] deviates(long[] values, long buffer, double factor) {
        if (values == null || values.length == 0) {
            return new int[0];
        }
        long avg = MathUtil.average(values);
        long minimumDiff = Math.max(buffer, (long)((double)avg * factor));
        ArrayList<Integer> deviatedElements = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            long diff = values[i] - avg;
            if (diff <= minimumDiff) continue;
            deviatedElements.add(i);
        }
        int[] result = new int[deviatedElements.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)deviatedElements.get(i);
        }
        return result;
    }

    public static long percentile(List<Long> values, int percentile) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Percentile of empty list is not defined.");
        }
        if (percentile > 100 || percentile < 0) {
            throw new IllegalArgumentException("Percentile has to be between 0-100");
        }
        if (percentile == 0) {
            return 0L;
        }
        Collections.sort(values);
        int position = (int)Math.ceil((double)(values.size() * percentile) / 100.0);
        if (position == 0) {
            return values.get(position);
        }
        return values.get(position - 1);
    }

    public static int murmurHash(int code) {
        code *= -862048943;
        code = Integer.rotateLeft(code, 15);
        code *= 461845907;
        code = Integer.rotateLeft(code, 13);
        code = code * 5 + -430675100;
        code ^= 4;
        if ((code = MathUtil.bitMix(code)) >= 0) {
            return code;
        }
        if (code != Integer.MIN_VALUE) {
            return -code;
        }
        return 0;
    }

    public static long[][] findTwoGroups(long[] values) {
        return MathUtil.findTwoGroupsRecursive(values, MathUtil.average(values), 2);
    }

    public static long[][] findTwoGroupsRecursive(long[] values, long middle, int levels) {
        if (levels > 0) {
            long[][] result = MathUtil.twoMeans(values, middle);
            long newMiddle = MathUtil.average(result[1]) - MathUtil.average(result[0]);
            return MathUtil.findTwoGroupsRecursive(values, newMiddle, levels - 1);
        }
        return MathUtil.twoMeans(values, middle);
    }

    private static long[][] twoMeans(long[] values, long middle) {
        ArrayList<Long> smaller = new ArrayList<Long>();
        ArrayList<Long> larger = new ArrayList<Long>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] < middle) {
                smaller.add(values[i]);
                continue;
            }
            larger.add(values[i]);
        }
        long[][] result = new long[][]{MathUtil.toArray(smaller), MathUtil.toArray(larger)};
        return result;
    }

    private static long[] toArray(List<Long> input) {
        long[] result = new long[input.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = input.get(i);
        }
        return result;
    }

    public static long average(long[] values) {
        double sum = 0.0;
        for (long value : values) {
            sum += (double)value;
        }
        return (long)(sum / (double)values.length);
    }

    public static long average(List<Long> values) {
        double sum = 0.0;
        for (long value : values) {
            sum += (double)value;
        }
        return (long)(sum / (double)values.size());
    }

    public static long median(List<Long> values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Median of an empty list is not defined.");
        }
        Collections.sort(values);
        int middle = values.size() / 2;
        if (values.size() % 2 == 0) {
            return (values.get(middle - 1) + values.get(middle)) / 2L;
        }
        return values.get(middle);
    }

    public static int findNextPositivePowerOfTwo(int value) {
        assert (value > Integer.MIN_VALUE && value < 0x40000000);
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static int safeFindNextPositivePowerOfTwo(int value) {
        return value <= 0 ? 1 : (value >= 0x40000000 ? 0x40000000 : MathUtil.findNextPositivePowerOfTwo(value));
    }

    public static boolean isPrime(int n) {
        int i = 2;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int nextPrime(int n) {
        for (int num = n; num < n * 2; ++num) {
            if (!MathUtil.isPrime(num)) continue;
            return num;
        }
        return n;
    }

    public static int longToIntWithBitMixing(long in) {
        in = (in ^ in >>> 30) * -4658895280553007687L;
        in = (in ^ in >>> 27) * -7723592293110705685L;
        in ^= in >>> 31;
        return (int)in;
    }

    public static int bitMix(int in) {
        in ^= in >>> 16;
        in *= -2048144789;
        in ^= in >>> 13;
        in *= -1028477387;
        in ^= in >>> 16;
        return in;
    }

    public static int multiplesOf50(int input) {
        return input / 50 * 50;
    }

    public static boolean isPowerOf2(int input) {
        if (input > 0) {
            return input == 1 || (input & -input) == input;
        }
        return false;
    }

    public static int minPowerOf2(int input) {
        int n = input - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }
}

