/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.view.meta;

import com.antgroup.geaflow.file.FileInfo;
import com.antgroup.geaflow.file.IPersistentIO;
import com.antgroup.geaflow.view.meta.ViewMetaPb;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewMeta.class);
    private static final String BACKUP_SUFFIX = ".bak";
    private static final String TMP_SUFFIX = ".tmp";
    private final Map<String, ByteString> innerKV = new HashMap<String, ByteString>();
    private final String filePath;
    private final IPersistentIO persistIO;
    private long fileModifyTS;

    public ViewMeta(String filePath, IPersistentIO persistentIO) throws IOException {
        this.filePath = filePath;
        this.persistIO = persistentIO;
        if (persistentIO.exists(new Path(filePath))) {
            this.readFile(filePath);
        } else if (this.persistIO.exists(new Path(filePath + BACKUP_SUFFIX))) {
            this.readFile(filePath + BACKUP_SUFFIX);
        }
    }

    private void readFile(String strFilePath) throws IOException {
        FileInfo info = this.persistIO.getFileInfo(new Path(strFilePath));
        InputStream stream = this.persistIO.open(new Path(strFilePath));
        byte[] content = new byte[(int)info.getLength()];
        stream.read(content);
        stream.close();
        ViewMetaPb.ViewMeta viewMeta = ViewMetaPb.ViewMeta.parseFrom(content);
        this.innerKV.putAll(viewMeta.getKvInfoMap());
        this.fileModifyTS = info.getModificationTime();
    }

    public void tryRefresh() throws IOException {
        if (!this.persistIO.exists(new Path(this.filePath))) {
            return;
        }
        long currentModifyTime = this.persistIO.getFileInfo(new Path(this.filePath)).getModificationTime();
        if (currentModifyTime > this.fileModifyTS) {
            LOGGER.info("refresh {}", (Object)this.filePath);
            this.readFile(this.filePath);
        } else {
            LOGGER.info("last {} now {}", (Object)this.fileModifyTS, (Object)currentModifyTime);
        }
    }

    public Map<String, ByteString> getKVMap() {
        return this.innerKV;
    }

    public byte[] toBinary() {
        return ViewMetaPb.ViewMeta.newBuilder().putAllKvInfo(this.innerKV).build().toByteArray();
    }

    public void archive() throws IOException {
        long start = System.currentTimeMillis();
        if (this.persistIO.exists(new Path(this.filePath))) {
            this.persistIO.delete(new Path(this.filePath + BACKUP_SUFFIX), false);
            boolean res = this.persistIO.rename(new Path(this.filePath), new Path(this.filePath + BACKUP_SUFFIX));
            Preconditions.checkArgument((boolean)res, (Object)("rename fail " + this.filePath));
        }
        java.nio.file.Path path = Files.createTempFile("tmp", TMP_SUFFIX, new FileAttribute[0]);
        Files.write(path, this.toBinary(), new OpenOption[0]);
        this.persistIO.copyFromLocalFile(new Path(path.toString()), new Path(this.filePath + TMP_SUFFIX));
        Files.deleteIfExists(path);
        boolean res = this.persistIO.rename(new Path(this.filePath + TMP_SUFFIX), new Path(this.filePath));
        Preconditions.checkArgument((boolean)res, (Object)("rename fail " + this.filePath + TMP_SUFFIX));
        if (this.persistIO.exists(new Path(this.filePath + BACKUP_SUFFIX))) {
            this.persistIO.delete(new Path(this.filePath + BACKUP_SUFFIX), false);
        }
        LOGGER.info("save {} cost {}ms", (Object)this.filePath, (Object)(System.currentTimeMillis() - start));
    }
}

