/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.view.meta;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.common.utils.FileUtil;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.antgroup.geaflow.file.IPersistentIO;
import com.antgroup.geaflow.file.PersistentIOBuilder;
import com.antgroup.geaflow.view.meta.ViewMeta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewMetaBookKeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewMetaBookKeeper.class);
    private static final String VIEW_VERSION = "view_version";
    private final String viewName;
    private final ViewMetaKeeper viewMetaKeeper;

    public ViewMetaBookKeeper(String myViewName, Configuration config) {
        this.viewName = myViewName;
        this.viewMetaKeeper = new ViewMetaKeeper();
        this.viewMetaKeeper.init(myViewName, config);
    }

    public long getLatestViewVersion(String name) throws IOException {
        byte[] res = this.viewMetaKeeper.get(name, VIEW_VERSION);
        return res == null ? -1L : Longs.fromByteArray((byte[])res);
    }

    public void saveViewVersion(long viewVersion) throws IOException {
        this.viewMetaKeeper.save(VIEW_VERSION, Longs.toByteArray((long)viewVersion));
        LOGGER.info("save view version {} {}", (Object)this.viewName, (Object)viewVersion);
    }

    public void archive() {
        try {
            this.viewMetaKeeper.archive();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getViewName() {
        return this.viewName;
    }

    public static class ViewMetaKeeper {
        private static final String INFO_FILE_NAME = "view.meta";
        private static final long SHARED_STATE_INFO_REFRESH_MS_THRESHOLD = 1000L;
        private IPersistentIO persistIO;
        private Map<String, Tuple<ViewMeta, Long>> sharedViewMeta = new HashMap<String, Tuple<ViewMeta, Long>>();
        private ViewMeta myStateInfo;
        private String myViewName;
        private String namespace;

        public void init(String viewName, Configuration config) {
            this.myViewName = viewName;
            this.persistIO = PersistentIOBuilder.build((Configuration)config);
            this.namespace = config.getString(FileConfigKeys.ROOT);
        }

        private ViewMeta getOrInit(String viewName) throws IOException {
            boolean isMyself = this.myViewName.equals(viewName);
            if (!isMyself) {
                ViewMeta viewMeta;
                Tuple<ViewMeta, Long> tuple = this.sharedViewMeta.get(viewName);
                if (tuple == null) {
                    String file = FileUtil.concatPath((String)this.namespace, (String)viewName) + "/" + INFO_FILE_NAME;
                    viewMeta = new ViewMeta(file, this.persistIO);
                    this.sharedViewMeta.put(viewName, (Tuple<ViewMeta, Long>)Tuple.of((Object)viewMeta, (Object)System.currentTimeMillis()));
                } else if (System.currentTimeMillis() - (Long)tuple.f1 > 1000L) {
                    this.tryRefresh(tuple);
                    viewMeta = (ViewMeta)tuple.f0;
                } else {
                    viewMeta = (ViewMeta)tuple.f0;
                }
                return viewMeta;
            }
            if (this.myStateInfo == null) {
                String file = FileUtil.concatPath((String)this.namespace, (String)viewName) + "/" + INFO_FILE_NAME;
                this.myStateInfo = new ViewMeta(file, this.persistIO);
            }
            return this.myStateInfo;
        }

        private void tryRefresh(Tuple<ViewMeta, Long> tuple) throws IOException {
            ((ViewMeta)tuple.f0).tryRefresh();
            tuple.f1 = System.currentTimeMillis();
        }

        public void save(String k, byte[] v) throws IOException {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
            ViewMeta stateInfo = this.getOrInit(this.myViewName);
            stateInfo.getKVMap().put(k, ByteString.copyFrom((byte[])v));
        }

        public byte[] get(String k) throws IOException {
            return this.get(this.myViewName, k);
        }

        public byte[] get(String viewName, String k) throws IOException {
            ViewMeta viewMeta = this.getOrInit(viewName);
            Preconditions.checkNotNull((Object)viewMeta);
            ByteString value = viewMeta.getKVMap().get(k);
            if (value == null) {
                return null;
            }
            return value.toByteArray();
        }

        public void archive() throws IOException {
            long t = System.currentTimeMillis();
            this.myStateInfo.archive();
            LOGGER.info("archive view meta cost {}ms", (Object)(System.currentTimeMillis() - t));
        }
    }
}

