/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.tugraph;

import com.antgroup.tugraph.InputException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class FileCutter {
    private FileInputStream stream;
    private long readBytes = 0L;
    static final int ONLINE_IMPORT_LIMIT_SOFT = 0x1000000;
    static final int ONLINE_IMPORT_LIMIT_HARD = 0x1100000;

    public FileCutter(String filename) throws FileNotFoundException {
        this.stream = new FileInputStream(filename);
    }

    public byte[] cut() throws IOException {
        byte[] buf = new byte[0x1100000];
        int bytes = 0;
        bytes = this.stream.read(buf, 0, 0x1000000);
        if (bytes == -1) {
            return null;
        }
        this.readBytes += (long)bytes;
        while (buf[bytes - 1] != 10) {
            this.stream.read(buf, bytes, 1);
            ++bytes;
            ++this.readBytes;
        }
        if (bytes >= 0x1100000) {
            throw new InputException("too long input line");
        }
        return Arrays.copyOf(buf, bytes);
    }

    int lineCount(byte[] buf) {
        int count = 0;
        int idx = 0;
        while ((long)idx < this.readBytes) {
            if (buf[idx] == 10) {
                ++count;
            }
            ++idx;
        }
        return count;
    }
}

