/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.tugraph;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.antgroup.tugraph.CsvDesc;
import com.antgroup.tugraph.FileCutter;
import com.antgroup.tugraph.InputException;
import com.antgroup.tugraph.TuGraphDbRpcException;
import com.antgroup.tugraph.TuGraphDbService;
import com.antgroup.tugraph.model.BuiltInProcedure;
import com.antgroup.tugraph.model.ClusterInfo;
import com.antgroup.tugraph.model.GraphQueryConstant;
import com.antgroup.tugraph.model.RaftState;
import com.antgroup.tugraph.model.UserDefinedProcedure;
import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcClientOptions;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import lgraph.Lgraph;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuGraphDbRpcClient {
    private static final Logger log = LoggerFactory.getLogger(TuGraphDbRpcClient.class);
    private final ClientType clientType;
    private final String user;
    private final String password;
    private TuGraphSingleRpcClient baseClient;
    private List<String> urls;
    private TuGraphSingleRpcClient leaderClient;
    private final List<TuGraphSingleRpcClient> rpcClientPool = new CopyOnWriteArrayList<TuGraphSingleRpcClient>();
    private List<UserDefinedProcedure> userDefinedProcedures = new CopyOnWriteArrayList<UserDefinedProcedure>();
    private List<BuiltInProcedure> builtInProcedures = new CopyOnWriteArrayList<BuiltInProcedure>();

    public TuGraphDbRpcClient(String url, String user, String password) throws Exception {
        ClientType type;
        this.user = user;
        this.password = password;
        this.baseClient = new TuGraphSingleRpcClient("list://" + url, user, password);
        try {
            this.baseClient.callCypher("CALL dbms.ha.clusterInfo()", "default", 10.0);
            type = ClientType.DIRECT_HA_CONNECTION;
        }
        catch (Exception e) {
            type = ClientType.SINGLE_CONNECTION;
        }
        this.clientType = type;
        if (this.clientType == ClientType.DIRECT_HA_CONNECTION) {
            this.refreshConnection();
        }
    }

    public TuGraphDbRpcClient(List<String> urls, String user, String password) throws Exception {
        this.urls = urls;
        this.clientType = ClientType.INDIRECT_HA_CONNECTION;
        this.user = user;
        this.password = password;
        this.refreshConnection();
    }

    public String callCypher(String cypher, String graph, double timeout) throws Exception {
        return this.callCypher(cypher, graph, timeout, false);
    }

    public String callCypher(String cypher, String graph, double timeout, boolean withHeader) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callCypher(cypher, graph, timeout, withHeader);
        }
        return this.doubleCheckQuery(() -> this.getClient(Lgraph.ProtoGraphQueryType.CYPHER, cypher, graph).callCypher(cypher, graph, timeout, withHeader));
    }

    public String callGql(String gql, String graph, double timeout) throws Exception {
        return this.callGql(gql, graph, timeout, false);
    }

    public String callGql(String gql, String graph, double timeout, boolean withHeader) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callGql(gql, graph, timeout, withHeader);
        }
        return this.doubleCheckQuery(() -> this.getClient(Lgraph.ProtoGraphQueryType.GQL, gql, graph).callGql(gql, graph, timeout, withHeader));
    }

    public String callCypher(String cypher, String graph, double timeout, String url) throws Exception {
        return this.doubleCheckQuery(() -> this.getClientByNode(url).callCypher(cypher, graph, timeout));
    }

    public String callCypher(String cypher, String graph, double timeout, String url, boolean withHeader) throws Exception {
        return this.doubleCheckQuery(() -> this.getClientByNode(url).callCypher(cypher, graph, timeout, withHeader));
    }

    public String callGql(String gql, String graph, double timeout, String url) throws Exception {
        return this.doubleCheckQuery(() -> this.getClientByNode(url).callGql(gql, graph, timeout));
    }

    public String callGql(String gql, String graph, double timeout, String url, boolean withHeader) throws Exception {
        return this.doubleCheckQuery(() -> this.getClientByNode(url).callGql(gql, graph, timeout, withHeader));
    }

    public String callCypherToLeader(String cypher, String graph, double timeout) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callCypher(cypher, graph, timeout);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.callCypher(cypher, graph, timeout));
    }

    public String callCypherToLeader(String cypher, String graph, double timeout, boolean withHeader) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callCypher(cypher, graph, timeout, withHeader);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.callCypher(cypher, graph, timeout, withHeader));
    }

    public String callGqlToLeader(String gql, String graph, double timeout) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callGql(gql, graph, timeout);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.callGql(gql, graph, timeout));
    }

    public String callGqlToLeader(String gql, String graph, double timeout, boolean withHeader) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callGql(gql, graph, timeout, withHeader);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.callGql(gql, graph, timeout, withHeader));
    }

    public String callProcedure(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph) throws Exception {
        return this.callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, false);
    }

    public String callProcedure(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph, boolean withHeader) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, withHeader);
        }
        return this.doubleCheckQuery(() -> {
            boolean readOnly = false;
            for (UserDefinedProcedure userDefinedProcedure : this.userDefinedProcedures) {
                if (!userDefinedProcedure.getDesc().getName().equals(procedureName) || !userDefinedProcedure.getDesc().isReadOnly()) continue;
                readOnly = true;
                break;
            }
            return this.getClient(readOnly).callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, withHeader);
        });
    }

    public String callProcedure(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph, String url) throws Exception {
        return this.callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, false, url);
    }

    public String callProcedure(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph, boolean withHeader, String url) throws Exception {
        return this.doubleCheckQuery(() -> this.getClientByNode(url).callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, withHeader));
    }

    public String callProcedureToLeader(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph) throws Exception {
        return this.callProcedureToLeader(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, false);
    }

    public String callProcedureToLeader(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph, boolean withHeader) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, withHeader);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.callProcedure(procedureType, procedureName, param, procedureTimeOut, inProcess, graph, withHeader));
    }

    public boolean loadProcedure(String sourceFile, String procedureType, String procedureName, String codeType, String procedureDescription, boolean readOnly, String version, String graph) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.loadProcedure(sourceFile, procedureType, procedureName, codeType, procedureDescription, readOnly, version, graph);
        }
        return this.doubleCheckQuery(() -> {
            boolean succeed = this.leaderClient.loadProcedure(sourceFile, procedureType, procedureName, codeType, procedureDescription, readOnly, version, graph);
            if (succeed) {
                this.refreshUserDefinedProcedure();
            }
            return succeed;
        });
    }

    public boolean loadProcedure(String[] sourceFiles, String procedureType, String procedureName, String codeType, String procedureDescription, boolean readOnly, String version, String graph) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.loadProcedure(sourceFiles, procedureType, procedureName, codeType, procedureDescription, readOnly, version, graph);
        }
        return this.doubleCheckQuery(() -> {
            boolean succeed = this.leaderClient.loadProcedure(sourceFiles, procedureType, procedureName, codeType, procedureDescription, readOnly, version, graph);
            if (succeed) {
                this.refreshUserDefinedProcedure();
            }
            return succeed;
        });
    }

    public String listProcedures(String procedureType, String version, String graph) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.listProcedures(procedureType, version, graph);
        }
        return this.doubleCheckQuery(() -> this.getClient(true).listProcedures(procedureType, version, graph));
    }

    public String listProcedures(String procedureType, String version, String graph, String url) throws Exception {
        return this.doubleCheckQuery(() -> this.getClientByNode(url).listProcedures(procedureType, version, graph));
    }

    public boolean deleteProcedure(String procedureType, String procedureName, String graph) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.deleteProcedure(procedureType, procedureName, graph);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.deleteProcedure(procedureType, procedureName, graph));
    }

    public boolean importSchemaFromContent(String schema, String graph, double timeout) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.importSchemaFromContent(schema, graph, timeout);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.importSchemaFromContent(schema, graph, timeout));
    }

    public boolean importDataFromContent(String desc, String data, String delimiter, boolean continueOnError, int threadNums, String graph, double timeout) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.importDataFromContent(desc, data, delimiter, continueOnError, threadNums, graph, timeout);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.importDataFromContent(desc, data, delimiter, continueOnError, threadNums, graph, timeout));
    }

    public boolean importSchemaFromFile(String schemaFile, String graph, double timeout) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.importSchemaFromFile(schemaFile, graph, timeout);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.importSchemaFromFile(schemaFile, graph, timeout));
    }

    public boolean importDataFromFile(String confFile, String delimiter, boolean continueOnError, int threadNums, int skipPackages, String graph, double timeout) throws Exception {
        if (this.clientType == ClientType.SINGLE_CONNECTION) {
            return this.baseClient.importDataFromFile(confFile, delimiter, continueOnError, threadNums, skipPackages, graph, timeout);
        }
        return this.doubleCheckQuery(() -> this.leaderClient.importDataFromFile(confFile, delimiter, continueOnError, threadNums, skipPackages, graph, timeout));
    }

    public void logout() throws Exception {
        if (this.clientType != ClientType.INDIRECT_HA_CONNECTION) {
            this.baseClient.logout();
        }
        for (TuGraphSingleRpcClient rpcClient : this.rpcClientPool) {
            rpcClient.logout();
        }
    }

    protected void finalize() {
        try {
            this.logout();
        }
        catch (Exception e) {
            log.info("RpcHAClient already logout!");
        }
    }

    private void refreshConnection() throws Exception {
        try {
            this.refreshClientPool();
            this.refreshUserDefinedProcedure();
            this.refreshBuiltInProcedure();
        }
        catch (Exception e) {
            log.info("RpcHAClient Connection Exception, please connect again!");
            log.info(e.getMessage());
            throw e;
        }
    }

    private boolean isReadQuery(Lgraph.ProtoGraphQueryType type, String query, String graphName) {
        GraphQueryConstant graphQueryConstant = new GraphQueryConstant();
        if (query.toUpperCase().contains("CALL ")) {
            return this.builtInProcedures.stream().anyMatch(x -> query.contains(x.getName()) && x.isReadOnly()) && this.userDefinedProcedures.stream().anyMatch(x -> query.contains(x.getDesc().getName()) && x.getGraphName().equals(graphName) && x.getDesc().isReadOnly());
        }
        if (type == Lgraph.ProtoGraphQueryType.CYPHER) {
            return graphQueryConstant.getAllCypherType().stream().noneMatch(x -> query.toLowerCase().contains((CharSequence)x));
        }
        return graphQueryConstant.getAllGqlType().stream().noneMatch(x -> query.toLowerCase().contains((CharSequence)x));
    }

    private TuGraphSingleRpcClient getClient(Lgraph.ProtoGraphQueryType type, String query, String graph) throws Exception {
        return this.getClient(this.isReadQuery(type, query, graph));
    }

    private TuGraphSingleRpcClient getClient(boolean isReadQuery) throws Exception {
        if (isReadQuery) {
            if (this.rpcClientPool.size() == 0) {
                throw new Exception("all instance is down, refuse req!");
            }
            TuGraphSingleRpcClient rpcClient = this.rpcClientPool.get(this.rpcClientPool.size() - 1);
            this.loadBalance();
            return rpcClient;
        }
        if (this.leaderClient == null) {
            throw new Exception("master instance is down, refuse req!");
        }
        return this.leaderClient;
    }

    private TuGraphSingleRpcClient getClientByNode(String ipAndPort) throws Exception {
        for (TuGraphSingleRpcClient rpcClient : this.rpcClientPool) {
            if (!rpcClient.getUrl().contains(ipAndPort)) continue;
            return rpcClient;
        }
        throw new Exception("do not exit " + ipAndPort + " client");
    }

    private void refreshClientPool() {
        this.rpcClientPool.clear();
        if (this.clientType == ClientType.DIRECT_HA_CONNECTION) {
            String result = this.baseClient.callCypher("CALL dbms.ha.clusterInfo()", "default", 10.0);
            ClusterInfo clusterInfo = JSON.parseObject(JSON.parseArray(result).get(0).toString(), new TypeReference<ClusterInfo>(){}, new Feature[0]);
            List<RaftState> raftStates = clusterInfo.getClusterInfo();
            raftStates.forEach(x -> {
                if (!Objects.equals(x.getRole(), "WITNESS")) {
                    TuGraphSingleRpcClient rpcClient = new TuGraphSingleRpcClient("list://" + x.getRpcAddress(), this.user, this.password);
                    this.rpcClientPool.add(rpcClient);
                    if (x.getState().equals("MASTER")) {
                        this.leaderClient = rpcClient;
                    }
                }
            });
        } else {
            for (String url : this.urls) {
                TuGraphSingleRpcClient rpcClient = new TuGraphSingleRpcClient("list://" + url, this.user, this.password);
                String result = rpcClient.callCypher("CALL dbms.ha.clusterInfo()", "default", 10.0);
                ClusterInfo clusterInfo = JSON.parseObject(JSON.parseArray(result).get(0).toString(), new TypeReference<ClusterInfo>(){}, new Feature[0]);
                if (clusterInfo.isMaster()) {
                    this.leaderClient = rpcClient;
                }
                this.rpcClientPool.add(rpcClient);
            }
        }
    }

    private void refreshBuiltInProcedure() throws Exception {
        String result = this.getClient(true).callCypher("CALL dbms.procedures()", "default", 10.0);
        this.builtInProcedures = JSON.parseObject(result, new TypeReference<List<BuiltInProcedure>>(){}, new Feature[0]);
    }

    private void refreshUserDefinedProcedure() throws Exception {
        String result = this.getClient(true).callCypher("CALL db.plugin.listUserPlugins()", "default", 10.0);
        this.userDefinedProcedures = JSON.parseObject(result, new TypeReference<List<UserDefinedProcedure>>(){}, new Feature[0]);
    }

    private void loadBalance() {
        this.rpcClientPool.add(this.rpcClientPool.remove(0));
    }

    private <E> E doubleCheckQuery(QueryInterface<E> queryInterface) throws Exception {
        try {
            return queryInterface.method();
        }
        catch (Exception e1) {
            try {
                this.refreshConnection();
                return queryInterface.method();
            }
            catch (Exception e2) {
                log.error(e2.getMessage());
                throw e2;
            }
        }
    }

    private static class TuGraphSingleRpcClient {
        private static final int TIMEOUTINMS = 3600000;
        private final RpcClient client;
        private final TuGraphDbService tuGraphService;
        private final String token;
        private final String url;
        private long serverVersion;

        public TuGraphSingleRpcClient(String url, String user, String pass) {
            RpcClientOptions options = new RpcClientOptions();
            options.setProtocolType(1);
            options.setLoadBalanceType(3);
            options.setWriteTimeoutMillis(3600000);
            options.setReadTimeoutMillis(3600000);
            this.client = new RpcClient(url, options);
            this.tuGraphService = (TuGraphDbService)BrpcProxy.getProxy(this.client, TuGraphDbService.class);
            Lgraph.LoginRequest loginReq = Lgraph.LoginRequest.newBuilder().setUser(user).setPassword(pass).build();
            Lgraph.AuthRequest authReq = Lgraph.AuthRequest.newBuilder().setLogin(loginReq).build();
            Lgraph.AclRequest req = Lgraph.AclRequest.newBuilder().setAuthRequest(authReq).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setAclRequest(req).setToken("").setIsWriteOp(false).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "TuGraphRpcClient");
            }
            this.token = response.getAclResponse().getAuthResponse().getToken();
            this.serverVersion = response.getServerVersion();
            this.url = url;
        }

        private String handleGraphQueryRequest(Lgraph.ProtoGraphQueryType type, String query, String graph, double timeout, boolean withHeader) {
            Lgraph.GraphQueryRequest queryRequest = Lgraph.GraphQueryRequest.newBuilder().setType(type).setQuery(query).setResultInJsonFormat(!withHeader).setGraph(graph).setTimeout(timeout).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setGraphQueryRequest(queryRequest).setToken(this.token).setClientVersion(this.serverVersion).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "handleGraphQueryRequest");
            }
            this.serverVersion = Math.max(response.getServerVersion(), this.serverVersion);
            if (!withHeader) {
                return response.getGraphQueryResponse().getJsonResult();
            }
            Lgraph.GraphQueryResult graphQueryResult = response.getGraphQueryResponse().getBinaryResult();
            JSONObject ans = new JSONObject();
            JSONArray header = new JSONArray();
            JSONArray result = new JSONArray();
            for (Lgraph.Header headerKV : graphQueryResult.getHeaderList()) {
                JSONObject headerItem = new JSONObject();
                headerItem.put("name", (Object)headerKV.getName());
                headerItem.put("type", (Object)headerKV.getType());
                header.add(headerItem);
            }
            ans.put("header", (Object)header);
            for (Lgraph.ListOfProtoFieldData resultData : graphQueryResult.getResultList()) {
                JSONArray resultItem = new JSONArray();
                for (Lgraph.ProtoFieldData fieldData : resultData.getValuesList()) {
                    switch (fieldData.getDataCase()) {
                        case BOOLEAN: {
                            resultItem.add((Object)fieldData.getBoolean());
                            break;
                        }
                        case INT8_: {
                            resultItem.add((Object)fieldData.getInt8());
                            break;
                        }
                        case INT16_: {
                            resultItem.add((Object)fieldData.getInt16());
                            break;
                        }
                        case INT32_: {
                            resultItem.add((Object)fieldData.getInt32());
                            break;
                        }
                        case INT64_: {
                            resultItem.add((Object)fieldData.getInt64());
                            break;
                        }
                        case SP: {
                            resultItem.add(Float.valueOf(fieldData.getSp()));
                            break;
                        }
                        case DP: {
                            resultItem.add((Object)fieldData.getDp());
                            break;
                        }
                        case DATE: {
                            resultItem.add((Object)fieldData.getDate());
                            break;
                        }
                        case DATETIME: {
                            resultItem.add((Object)fieldData.getDatetime());
                            break;
                        }
                        case STR: {
                            resultItem.add(fieldData.getStr());
                            break;
                        }
                        case BLOB: {
                            resultItem.add(fieldData.getBlob());
                        }
                    }
                }
                result.add(resultItem);
            }
            ans.put("result", (Object)result);
            return ans.toString();
        }

        private String handleCypherRequest(String query, String graph, double timeout, boolean withHeader) {
            return this.handleGraphQueryRequest(Lgraph.ProtoGraphQueryType.CYPHER, query, graph, timeout, withHeader);
        }

        private String handleGqlRequest(String query, String graph, double timeout, boolean withHeader) {
            return this.handleGraphQueryRequest(Lgraph.ProtoGraphQueryType.GQL, query, graph, timeout, withHeader);
        }

        private String parseDelimiter(String delimiter) {
            int size = delimiter.length();
            StringBuilder sb = new StringBuilder();
            for (int idx = 0; idx < size; ++idx) {
                if (delimiter.charAt(idx) == '\\') {
                    int begin = idx++;
                    if (idx == size) {
                        throw new InputException("Illegal escape sequence, do you mean \\?");
                    }
                    char c = delimiter.charAt(idx);
                    switch (c) {
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        case 'a': 
                        case 'v': {
                            throw new InputException("unsupported delimiter in java language");
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'x': {
                            int i;
                            ++idx;
                            int temp = 0;
                            for (i = 0; i < 2; ++i) {
                                if (idx == size) {
                                    throw new InputException("Illegal escape sequence: " + delimiter.substring(begin, idx));
                                }
                                if (delimiter.charAt(idx) >= '0' && delimiter.charAt(idx) <= '9') {
                                    temp = temp * 16 + delimiter.charAt(idx) - 48;
                                } else if (delimiter.charAt(idx) >= 'a' && delimiter.charAt(idx) <= 'f') {
                                    temp = temp * 16 + (delimiter.charAt(idx) - 97 + 10);
                                } else if (delimiter.charAt(idx) >= 'A' && delimiter.charAt(idx) <= 'F') {
                                    temp = temp * 16 + (delimiter.charAt(idx) - 65 + 10);
                                } else {
                                    throw new InputException("Illegal escape sequence: " + delimiter.substring(begin, idx + 1));
                                }
                                ++idx;
                            }
                            sb.append((char)(temp + 48));
                            break;
                        }
                        default: {
                            int i;
                            int temp;
                            if (c >= '0' && c <= '9') {
                                temp = 0;
                                for (i = 0; i < 3; ++i) {
                                    if (idx == size) {
                                        throw new InputException("Illegal escape sequence: " + delimiter.substring(begin, idx));
                                    }
                                    char sc = delimiter.charAt(idx);
                                    if (sc < '0' || sc > '7') {
                                        throw new InputException("Illegal escape sequence: " + delimiter.substring(begin, idx + 1));
                                    }
                                    temp = temp * 8 + sc - 48;
                                    ++idx;
                                }
                                if (temp >= 256) {
                                    throw new InputException("Illegal escape sequence: " + delimiter.substring(begin, idx));
                                }
                                sb.append((char)(temp + 48));
                                break;
                            }
                            throw new InputException("Illegal escape sequence: " + delimiter.substring(begin, idx + 1));
                        }
                    }
                    continue;
                }
                sb.append(delimiter.charAt(idx));
                ++idx;
            }
            return sb.toString();
        }

        private String textFileReader(String path) throws IOException {
            File file = new File(path);
            if (!file.exists() || !file.isFile()) {
                throw new InputException("Illegal file: " + path);
            }
            String result = FileUtils.readFileToString(file, "utf-8");
            return result;
        }

        private byte[] binaryFileReader(String path) throws IOException {
            File file = new File(path);
            if (!file.exists() || !file.isFile()) {
                throw new InputException("Illegal file: " + path);
            }
            long fileSize = file.length();
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), (int)fileSize);){
                byte[] buf = new byte[(int)fileSize];
                int readBytes = in.read(buf, 0, (int)fileSize);
                if ((long)readBytes != fileSize) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = buf;
                return byArray;
            }
        }

        private List<CsvDesc> parseConfigurationFile(JSONObject conf, boolean hasPath) {
            if (!conf.containsKey("files")) {
                return null;
            }
            ArrayList<CsvDesc> list = new ArrayList<CsvDesc>();
            JSONArray array = conf.getJSONArray("files");
            for (Object value : array) {
                JSONObject obj = (JSONObject)value;
                if (!(obj.containsKey("path") && obj.containsKey("format") && obj.containsKey("label") && obj.containsKey("columns"))) {
                    throw new InputException("Missing \"path\" or \"format\" or \"label\" or \"columns\" in json");
                }
                ArrayList<File> files = new ArrayList<File>();
                if (hasPath) {
                    File path = new File(obj.getString("path"));
                    if (!path.exists()) {
                        throw new InputException("Path " + obj.getString("path") + " does not exist in json {}");
                    }
                    if (path.isFile()) {
                        files.add(path);
                    }
                    if (path.isDirectory()) {
                        File[] temp = path.listFiles();
                        assert (temp != null);
                        Collections.addAll(files, temp);
                    }
                } else {
                    files.add(new File(""));
                }
                for (File file : files) {
                    String format;
                    CsvDesc csv = new CsvDesc();
                    if (!StringUtils.isBlank(file.getPath())) {
                        csv.setPath(file.getPath());
                        csv.setSize(file.length());
                    }
                    if (!"JSON".equals(format = obj.getString("format")) && !"CSV".equals(format)) {
                        throw new InputException("\"format\" value error : " + format + "should be CSV or JSON");
                    }
                    csv.setDataFormat(format);
                    csv.setLabel(obj.getString("label"));
                    if (obj.containsKey("header")) {
                        csv.setHeaderLine(obj.getIntValue("header"));
                    }
                    boolean isVertexFile = !obj.containsKey("SRC_ID") && !obj.containsKey("DST_ID");
                    csv.setFileType(isVertexFile);
                    if (!isVertexFile) {
                        if (!obj.containsKey("SRC_ID") || !obj.containsKey("DST_ID")) {
                            throw new InputException("Missing \"SRC_ID\" or \"DST_ID\"");
                        }
                        csv.setEdgeSrcLabel(obj.getString("SRC_ID"));
                        csv.setEdgeDstLabel(obj.getString("DST_ID"));
                    }
                    JSONArray columns = obj.getJSONArray("columns");
                    for (Object o : columns) {
                        String column = (String)o;
                        if ("".equals(column)) {
                            throw new InputException("Found empty filed in json " + file.getPath());
                        }
                        csv.addColumn(column);
                    }
                    list.add(csv);
                }
            }
            return list;
        }

        public String getUrl() {
            return this.url;
        }

        public String callCypher(String cypher, String graph, double timeout, boolean withHeader) {
            return this.handleCypherRequest(cypher, graph, timeout, withHeader);
        }

        public String callCypher(String cypher, String graph, double timeout) {
            return this.handleCypherRequest(cypher, graph, timeout, false);
        }

        public String callGql(String gql, String graph, double timeout, boolean withHeader) {
            return this.handleGqlRequest(gql, graph, timeout, withHeader);
        }

        public String callGql(String gql, String graph, double timeout) {
            return this.handleGqlRequest(gql, graph, timeout, false);
        }

        public String callProcedure(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph) {
            Lgraph.PluginRequest.PluginType type = "CPP".equals(procedureType) ? Lgraph.PluginRequest.PluginType.CPP : Lgraph.PluginRequest.PluginType.PYTHON;
            ByteString resp = this.callProcedure(type, procedureName, ByteString.copyFromUtf8(param), graph, procedureTimeOut, inProcess, false);
            return resp.toStringUtf8();
        }

        public String callProcedure(String procedureType, String procedureName, String param, double procedureTimeOut, boolean inProcess, String graph, boolean withHeader) {
            Lgraph.PluginRequest.PluginType type = "CPP".equals(procedureType) ? Lgraph.PluginRequest.PluginType.CPP : Lgraph.PluginRequest.PluginType.PYTHON;
            ByteString resp = this.callProcedure(type, procedureName, ByteString.copyFromUtf8(param), graph, procedureTimeOut, inProcess, withHeader);
            return resp.toStringUtf8();
        }

        public ByteString callProcedure(Lgraph.PluginRequest.PluginType type, String name, ByteString param, String graph, double timeout, boolean inProcess, boolean withHeader) {
            Lgraph.CallPluginRequest vreq = Lgraph.CallPluginRequest.newBuilder().setName(name).setParam(param).setTimeout(timeout).setInProcess(inProcess).setResultInJsonFormat(withHeader).build();
            Lgraph.PluginRequest req = Lgraph.PluginRequest.newBuilder().setType(type).setCallPluginRequest(vreq).setGraph(graph).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setPluginRequest(req).setToken(this.token).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "CallProcedure");
            }
            if (withHeader) {
                return response.getPluginResponse().getCallPluginResponse().getJsonResultBytes();
            }
            return response.getPluginResponse().getCallPluginResponse().getReply();
        }

        public String listProcedures(String procedureType, String version, String graph) {
            Lgraph.PluginRequest.PluginType type = "CPP".equals(procedureType) ? Lgraph.PluginRequest.PluginType.CPP : Lgraph.PluginRequest.PluginType.PYTHON;
            Lgraph.ListPluginRequest vreq = Lgraph.ListPluginRequest.newBuilder().build();
            Lgraph.PluginRequest req = Lgraph.PluginRequest.newBuilder().setType(type).setListPluginRequest(vreq).setGraph(graph).setVersion(version).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setIsWriteOp(false).setPluginRequest(req).setToken(this.token).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "listProcedures");
            }
            return response.getPluginResponse().getListPluginResponse().getReply();
        }

        public boolean loadProcedure(String sourceFile, String procedureType, String procedureName, String codeType, String procedureDescription, boolean readOnly, String version, String graph) throws IOException {
            String[] sourceFiles = new String[]{sourceFile};
            return this.loadProcedure(sourceFiles, procedureType, procedureName, codeType, procedureDescription, readOnly, version, graph);
        }

        public boolean loadProcedure(String[] sourceFiles, String procedureType, String procedureName, String codeType, String procedureDescription, boolean readOnly, String version, String graph) throws IOException {
            Lgraph.PluginRequest.PluginType type;
            Lgraph.PluginRequest.PluginType pluginType = type = "CPP".equals(procedureType) ? Lgraph.PluginRequest.PluginType.CPP : Lgraph.PluginRequest.PluginType.PYTHON;
            Lgraph.LoadPluginRequest.CodeType cType = "SO".equals(codeType) ? Lgraph.LoadPluginRequest.CodeType.SO : ("PY".equals(codeType) ? Lgraph.LoadPluginRequest.CodeType.PY : ("CPP".equals(codeType) ? Lgraph.LoadPluginRequest.CodeType.CPP : Lgraph.LoadPluginRequest.CodeType.ZIP));
            ArrayList<ByteString> contents = new ArrayList<ByteString>();
            ArrayList<String> filenames = new ArrayList<String>();
            for (String sourceFile : sourceFiles) {
                ByteString content = ByteString.copyFrom(Objects.requireNonNull(this.binaryFileReader(sourceFile)));
                contents.add(content);
                String[] files = sourceFile.split("/");
                String fn = files[files.length - 1];
                filenames.add(fn);
            }
            Lgraph.LoadPluginRequest lpRequest = Lgraph.LoadPluginRequest.newBuilder().setName(procedureName).setDesc(procedureDescription).setReadOnly(readOnly).setCodeType(cType).addAllCode(contents).addAllFileName(filenames).build();
            Lgraph.PluginRequest req = Lgraph.PluginRequest.newBuilder().setType(type).setLoadPluginRequest(lpRequest).setGraph(graph).setVersion(version).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setIsWriteOp(true).setPluginRequest(req).setToken(this.token).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "loadProcedure");
            }
            return true;
        }

        public boolean deleteProcedure(String procedureType, String procedureName, String graph) {
            Lgraph.PluginRequest.PluginType type = "CPP".equals(procedureType) ? Lgraph.PluginRequest.PluginType.CPP : Lgraph.PluginRequest.PluginType.PYTHON;
            Lgraph.DelPluginRequest dpRequest = Lgraph.DelPluginRequest.newBuilder().setName(procedureName).build();
            Lgraph.PluginRequest req = Lgraph.PluginRequest.newBuilder().setType(type).setDelPluginRequest(dpRequest).setGraph(graph).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setIsWriteOp(true).setPluginRequest(req).setToken(this.token).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "deleteProcedure");
            }
            return true;
        }

        public boolean importSchemaFromContent(String schema, String graph, double timeout) throws InputException, InvalidProtocolBufferException {
            byte[] textByte = schema.getBytes(StandardCharsets.UTF_8);
            String schema64 = Base64.getEncoder().encodeToString(textByte);
            String sb = "CALL db.importor.schemaImportor('" + schema64 + "')";
            String res = this.callCypher(sb, graph, timeout);
            if (!JSONArray.parseArray(res).isEmpty()) {
                throw new InputException(res);
            }
            return true;
        }

        public boolean importDataFromContent(String desc, String data, String delimiter, boolean continueOnError, int threadNums, String graph, double timeout) {
            byte[] textByteDesc = desc.getBytes(StandardCharsets.UTF_8);
            byte[] textByteData = data.getBytes(StandardCharsets.UTF_8);
            String desc64 = Base64.getEncoder().encodeToString(textByteDesc);
            String data64 = Base64.getEncoder().encodeToString(textByteData);
            String sb = "CALL db.importor.dataImportor('" + desc64 + "','" + data64 + "'," + continueOnError + "," + threadNums + ",'" + this.parseDelimiter(delimiter) + "')";
            String res = this.callCypher(sb, graph, timeout);
            if (!JSONArray.parseArray(res).isEmpty()) {
                throw new InputException(res);
            }
            return true;
        }

        public boolean importSchemaFromFile(String schemaFile, String graph, double timeout) throws IOException {
            String content = this.textFileReader(schemaFile);
            if ("".equals(content)) {
                throw new InputException("Illegal schema_file : " + schemaFile);
            }
            JSONObject jsonObject = JSON.parseObject(content);
            if (jsonObject.isEmpty() || !jsonObject.containsKey("schema")) {
                throw new InputException("Illegal schema_file : " + schemaFile);
            }
            JSONObject schema = new JSONObject();
            schema.put("schema", (Object)jsonObject.getJSONArray("schema"));
            byte[] textByte = schema.toJSONString().getBytes(StandardCharsets.UTF_8);
            String schema64 = Base64.getEncoder().encodeToString(textByte);
            String sb = "CALL db.importor.schemaImportor('" + schema64 + "')";
            String res = this.callCypher(sb, graph, timeout);
            if (!JSONArray.parseArray(res).isEmpty()) {
                throw new InputException(res);
            }
            return true;
        }

        public boolean importDataFromFile(String confFile, String delimiter, boolean continueOnError, int threadNums, int skipPackages, String graph, double timeout) throws IOException {
            String content = this.textFileReader(confFile);
            if ("".equals(content)) {
                throw new InputException("Illegal conf_file : " + confFile);
            }
            JSONObject jsonObject = JSON.parseObject(content);
            if (jsonObject.isEmpty()) {
                throw new InputException("Illegal conf_file : " + confFile);
            }
            List<CsvDesc> files = this.parseConfigurationFile(jsonObject, true);
            assert (files != null);
            if (files.isEmpty()) {
                return true;
            }
            Collections.sort(files);
            for (CsvDesc cd : files) {
                byte[] desc = cd.dump(false);
                boolean isFirstPackage = true;
                FileCutter cutter = new FileCutter(cd.getPath());
                byte[] buf = cutter.cut();
                while (buf != null) {
                    if (skipPackages > 0) {
                        --skipPackages;
                    } else {
                        if (isFirstPackage) {
                            int lines = cutter.lineCount(buf);
                            if (lines < cd.getHeaderLine()) {
                                throw new InputException("HEADER too large");
                            }
                        } else {
                            cd.setHeaderLine(0);
                            desc = cd.dump(false);
                        }
                        String desc64 = Base64.getEncoder().encodeToString(desc);
                        String content64 = Base64.getEncoder().encodeToString(buf);
                        String sb = "CALL db.importor.dataImportor('" + desc64 + "','" + content64 + "'," + continueOnError + "," + threadNums + ",'" + this.parseDelimiter(delimiter) + "')";
                        String res = this.callCypher(sb, graph, timeout);
                        if (!JSONArray.parseArray(res).isEmpty()) {
                            throw new InputException(res);
                        }
                        if (!JSONArray.parseArray(res).isEmpty()) {
                            throw new InputException(res);
                        }
                        buf = cutter.cut();
                    }
                    isFirstPackage = false;
                }
            }
            return true;
        }

        public void logout() throws Exception {
            Lgraph.LogoutRequest logoutReq = Lgraph.LogoutRequest.newBuilder().setToken(this.token).build();
            Lgraph.AuthRequest authReq = Lgraph.AuthRequest.newBuilder().setLogout(logoutReq).build();
            Lgraph.AclRequest req = Lgraph.AclRequest.newBuilder().setAuthRequest(authReq).build();
            Lgraph.LGraphRequest request = Lgraph.LGraphRequest.newBuilder().setAclRequest(req).setToken(this.token).setIsWriteOp(false).build();
            Lgraph.LGraphResponse response = this.tuGraphService.HandleRequest(request);
            if (response.getErrorCode().getNumber() != 1) {
                throw new TuGraphDbRpcException(response.getErrorCode(), response.getError(), "TuGraphRpcClient");
            }
            this.client.stop();
        }

        protected void finalize() {
            try {
                this.logout();
            }
            catch (Exception e) {
                log.info("RpcClient already logout!");
            }
        }
    }

    static interface QueryInterface<E> {
        public E method() throws Exception;
    }

    static enum ClientType {
        DIRECT_HA_CONNECTION,
        INDIRECT_HA_CONNECTION,
        SINGLE_CONNECTION;

    }
}

