/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Iterator;

public class DynamicCompositeByteBuf {
    private ArrayDeque<ByteBuf> buffers;
    private int readableBytes;

    public DynamicCompositeByteBuf() {
        this.buffers = new ArrayDeque(1);
        this.readableBytes = 0;
    }

    public DynamicCompositeByteBuf(int capacity) {
        this.buffers = new ArrayDeque(capacity);
        this.readableBytes = 0;
    }

    public DynamicCompositeByteBuf(ByteBuf buf) {
        this.buffers = new ArrayDeque(1);
        this.buffers.addLast(buf);
        this.readableBytes += buf.readableBytes();
    }

    public DynamicCompositeByteBuf(ByteBuf[] bufs, int offset, int len) {
        this.buffers = new ArrayDeque(len);
        this.readableBytes = 0;
        for (int i = offset; i < offset + len; ++i) {
            this.buffers.addLast(bufs[i]);
            this.readableBytes += bufs[i].readableBytes();
        }
    }

    public int readableBytes() {
        return this.readableBytes;
    }

    public boolean isEmpty() {
        return this.readableBytes == 0;
    }

    public boolean hasArray() {
        return this.buffers.size() == 1 && this.buffers.peekFirst().hasArray();
    }

    public byte[] array() throws UnsupportedOperationException {
        if (this.hasArray()) {
            return this.buffers.peekFirst().array();
        }
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() throws UnsupportedOperationException {
        if (this.hasArray()) {
            return this.buffers.peekFirst().arrayOffset();
        }
        throw new UnsupportedOperationException();
    }

    public int readerIndex() {
        if (this.hasArray()) {
            return this.buffers.peekFirst().readerIndex();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReadable() {
        return this.readableBytes > 0;
    }

    public ByteBuf nettyByteBuf() {
        if (this.readableBytes == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        int size = this.buffers.size();
        if (size == 1) {
            return this.buffers.pop();
        }
        return new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, false, size, this.buffers.toArray(new ByteBuf[0]));
    }

    public void addBuffer(ByteBuf buffer) {
        int bufLen;
        if (buffer != null && (bufLen = buffer.readableBytes()) > 0) {
            this.buffers.add(buffer);
            this.readableBytes += bufLen;
        }
    }

    public ByteBuf readRetainedSlice(int length) {
        if (length > this.readableBytes) {
            throw new IndexOutOfBoundsException("length > readableBytes");
        }
        if (length <= 0) {
            return Unpooled.buffer(0);
        }
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (length == firstLen) {
            this.readableBytes -= length;
            return this.buffers.removeFirst();
        }
        if (length < firstLen) {
            ByteBuf newBuf = first.readRetainedSlice(length);
            this.readableBytes -= length;
            return newBuf;
        }
        int capacity = 2;
        ByteBuf[] byteBufs = new ByteBuf[capacity];
        int i = 0;
        while (length > 0 && this.readableBytes > 0) {
            ByteBuf newBuf;
            if (firstLen > length) {
                newBuf = first.readRetainedSlice(length);
                this.readableBytes -= length;
                length = 0;
            } else {
                newBuf = first;
                this.readableBytes -= firstLen;
                length -= firstLen;
                this.buffers.pop();
            }
            if (i == capacity) {
                int newCapacity = capacity * 2;
                ByteBuf[] newByteBufs = new ByteBuf[newCapacity];
                System.arraycopy(byteBufs, 0, newByteBufs, 0, capacity);
                byteBufs = newByteBufs;
                capacity = newCapacity;
            }
            byteBufs[i++] = newBuf;
            first = this.buffers.peek();
            if (first == null) break;
            firstLen = first.readableBytes();
        }
        if (i == capacity) {
            int maxComponentNum = i > 2 ? i : 2;
            return new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, maxComponentNum, byteBufs);
        }
        ByteBuf[] outBufs = new ByteBuf[i];
        System.arraycopy(byteBufs, 0, outBufs, 0, i);
        int maxComponentNum = i > 2 ? i : 2;
        return new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, maxComponentNum, outBufs);
    }

    public ByteBuf retainedSlice(int length) {
        if (length > this.readableBytes) {
            throw new IndexOutOfBoundsException("length > readableBytes");
        }
        if (length <= 0) {
            return Unpooled.buffer(0);
        }
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (length <= firstLen) {
            ByteBuf newBuf = first.retainedSlice(first.readerIndex(), length);
            return newBuf;
        }
        int capacity = 2;
        ByteBuf[] byteBufs = new ByteBuf[capacity];
        int i = 0;
        int offset = 0;
        Iterator<ByteBuf> iterator = this.buffers.iterator();
        while (offset < length && iterator.hasNext()) {
            ByteBuf newBuf;
            ByteBuf next = iterator.next();
            int nextLen = next.readableBytes();
            if (nextLen <= length - offset) {
                newBuf = next.retainedSlice();
                offset += nextLen;
            } else {
                newBuf = next.retainedSlice(next.readerIndex(), length - offset);
                offset = length;
            }
            if (i == capacity) {
                int newCapacity = capacity * 2;
                ByteBuf[] newByteBufs = new ByteBuf[newCapacity];
                System.arraycopy(byteBufs, 0, newByteBufs, 0, i);
                byteBufs = newByteBufs;
                capacity = newCapacity;
            }
            byteBufs[i++] = newBuf;
        }
        if (i == capacity) {
            int maxComponentNum = i > 2 ? i : 2;
            return new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, maxComponentNum, byteBufs);
        }
        ByteBuf[] outBufs = new ByteBuf[i];
        System.arraycopy(byteBufs, 0, outBufs, 0, i);
        int maxComponentNum = i > 2 ? i : 2;
        return new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, maxComponentNum, outBufs);
    }

    public void skipBytes(int length) {
        if (length > this.readableBytes) {
            throw new IndexOutOfBoundsException("length > readableBytes");
        }
        if (length <= 0) {
            return;
        }
        while (length > 0 && this.readableBytes > 0) {
            ByteBuf first = this.buffers.peek();
            int firstLen = first.readableBytes();
            if (firstLen > length) {
                first.skipBytes(length);
                this.readableBytes -= length;
                length = 0;
                continue;
            }
            this.readableBytes -= firstLen;
            length -= firstLen;
            this.buffers.removeFirst().release();
        }
    }

    public DynamicCompositeByteBuf readBytes(byte[] dst) {
        return this.readBytes(dst, 0, dst.length);
    }

    public DynamicCompositeByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (dstIndex < 0 || dstIndex >= dst.length || dstIndex + length > dst.length || dstIndex + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            ByteBuf first = this.buffers.peek();
            int firstLen = first.readableBytes();
            if (firstLen > length) {
                first.readBytes(dst, dstIndex, length);
                this.readableBytes -= length;
                length = 0;
                continue;
            }
            first.readBytes(dst, dstIndex, firstLen);
            this.readableBytes -= firstLen;
            dstIndex += firstLen;
            length -= firstLen;
            this.buffers.removeFirst().release();
        }
        return this;
    }

    public byte readByte() {
        this.checkReadableBytes0(1);
        ByteBuf buf = this.buffers.peek();
        byte res = buf.readByte();
        --this.readableBytes;
        if (buf.readableBytes() <= 0) {
            this.buffers.removeFirst().release();
        }
        return res;
    }

    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public short readShort() {
        short res;
        this.checkReadableBytes0(2);
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (firstLen >= 2) {
            res = first.readShort();
            this.readableBytes -= 2;
            if (firstLen == 2) {
                this.buffers.removeFirst().release();
            }
        } else {
            res = this.order() == ByteOrder.BIG_ENDIAN ? (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF) : (short)(this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8);
        }
        return res;
    }

    public short readShortLE() {
        this.checkReadableBytes0(2);
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (firstLen >= 2) {
            short res = first.readShortLE();
            this.readableBytes -= 2;
            if (firstLen == 2) {
                this.buffers.removeFirst().release();
            }
            return res;
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8);
        }
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    public int readInt() {
        this.checkReadableBytes0(4);
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (firstLen >= 4) {
            int res = first.readInt();
            this.readableBytes -= 4;
            if (firstLen == 4) {
                this.buffers.removeFirst().release();
            }
            return res;
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.readShort() & 0xFFFF) << 16 | this.readShort() & 0xFFFF;
        }
        return this.readShort() & 0xFFFF | (this.readShort() & 0xFFFF) << 16;
    }

    public int readIntLE() {
        this.checkReadableBytes0(4);
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (firstLen >= 4) {
            int res = first.readIntLE();
            this.readableBytes -= 4;
            if (firstLen == 4) {
                this.buffers.removeFirst().release();
            }
            return res;
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this.readShortLE() & 0xFFFF | (this.readShortLE() & 0xFFFF) << 16;
        }
        return (this.readShortLE() & 0xFFFF) << 16 | this.readShortLE() & 0xFFFF;
    }

    public long readLong() {
        this.checkReadableBytes0(8);
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (firstLen >= 8) {
            long res = first.readLong();
            this.readableBytes -= 8;
            if (firstLen == 8) {
                this.buffers.removeFirst().release();
            }
            return res;
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        return (long)this.readInt() & 0xFFFFFFFFL | ((long)this.readInt() & 0xFFFFFFFFL) << 32;
    }

    public long readLongLE() {
        this.checkReadableBytes0(8);
        ByteBuf first = this.buffers.peek();
        int firstLen = first.readableBytes();
        if (firstLen >= 8) {
            long res = first.readLongLE();
            this.readableBytes -= 8;
            if (firstLen == 8) {
                this.buffers.removeFirst().release();
            }
            return res;
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this.readIntLE() & 0xFFFFFFFFL | ((long)this.readIntLE() & 0xFFFFFFFFL) << 32;
        }
        return ((long)this.readIntLE() & 0xFFFFFFFFL) << 32 | (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloatLE() {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDoubleLE() {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    private void checkReadableBytes0(int length) {
        if (this.readableBytes < length) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds readableBytes(%d): %s", length, this.readableBytes, this));
        }
    }

    private void advanceBufferIfNecessary() {
        ByteBuf buffer;
        while (!this.buffers.isEmpty() && (buffer = this.buffers.peek()).readableBytes() == 0) {
            this.buffers.remove().release();
        }
    }

    public void release() {
        this.readableBytes = 0;
        while (!this.buffers.isEmpty()) {
            this.buffers.remove().release();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.readableBytes == 0) {
            return sb.toString();
        }
        for (ByteBuf buf : this.buffers) {
            for (int i = buf.readerIndex(); i < buf.readerIndex() + buf.readableBytes(); ++i) {
                sb.append(buf.getUnsignedByte(i)).append(" ");
            }
        }
        return sb.toString();
    }
}

