/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.handler;

import com.baidu.brpc.RpcContext;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushPacket;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.ServiceManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientWorkTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ClientWorkTask.class);
    private RpcClient rpcClient;
    private Object packet;
    private Protocol protocol;
    private ChannelHandlerContext ctx;

    @Override
    public void run() {
        Response response;
        SPHead spHead;
        if (this.protocol instanceof ServerPushProtocol && (spHead = ((ServerPushPacket)this.packet).getSpHead()).getType() == 2) {
            this.handlePushRequest();
            return;
        }
        try {
            response = this.protocol.decodeResponse(this.packet, this.ctx);
        }
        catch (Exception e) {
            log.warn("decode response failed:", e);
            return;
        }
        if (response.getRpcFuture() != null) {
            log.debug("handle response, correlationId={}", (Object)response.getCorrelationId());
            RpcFuture future = response.getRpcFuture();
            future.handleResponse(response);
        } else {
            log.warn("rpcFuture is null, server return to slow, correlationId={}", (Object)response.getCorrelationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePushRequest() {
        Request request = null;
        Response response = this.protocol.createResponse();
        try {
            request = this.protocol.decodeRequest(this.packet);
        }
        catch (Exception ex) {
            log.warn("decode request failed:", ex);
            response.setException(ex);
        }
        finally {
            if (request != null && request.getException() != null) {
                response.setException(request.getException());
            }
        }
        RpcContext rpcContext = null;
        request.setChannel(this.ctx.channel());
        if (request.getBinaryAttachment() != null || request.getKvAttachment() != null) {
            rpcContext = RpcContext.getContext();
            if (request.getBinaryAttachment() != null) {
                rpcContext.setRequestBinaryAttachment(request.getBinaryAttachment());
            }
            if (request.getKvAttachment() != null) {
                rpcContext.setRequestKvAttachment(request.getKvAttachment());
            }
            rpcContext.setRemoteAddress(this.ctx.channel().remoteAddress());
        }
        response.setLogId(request.getLogId());
        response.setCorrelationId(request.getCorrelationId());
        response.setCompressType(request.getCompressType());
        response.setException(request.getException());
        response.setRpcMethodInfo(request.getRpcMethodInfo());
        String serviceName = request.getServiceName();
        String methodName = request.getMethodName();
        RpcMethodInfo service = ServiceManager.getInstance().getService(serviceName, methodName);
        Method targetMethod = request.getTargetMethod();
        Object t = service.getTarget();
        Object result = null;
        try {
            result = targetMethod.invoke(t, request.getArgs());
        }
        catch (Exception e) {
            log.error("exception :", e);
        }
        response.setResult(result);
        try {
            ByteBuf byteBuf = this.protocol.encodeResponse(request, response);
            ChannelFuture channelFuture = this.ctx.channel().writeAndFlush(byteBuf);
            this.protocol.afterResponseSent(request, response, channelFuture);
        }
        catch (Exception ex) {
            log.warn("send response failed:", ex);
        }
        if (rpcContext != null) {
            rpcContext.reset();
        }
    }

    public void setRpcClient(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public void setPacket(Object packet) {
        this.packet = packet;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    public Object getPacket() {
        return this.packet;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public ClientWorkTask(RpcClient rpcClient, Object packet, Protocol protocol, ChannelHandlerContext ctx) {
        this.rpcClient = rpcClient;
        this.packet = packet;
        this.protocol = protocol;
        this.ctx = ctx;
    }
}

