/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.utils.BrpcConstants;

public class RpcServerOptions {
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private int soLinger = 5;
    private int backlog = 1024;
    private int receiveBufferSize = 65536;
    private int sendBufferSize = 65536;
    private int readerIdleTime = 60;
    private int writerIdleTime = 60;
    private int keepAliveTime = 5;
    private int acceptorThreadNum = 1;
    private int ioThreadNum = Runtime.getRuntime().availableProcessors();
    private int workThreadNum = Runtime.getRuntime().availableProcessors();
    private int ioEventType = BrpcConstants.IO_EVENT_JDK;
    private int maxSize = Integer.MAX_VALUE;
    private int maxTryTimes = 1;
    private Integer protocolType;
    private String encoding = "utf-8";
    private String jarvisPortName;
    private String namingServiceUrl = "";
    private boolean globalThreadPoolSharing = false;

    public RpcServerOptions(RpcServerOptions options) {
        this.copyFrom(options);
    }

    public void copyFrom(RpcServerOptions options) {
        this.acceptorThreadNum = options.acceptorThreadNum;
        this.backlog = options.backlog;
        this.encoding = options.encoding;
        this.ioThreadNum = options.ioThreadNum;
        this.jarvisPortName = options.jarvisPortName;
        this.keepAlive = options.keepAlive;
        this.keepAliveTime = options.keepAliveTime;
        this.maxSize = options.maxSize;
        this.namingServiceUrl = options.namingServiceUrl;
        this.protocolType = options.protocolType;
        this.readerIdleTime = options.readerIdleTime;
        this.receiveBufferSize = options.receiveBufferSize;
        this.sendBufferSize = options.sendBufferSize;
        this.soLinger = options.soLinger;
        this.tcpNoDelay = options.tcpNoDelay;
        this.workThreadNum = options.workThreadNum;
        this.writerIdleTime = options.writerIdleTime;
        this.globalThreadPoolSharing = options.globalThreadPoolSharing;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setReaderIdleTime(int readerIdleTime) {
        this.readerIdleTime = readerIdleTime;
    }

    public void setWriterIdleTime(int writerIdleTime) {
        this.writerIdleTime = writerIdleTime;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setAcceptorThreadNum(int acceptorThreadNum) {
        this.acceptorThreadNum = acceptorThreadNum;
    }

    public void setIoThreadNum(int ioThreadNum) {
        this.ioThreadNum = ioThreadNum;
    }

    public void setWorkThreadNum(int workThreadNum) {
        this.workThreadNum = workThreadNum;
    }

    public void setIoEventType(int ioEventType) {
        this.ioEventType = ioEventType;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMaxTryTimes(int maxTryTimes) {
        this.maxTryTimes = maxTryTimes;
    }

    public void setProtocolType(Integer protocolType) {
        this.protocolType = protocolType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setJarvisPortName(String jarvisPortName) {
        this.jarvisPortName = jarvisPortName;
    }

    public void setNamingServiceUrl(String namingServiceUrl) {
        this.namingServiceUrl = namingServiceUrl;
    }

    public void setGlobalThreadPoolSharing(boolean globalThreadPoolSharing) {
        this.globalThreadPoolSharing = globalThreadPoolSharing;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public int getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getAcceptorThreadNum() {
        return this.acceptorThreadNum;
    }

    public int getIoThreadNum() {
        return this.ioThreadNum;
    }

    public int getWorkThreadNum() {
        return this.workThreadNum;
    }

    public int getIoEventType() {
        return this.ioEventType;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public Integer getProtocolType() {
        return this.protocolType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getJarvisPortName() {
        return this.jarvisPortName;
    }

    public String getNamingServiceUrl() {
        return this.namingServiceUrl;
    }

    public boolean isGlobalThreadPoolSharing() {
        return this.globalThreadPoolSharing;
    }

    public String toString() {
        return "RpcServerOptions(keepAlive=" + this.isKeepAlive() + ", tcpNoDelay=" + this.isTcpNoDelay() + ", soLinger=" + this.getSoLinger() + ", backlog=" + this.getBacklog() + ", receiveBufferSize=" + this.getReceiveBufferSize() + ", sendBufferSize=" + this.getSendBufferSize() + ", readerIdleTime=" + this.getReaderIdleTime() + ", writerIdleTime=" + this.getWriterIdleTime() + ", keepAliveTime=" + this.getKeepAliveTime() + ", acceptorThreadNum=" + this.getAcceptorThreadNum() + ", ioThreadNum=" + this.getIoThreadNum() + ", workThreadNum=" + this.getWorkThreadNum() + ", ioEventType=" + this.getIoEventType() + ", maxSize=" + this.getMaxSize() + ", maxTryTimes=" + this.getMaxTryTimes() + ", protocolType=" + this.getProtocolType() + ", encoding=" + this.getEncoding() + ", jarvisPortName=" + this.getJarvisPortName() + ", namingServiceUrl=" + this.getNamingServiceUrl() + ", globalThreadPoolSharing=" + this.isGlobalThreadPoolSharing() + ")";
    }

    public RpcServerOptions() {
    }
}

