/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.utils;

import com.baidu.brpc.utils.BoundedQueue;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ThreadPool {
    private static final int DEFAULT_QUEUE_SIZE = 1024;
    private BoundedQueue<Runnable> produced;
    private BoundedQueue<Runnable> toConsume;
    private Lock consumerLock;
    private Lock producerLock;
    private Condition isProducerNotFullCondition;
    private Condition isProducerNotEmptyCondition;
    private ArrayList<Thread> threads;
    private volatile boolean stopped;

    public ThreadPool(int initialThreadNum, ThreadFactory threadFactory) {
        this(initialThreadNum, threadFactory, 0);
    }

    public ThreadPool(int initialThreadNum, ThreadFactory threadFactory, int queueSize) {
        if (initialThreadNum <= 0) {
            throw new IllegalArgumentException("initialThreadNum=" + initialThreadNum + " should be positive");
        }
        this.threads = new ArrayList(initialThreadNum);
        this.stopped = false;
        if (queueSize <= 0) {
            queueSize = 1024;
        }
        this.produced = new BoundedQueue(queueSize);
        this.toConsume = new BoundedQueue(queueSize);
        this.consumerLock = new ReentrantLock();
        this.producerLock = new ReentrantLock();
        this.isProducerNotEmptyCondition = this.producerLock.newCondition();
        this.isProducerNotFullCondition = this.producerLock.newCondition();
        for (int i = 0; i < initialThreadNum; ++i) {
            Thread tr = threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    ThreadPool.this.consume();
                }
            });
            tr.start();
            this.threads.add(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume() {
        while (true) {
            Runnable task = null;
            while (true) {
                this.consumerLock.lock();
                try {
                    if (!this.toConsume.isEmpty()) {
                        task = this.toConsume.pop();
                        break;
                    }
                }
                finally {
                    this.consumerLock.unlock();
                }
                this.producerLock.lock();
                try {
                    while (!this.stopped && this.produced.isEmpty()) {
                        try {
                            this.isProducerNotEmptyCondition.await();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.produced.isEmpty()) break;
                    if (this.produced.isFull()) {
                        this.isProducerNotFullCondition.signalAll();
                    }
                    this.consumerLock.lock();
                    try {
                        BoundedQueue<Runnable> tmp = this.produced;
                        this.produced = this.toConsume;
                        this.toConsume = tmp;
                        continue;
                    }
                    finally {
                        this.consumerLock.unlock();
                        continue;
                    }
                }
                finally {
                    this.producerLock.unlock();
                    continue;
                }
                break;
            }
            if (task == null) break;
            task.run();
        }
    }

    public void stop() {
        this.stopped = true;
        this.producerLock.lock();
        try {
            this.isProducerNotEmptyCondition.signalAll();
            this.isProducerNotFullCondition.signalAll();
        }
        finally {
            this.producerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        ArrayList<Thread> arrayList = this.threads;
        synchronized (arrayList) {
            for (Thread tr : this.threads) {
                try {
                    tr.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.threads.clear();
        }
    }

    public boolean submit(Runnable task) {
        Runnable[] tasks = new Runnable[]{task};
        return this.submit(tasks, 0, 1) == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long submit(Runnable[] tasks, int offset, int len) {
        int cur = offset;
        int end = offset + len;
        while (!this.stopped && cur < end) {
            this.producerLock.lock();
            try {
                while (this.produced.isFull()) {
                    try {
                        this.isProducerNotFullCondition.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int toProduce = Math.min(this.produced.remainingCapacity(), end - cur);
                if (toProduce > 0) {
                    boolean wasEmpty = this.produced.isEmpty();
                    this.produced.addAll((Runnable[])tasks, cur, toProduce);
                    if (wasEmpty) {
                        this.isProducerNotEmptyCondition.signalAll();
                    }
                }
                cur += toProduce;
            }
            finally {
                this.producerLock.unlock();
            }
        }
        return cur - offset;
    }

    public StatInfo getStatInfo() {
        StatInfo statInfo = new StatInfo();
        statInfo.setThreadNum(this.threads.size());
        statInfo.setDefaultQueueCapacity(1024);
        statInfo.setProducerQueueSize(this.produced.size());
        statInfo.setConsumerQueueSize(this.toConsume.size());
        return statInfo;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public static class StatInfo {
        private int threadNum;
        private int defaultQueueCapacity;
        private int producerQueueSize;
        private int consumerQueueSize;

        public void setThreadNum(int threadNum) {
            this.threadNum = threadNum;
        }

        public void setDefaultQueueCapacity(int defaultQueueCapacity) {
            this.defaultQueueCapacity = defaultQueueCapacity;
        }

        public void setProducerQueueSize(int producerQueueSize) {
            this.producerQueueSize = producerQueueSize;
        }

        public void setConsumerQueueSize(int consumerQueueSize) {
            this.consumerQueueSize = consumerQueueSize;
        }

        public int getThreadNum() {
            return this.threadNum;
        }

        public int getDefaultQueueCapacity() {
            return this.defaultQueueCapacity;
        }

        public int getProducerQueueSize() {
            return this.producerQueueSize;
        }

        public int getConsumerQueueSize() {
            return this.consumerQueueSize;
        }
    }
}

