/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.googlecode.protobuf.format.CouchDBFormat;
import com.googlecode.protobuf.format.HtmlFormat;
import com.googlecode.protobuf.format.JavaPropsFormat;
import com.googlecode.protobuf.format.JsonFormat;
import com.googlecode.protobuf.format.JsonJacksonFormat;
import com.googlecode.protobuf.format.ProtobufFormatter;
import com.googlecode.protobuf.format.SmileFormat;
import com.googlecode.protobuf.format.XmlFormat;
import com.googlecode.protobuf.format.XmlJavaxFormat;

public class FormatFactory {
    public ProtobufFormatter createFormatter(Formatter formatter) {
        try {
            return formatter.getFormatterClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Formatter {
        COUCHDB(CouchDBFormat.class),
        HTML(HtmlFormat.class),
        JAVA_PROPS(JavaPropsFormat.class),
        JSON(JsonFormat.class),
        XML(XmlFormat.class),
        SMILE(SmileFormat.class),
        JSON_JACKSON(JsonJacksonFormat.class),
        XML_JAVAX(XmlJavaxFormat.class);

        private Class<? extends ProtobufFormatter> formatterClass;

        private Formatter(Class<? extends ProtobufFormatter> formatterClass) {
            this.formatterClass = formatterClass;
        }

        protected Class<? extends ProtobufFormatter> getFormatterClass() {
            return this.formatterClass;
        }
    }
}

