/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.AbstractCharBasedFormatter;
import com.googlecode.protobuf.format.util.TextUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaPropsFormat
extends AbstractCharBasedFormatter {
    @Override
    public void print(Message message, Appendable output) throws IOException {
        JavaPropsGenerator generator = new JavaPropsGenerator(output);
        this.print(message, generator);
    }

    @Override
    public void print(UnknownFieldSet fields, Appendable output) throws IOException {
        JavaPropsGenerator generator = new JavaPropsGenerator(output);
        this.printUnknownFields(fields, generator);
    }

    private void print(Message message, JavaPropsGenerator generator) throws IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
            this.printField(field.getKey(), field.getValue(), generator);
        }
        this.printUnknownFields(message.getUnknownFields(), generator);
    }

    public void printField(Descriptors.FieldDescriptor field, Object value, Appendable output) throws IOException {
        JavaPropsGenerator generator = new JavaPropsGenerator(output);
        this.printField(field, value, generator);
    }

    public String printFieldToString(Descriptors.FieldDescriptor field, Object value) {
        try {
            StringBuilder text = new StringBuilder();
            this.printField(field, value, text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    private void printField(Descriptors.FieldDescriptor field, Object value, JavaPropsGenerator generator) throws IOException {
        if (field.isRepeated()) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.printSingleField(field, list.get(i), i, generator);
            }
        } else {
            this.printSingleField(field, value, null, generator);
        }
    }

    private void printSingleField(Descriptors.FieldDescriptor field, Object value, Integer collectionIndex, JavaPropsGenerator generator) throws IOException {
        if (field.isExtension()) {
            generator.print("[");
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.print(field.getMessageType().getFullName());
            } else {
                generator.print(field.getFullName());
            }
            generator.print("]");
        } else if (field.getType() != Descriptors.FieldDescriptor.Type.GROUP && field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
            generator.print(this.createFieldNameCollectionIndex(field.getName(), collectionIndex));
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            generator.indent(this.createFieldNameCollectionIndex(field.getMessageType().getName(), collectionIndex));
        } else if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            generator.indent(this.createFieldNameCollectionIndex(field.getName(), collectionIndex));
        } else {
            generator.print("=");
        }
        this.printFieldValue(field, value, generator);
        if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            generator.outdent(this.createFieldNameCollectionIndex(field.getName(), collectionIndex));
        } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            generator.outdent(this.createFieldNameCollectionIndex(field.getMessageType().getName(), collectionIndex));
        } else {
            generator.print("\n");
        }
    }

    private String createFieldNameCollectionIndex(String fieldName, Integer collectionIndex) throws IOException {
        if (collectionIndex != null) {
            return fieldName + "[" + collectionIndex.toString() + "]";
        }
        return fieldName;
    }

    private void printFieldValue(Descriptors.FieldDescriptor field, Object value, JavaPropsGenerator generator) throws IOException {
        switch (field.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: {
                generator.print(value.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.print(TextUtils.unsignedToString((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.print(TextUtils.unsignedToString((Long)value));
                break;
            }
            case STRING: {
                generator.print("\"");
                generator.print(JavaPropsFormat.escapeText((String)value));
                generator.print("\"");
                break;
            }
            case BYTES: {
                generator.print("\"");
                generator.print(JavaPropsFormat.escapeBytes((ByteString)value));
                generator.print("\"");
                break;
            }
            case ENUM: {
                generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                this.print((Message)value, generator);
            }
        }
    }

    private void printUnknownFields(UnknownFieldSet unknownFields, JavaPropsGenerator generator) throws IOException {
        for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = entry.getValue();
            Iterator<Object> iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                generator.print(entry.getKey().toString());
                generator.print("=");
                generator.print(TextUtils.unsignedToString(value));
                generator.print("\n");
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                generator.print(entry.getKey().toString());
                generator.print("=");
                generator.print(String.format((Locale)null, "0x%08x", value));
                generator.print("\n");
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                generator.print(entry.getKey().toString());
                generator.print("=");
                generator.print(String.format((Locale)null, "0x%016x", value));
                generator.print("\n");
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                generator.print(entry.getKey().toString());
                generator.print("=\"");
                generator.print(JavaPropsFormat.escapeBytes(value));
                generator.print("\"\n");
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.indent(entry.getKey().toString());
                this.printUnknownFields(value, generator);
                generator.outdent(entry.getKey().toString());
                generator.print("\n");
            }
        }
    }

    @Override
    public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        HashMap<String, Message> subMessages = new HashMap<String, Message>();
        while (!tokenizer.atEnd()) {
            this.mergeField(tokenizer, extensionRegistry, subMessages, builder);
        }
    }

    private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Map<String, Message> subMessages, Message.Builder builder) throws ParseException {
        Descriptors.FieldDescriptor field;
        CharSequence name;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extension = null;
        if (tokenizer.tryConsume("[")) {
            name = new StringBuilder(tokenizer.consumeIdentifier());
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)name).append('.');
                ((StringBuilder)name).append(tokenizer.consumeIdentifier());
            }
            extension = extensionRegistry.findExtensionByName(((StringBuilder)name).toString());
            if (extension == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" not found in the ExtensionRegistry.");
            }
            if (extension.descriptor.getContainingType() != type) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
            }
            tokenizer.consume("]");
            field = extension.descriptor;
        } else {
            String lowerName;
            name = tokenizer.consumeIdentifier();
            field = type.findFieldByName((String)name);
            if (field == null && (field = type.findFieldByName(lowerName = ((String)name).toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field = null;
            }
            if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name)) {
                field = null;
            }
            if (field == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + type.getFullName() + "\" has no field named \"" + (String)name + "\".");
            }
        }
        Object value = null;
        Integer collectionIndex = null;
        if (field.isRepeated()) {
            tokenizer.consume("[");
            collectionIndex = tokenizer.consumeInt32();
            tokenizer.consume("]");
        }
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            tokenizer.consume(".");
            Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
            Message subMessage = subMessages.get(field.getFullName());
            if (subMessage != null) {
                subBuilder.mergeFrom(subMessage);
            }
            this.mergeField(tokenizer, extensionRegistry, subMessages, subBuilder);
            value = subBuilder.buildPartial();
            subMessages.put(field.getFullName(), (Message)value);
        } else {
            tokenizer.consume("=");
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    value = tokenizer.consumeInt32();
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    value = tokenizer.consumeInt64();
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    value = tokenizer.consumeUInt32();
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    value = tokenizer.consumeUInt64();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(tokenizer.consumeFloat());
                    break;
                }
                case DOUBLE: {
                    value = tokenizer.consumeDouble();
                    break;
                }
                case BOOL: {
                    value = tokenizer.consumeBoolean();
                    break;
                }
                case STRING: {
                    value = tokenizer.consumeString();
                    break;
                }
                case BYTES: {
                    value = tokenizer.consumeByteString();
                    break;
                }
                case ENUM: {
                    Descriptors.EnumDescriptor enumType = field.getEnumType();
                    if (tokenizer.lookingAtInteger()) {
                        int number = tokenizer.consumeInt32();
                        value = enumType.findValueByNumber(number);
                        if (value != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + '.');
                    }
                    String id = tokenizer.consumeIdentifier();
                    value = enumType.findValueByName(id);
                    if (value != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
                }
                case MESSAGE: 
                case GROUP: {
                    throw new RuntimeException("Can't get here.");
                }
            }
        }
        if (field.isRepeated()) {
            int collectionCount = builder.getRepeatedFieldCount(field) - 1;
            if (collectionCount < collectionIndex) {
                builder.addRepeatedField(field, value);
            } else {
                builder.setRepeatedField(field, collectionIndex, value);
            }
        } else {
            builder.setField(field, value);
        }
    }

    static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static ByteString unescapeBytes(CharSequence input) throws InvalidEscapeSequenceException {
        byte[] result = new byte[input.length()];
        int pos = 0;
        block13: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                if (i + 1 < input.length()) {
                    int code;
                    if (TextUtils.isOctal(c = input.charAt(++i))) {
                        code = TextUtils.digitValue(c);
                        if (i + 1 < input.length() && TextUtils.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue(input.charAt(++i));
                        }
                        if (i + 1 < input.length() && TextUtils.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue(input.charAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 'a': {
                            result[pos++] = 7;
                            continue block13;
                        }
                        case 'b': {
                            result[pos++] = 8;
                            continue block13;
                        }
                        case 'f': {
                            result[pos++] = 12;
                            continue block13;
                        }
                        case 'n': {
                            result[pos++] = 10;
                            continue block13;
                        }
                        case 'r': {
                            result[pos++] = 13;
                            continue block13;
                        }
                        case 't': {
                            result[pos++] = 9;
                            continue block13;
                        }
                        case 'v': {
                            result[pos++] = 11;
                            continue block13;
                        }
                        case '\\': {
                            result[pos++] = 92;
                            continue block13;
                        }
                        case '\'': {
                            result[pos++] = 39;
                            continue block13;
                        }
                        case '\"': {
                            result[pos++] = 34;
                            continue block13;
                        }
                        case 'x': {
                            code = 0;
                            if (i + 1 >= input.length() || !TextUtils.isHex(input.charAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextUtils.digitValue(input.charAt(++i));
                            if (i + 1 < input.length() && TextUtils.isHex(input.charAt(i + 1))) {
                                code = code * 16 + TextUtils.digitValue(input.charAt(++i));
                            }
                            result[pos++] = (byte)code;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + c + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = (byte)c;
        }
        return ByteString.copyFrom(result, 0, pos);
    }

    static String escapeText(String input) {
        return JavaPropsFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    static String unescapeText(String input) throws InvalidEscapeSequenceException {
        return JavaPropsFormat.unescapeBytes(input).toStringUtf8();
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)JavaPropsFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)JavaPropsFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return JavaPropsFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return JavaPropsFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValue();
        }
        return result;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;

        public ParseException(String message) {
            super(message);
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_') continue;
                throw this.parseException("Expected identifier.");
            }
            String result = this.currentToken;
            this.nextToken();
            return result;
        }

        public int consumeInt32() throws ParseException {
            try {
                int result = JavaPropsFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result = JavaPropsFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result = JavaPropsFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result = JavaPropsFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> list = new ArrayList<ByteString>();
            this.consumeByteString(list);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(list);
            }
            return ByteString.copyFrom(list);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char quote;
            char c = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result = JavaPropsFormat.unescapeBytes(escaped);
                this.nextToken();
                list.add(result);
            }
            catch (InvalidEscapeSequenceException e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1 + ":" + (this.column + 1) + ": " + description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1 + ":" + (this.previousColumn + 1) + ": " + description);
        }

        private ParseException integerParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse integer: " + e.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse number: " + e.getMessage());
        }
    }

    private static final class JavaPropsGenerator {
        private Appendable output;
        private boolean atStartOfLine = true;
        private final StringBuilder indent = new StringBuilder();

        private JavaPropsGenerator(Appendable output) {
            this.output = output;
        }

        public void indent(String objectPath) {
            this.indent.append(objectPath);
            this.indent.append(".");
        }

        public void outdent(String objectPath) {
            int length = this.indent.length();
            int objectPathLength = objectPath.length() + 1;
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(length - objectPathLength, length);
        }

        public void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                if (text.charAt(i) != '\n') continue;
                this.write(text.subSequence(pos, size), i - pos + 1);
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text.subSequence(pos, size), size - pos);
        }

        private void write(CharSequence data, int size) throws IOException {
            if (size == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }
}

