/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.ProtobufFormatter;
import com.googlecode.protobuf.format.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;

public class XmlJavaxFormat
extends ProtobufFormatter {
    private static final String MESSAGE_ELEMENT = "message";
    private static final String EXTENSION_ELEMENT = "extension";
    private static final String EXTENSION_TYPE = "type";
    private static final String UNKNOWN_FIELD_ELEMENT = "unknown-field";
    private static final String UNKNOWN_FIELD_INDEX = "index";
    private XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();

    @Override
    public void print(Message message, OutputStream output, Charset cs) throws IOException {
        try {
            XMLStreamWriter generator = this.createGenerator(output);
            this.print(message, generator);
            generator.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void print(Message message, XMLStreamWriter generator) throws IOException {
        try {
            String messageName = message.getDescriptorForType().getName();
            generator.writeStartElement(messageName);
            this.printMessage(message, generator);
            generator.writeEndElement();
            generator.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void print(UnknownFieldSet fields, OutputStream output, Charset cs) throws IOException {
        try {
            XMLStreamWriter generator = this.createGenerator(output);
            generator.writeStartElement(MESSAGE_ELEMENT);
            this.printUnknownFields(fields, generator);
            generator.writeEndElement();
            generator.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void merge(InputStream input, Charset cs, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        try {
            XMLEventReader parser = this.xmlInputFactory.createXMLEventReader(input);
            this.merge(parser, extensionRegistry, builder);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void merge(XMLEventReader parser, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        try {
            XMLEvent messageElement = parser.nextTag();
            if (messageElement.isStartElement()) {
                String messageName = messageElement.asStartElement().getName().getLocalPart();
                assert (builder.getDescriptorForType().getName().equals(messageName));
                while (parser.hasNext() && !parser.peek().isEndDocument()) {
                    XMLEvent event = parser.nextTag();
                    if (event.isStartElement()) {
                        this.mergeField(parser, event, extensionRegistry, builder);
                        XMLEvent endElement = parser.nextTag();
                        assert (endElement.isEndElement());
                        continue;
                    }
                    if (event.isEndElement()) break;
                    throw new RuntimeException("Expecting the end of the stream, but there seems to be more data!  Check the input for a valid XML format.");
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    protected XMLStreamWriter createGenerator(OutputStream output) throws XMLStreamException {
        XMLStreamWriter generator = this.xmlOutputFactory.createXMLStreamWriter(output);
        generator.writeStartDocument();
        return generator;
    }

    protected void printMessage(Message message, XMLStreamWriter generator) throws XMLStreamException, IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
            this.printField(field.getKey(), field.getValue(), generator);
        }
        this.printUnknownFields(message.getUnknownFields(), generator);
    }

    public void printField(Descriptors.FieldDescriptor field, Object value, XMLStreamWriter generator) throws IOException {
        try {
            if (field.isRepeated()) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    this.printSingleField(field, iter.next(), generator);
                }
            } else {
                this.printSingleField(field, value, generator);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void printSingleField(Descriptors.FieldDescriptor field, Object value, XMLStreamWriter generator) throws XMLStreamException, IOException {
        if (field.isExtension()) {
            generator.writeStartElement(EXTENSION_ELEMENT);
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.writeAttribute(EXTENSION_TYPE, field.getMessageType().getFullName());
            } else {
                generator.writeAttribute(EXTENSION_TYPE, field.getFullName());
            }
        } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            generator.writeStartElement(field.getMessageType().getName());
        } else {
            generator.writeStartElement(field.getName());
        }
        this.printFieldValue(field, value, generator);
        generator.writeEndElement();
    }

    private void printFieldValue(Descriptors.FieldDescriptor field, Object value, XMLStreamWriter generator) throws XMLStreamException, IOException {
        switch (field.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: 
            case STRING: {
                generator.writeCharacters(value.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.writeCharacters(TextUtils.unsignedToString((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.writeCharacters(TextUtils.unsignedToString((Long)value));
                break;
            }
            case BYTES: {
                generator.writeCharacters(TextUtils.escapeBytes((ByteString)value));
                break;
            }
            case ENUM: {
                generator.writeCharacters(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                this.printMessage((Message)value, generator);
            }
        }
    }

    protected void printUnknownFields(UnknownFieldSet unknownFields, XMLStreamWriter generator) throws XMLStreamException {
        for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = entry.getValue();
            String key = entry.getKey().toString();
            Iterator<Object> iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                this.printUnknownField(key, TextUtils.unsignedToString(value), generator);
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                this.printUnknownField(key, String.format((Locale)null, "0x%08x", value), generator);
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                this.printUnknownField(key, String.format((Locale)null, "0x%016x", value), generator);
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                this.printUnknownField(key, TextUtils.escapeBytes(value), generator);
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.writeStartElement(UNKNOWN_FIELD_ELEMENT);
                generator.writeAttribute(UNKNOWN_FIELD_INDEX, key);
                this.printUnknownFields(value, generator);
                generator.writeEndElement();
            }
        }
    }

    private void printUnknownField(String fieldKey, String fieldValue, XMLStreamWriter generator) throws XMLStreamException {
        generator.writeStartElement(UNKNOWN_FIELD_ELEMENT);
        generator.writeAttribute(UNKNOWN_FIELD_INDEX, fieldKey);
        generator.writeCharacters(fieldValue);
        generator.writeEndElement();
    }

    protected void mergeField(XMLEventReader parser, XMLEvent fieldEvent, ExtensionRegistry extensionRegistry, Message.Builder builder) throws XMLStreamException {
        Descriptors.FieldDescriptor field = null;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        boolean unknown = false;
        ExtensionRegistry.ExtensionInfo extension = null;
        String fieldName = fieldEvent.asStartElement().getName().getLocalPart();
        XMLEvent event = parser.nextEvent();
        if (event != null) {
            if (fieldName.equalsIgnoreCase(EXTENSION_ELEMENT)) {
                String extensionName = fieldEvent.asStartElement().getAttributeByName(new QName(EXTENSION_TYPE)).getValue();
                extension = extensionRegistry.findExtensionByName(extensionName);
                if (extension == null) {
                    throw new RuntimeException("Extension \"" + fieldName + "\" not found in the ExtensionRegistry.");
                }
                if (extension.descriptor.getContainingType() != type) {
                    throw new RuntimeException("Extension \"" + fieldName + "\" does not extend message type \"" + type.getFullName() + "\".");
                }
                field = extension.descriptor;
            } else {
                String index;
                String lowerName;
                field = type.findFieldByName(fieldName);
                if (field == null && (field = type.findFieldByName(lowerName = fieldName.toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    field = null;
                }
                if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(fieldName) && !field.getMessageType().getFullName().equalsIgnoreCase(fieldName)) {
                    field = null;
                }
                if (fieldName.equalsIgnoreCase(UNKNOWN_FIELD_ELEMENT) && (index = fieldEvent.asStartElement().getAttributeByName(new QName(UNKNOWN_FIELD_INDEX)).getValue()) != null) {
                    fieldName = index;
                }
                if (field == null && TextUtils.isDigits(fieldName)) {
                    field = type.findFieldByNumber(Integer.parseInt(fieldName));
                    unknown = true;
                }
                if (field == null) {
                    UnknownFieldSet.Builder unknownsBuilder = UnknownFieldSet.newBuilder();
                    this.handleMissingField(fieldName, parser, event, extensionRegistry, unknownsBuilder);
                    builder.setUnknownFields(unknownsBuilder.build());
                }
            }
        }
        if (field != null) {
            Object result = null;
            if (event.isCharacters()) {
                result = this.handlePrimitive(parser, field, event.asCharacters().getData());
            } else if ((event.isStartElement() || event.isEndElement()) && field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                result = this.handleObject(parser, event, extensionRegistry, builder, field, extension);
            }
            if (result != null) {
                if (field.isRepeated()) {
                    builder.addRepeatedField(field, result);
                } else {
                    builder.setField(field, result);
                }
            }
        } else if (!unknown) assert (event.isCharacters());
    }

    private void handleMissingField(String fieldName, XMLEventReader parser, XMLEvent event, ExtensionRegistry extensionRegistry, UnknownFieldSet.Builder builder) throws XMLStreamException {
        if (event.isStartElement()) {
            int depth = 1;
            while (parser.hasNext()) {
                XMLEvent nextEvent = parser.nextEvent();
                if (nextEvent.isEndElement()) {
                    if (--depth > 0 || !parser.peek().isEndElement()) continue;
                    break;
                }
                if (!nextEvent.isStartElement()) continue;
                ++depth;
            }
        } else if (event.isCharacters()) {
            // empty if block
        }
    }

    private Object handlePrimitive(XMLEventReader parser, Descriptors.FieldDescriptor field, String value) {
        Object result = null;
        if (value == null) {
            return result;
        }
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                result = TextUtils.parseInt32(value);
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                result = TextUtils.parseInt64(value);
                break;
            }
            case UINT32: 
            case FIXED32: {
                result = TextUtils.parseUInt32(value);
                break;
            }
            case UINT64: 
            case FIXED64: {
                result = TextUtils.parseUInt64(value);
                break;
            }
            case FLOAT: {
                result = Float.valueOf(TextUtils.parseFloat(value));
                break;
            }
            case DOUBLE: {
                result = TextUtils.parseDouble(value);
                break;
            }
            case BOOL: {
                result = TextUtils.parseBoolean(value);
                break;
            }
            case STRING: {
                result = value;
                break;
            }
            case BYTES: {
                result = TextUtils.unescapeBytes(value);
                break;
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                if (TextUtils.isDigits(value)) {
                    int number = TextUtils.parseInt32(value);
                    result = enumType.findValueByNumber(number);
                    if (result != null) break;
                    throw new RuntimeException("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + ".");
                }
                String id = value;
                result = enumType.findValueByName(id);
                if (result != null) break;
                throw new RuntimeException("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
            }
            case MESSAGE: 
            case GROUP: {
                throw new RuntimeException("Can't get here.");
            }
        }
        return result;
    }

    private Message.Builder createSubBuilder(Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) {
        Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
        return subBuilder;
    }

    private Object handleObject(XMLEventReader parser, XMLEvent startEvent, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) throws XMLStreamException {
        Message.Builder subBuilder = this.createSubBuilder(builder, field, extension);
        XMLEvent event = startEvent;
        int depth = 0;
        while (event.isStartElement()) {
            ++depth;
            this.mergeField(parser, event, extensionRegistry, subBuilder);
            XMLEvent nextEvent = parser.nextTag();
            if (nextEvent.isEndElement()) {
                if (--depth <= 0 && parser.peek().isEndElement()) {
                    break;
                }
            } else if (nextEvent.isStartElement()) {
                ++depth;
            }
            if (parser.hasNext() && (event = parser.nextTag()) != null) continue;
        }
        return subBuilder.build();
    }
}

