/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.annotation.Ignore;
import com.baidu.bjf.remoting.protobuf.code.ICodeGenerator;
import com.baidu.bjf.remoting.protobuf.code.TemplateCodeGenerator;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.CodePrinter;
import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtobufProxy {
    public static final ThreadLocal<Boolean> DEBUG_CONTROLLER = new ThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufProxy.class.getName());
    private static final Map<String, Codec> CACHED = new ConcurrentHashMap<String, Codec>();
    public static final ThreadLocal<File> OUTPUT_PATH = new ThreadLocal();
    public static final ThreadLocal<Boolean> CACHE_ENABLED = new ThreadLocal();
    private static final String DEBUG_CONTROL = "X_DEBUG_ENABLE";

    public static void enableCache(boolean enabled) {
        CACHE_ENABLED.set(enabled);
    }

    public static boolean isCacheEnabled() {
        Boolean b = CACHE_ENABLED.get();
        if (b == null) {
            return true;
        }
        return b;
    }

    public static boolean isDebugEnabled() {
        String debugEnv = System.getenv(DEBUG_CONTROL);
        if (debugEnv != null && Boolean.parseBoolean(debugEnv)) {
            return true;
        }
        Boolean debug = DEBUG_CONTROLLER.get();
        if (debug == null) {
            debug = false;
        }
        return debug;
    }

    public static void dynamicCodeGenerate(OutputStream os, Class cls, Charset charset) throws IOException {
        ProtobufProxy.dynamicCodeGenerate(os, cls, charset, ProtobufProxy.getCodeGenerator(cls));
    }

    public static void dynamicCodeGenerate(OutputStream os, Class cls, Charset charset, ICodeGenerator codeGenerator) throws IOException {
        if (cls == null) {
            throw new NullPointerException("Parameter 'cls' is null");
        }
        if (os == null) {
            throw new NullPointerException("Parameter 'os' is null");
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        String code = codeGenerator.getCode();
        os.write(code.getBytes(charset));
    }

    private static ICodeGenerator getCodeGenerator(Class cls) {
        if (!cls.isMemberClass()) {
            try {
                cls.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalArgumentException("Class '" + cls.getName() + "' must has default constructor method with no parameters.", e2);
            }
            catch (SecurityException e2) {
                throw new IllegalArgumentException(e2.getMessage(), e2);
            }
        }
        TemplateCodeGenerator cg = new TemplateCodeGenerator(cls);
        return cg;
    }

    public static <T> Codec<T> create(Class<T> cls) {
        return ProtobufProxy.create(cls, ProtobufProxy.isDebugEnabled());
    }

    public static <T> Codec<T> create(Class<T> cls, Compiler compiler, ICodeGenerator codeGenerator) {
        return ProtobufProxy.create(cls, ProtobufProxy.isDebugEnabled(), null, compiler, ProtobufProxy.getCodeGenerator(cls));
    }

    public static void compile(Class<?> cls, File outputPath) {
        if (outputPath == null) {
            throw new NullPointerException("Param 'outputPath' is null.");
        }
        if (!outputPath.isDirectory()) {
            throw new RuntimeException("Param 'outputPath' value should be a path directory. path=" + outputPath);
        }
    }

    public static <T> Codec<T> create(Class<T> cls, boolean debug) {
        return ProtobufProxy.create(cls, debug, null);
    }

    public static <T> Codec<T> create(Class<T> cls, boolean debug, File path) {
        Codec codec;
        String uniClsName = cls.getName();
        if (ProtobufProxy.isCacheEnabled() && (codec = CACHED.get(uniClsName)) != null) {
            return codec;
        }
        return ProtobufProxy.create(cls, debug, path, null, ProtobufProxy.getCodeGenerator(cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Codec<T> create(Class<T> cls, boolean debug, File path, Compiler compiler, ICodeGenerator codeGenerator) {
        DEBUG_CONTROLLER.set(debug);
        OUTPUT_PATH.set(path);
        try {
            Codec<T> codec = ProtobufProxy.doCreate(cls, ProtobufProxy.isDebugEnabled(), compiler, codeGenerator);
            return codec;
        }
        finally {
            DEBUG_CONTROLLER.remove();
            OUTPUT_PATH.remove();
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader;
    }

    protected static <T> Codec<T> doCreate(Class<T> cls, boolean debug, Compiler compiler, ICodeGenerator cg) {
        Class<?> newClass;
        Codec codec;
        if (cls == null) {
            throw new NullPointerException("Parameter cls is null");
        }
        Ignore ignore = cls.getAnnotation(Ignore.class);
        if (ignore != null) {
            LOGGER.info("class '{}' marked as @Ignore annotation, proxy ignored.", (Object)cls.getName());
            return null;
        }
        String uniClsName = cls.getName();
        if (ProtobufProxy.isCacheEnabled() && (codec = CACHED.get(uniClsName)) != null) {
            return codec;
        }
        cg.setDebug(debug);
        File path = OUTPUT_PATH.get();
        cg.setOutputPath(path);
        String className = cg.getFullClassName();
        Class<?> c = null;
        try {
            c = Class.forName(className, true, ProtobufProxy.getClassLoader());
        }
        catch (ClassNotFoundException e1) {
            try {
                c = Class.forName(className, true, ProtobufProxy.class.getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                c = null;
            }
        }
        if (c != null) {
            try {
                Codec newInstance = (Codec)c.newInstance();
                if (!CACHED.containsKey(uniClsName)) {
                    CACHED.put(uniClsName, newInstance);
                }
                return newInstance;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        String code = cg.getCode();
        if (debug) {
            String printCode = code;
            CodePrinter.printCode(printCode, "generate protobuf proxy code");
        }
        FileOutputStream fos = null;
        if (path != null && path.isDirectory()) {
            String pkg = "";
            if (className.indexOf(46) != -1) {
                pkg = StringUtils.substringBeforeLast(className, ".");
            }
            String dir = path + File.separator + pkg.replace('.', File.separatorChar);
            File f = new File(dir);
            f.mkdirs();
            try {
                fos = new FileOutputStream(new File(f, cg.getClassName() + ".class"));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (compiler == null) {
            compiler = JDKCompilerHelper.getJdkCompiler();
        }
        long lastModify = ClassHelper.getLastModifyTime(cls);
        try {
            newClass = compiler.compile(className, code, cls.getClassLoader(), fos, lastModify);
        }
        catch (Exception e) {
            compiler = JDKCompilerHelper.getJdkCompiler(cls.getClassLoader());
            newClass = compiler.compile(className, code, cls.getClassLoader(), fos, lastModify);
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            Codec newInstance;
            block30: {
                newInstance = (Codec)newClass.newInstance();
                if (!CACHED.containsKey(uniClsName)) {
                    CACHED.put(uniClsName, newInstance);
                }
                try {
                    Set<Class<?>> relativeProxyClasses = cg.getRelativeProxyClasses();
                    for (Class<?> relativeClass : relativeProxyClasses) {
                        ProtobufProxy.create(relativeClass, debug, path, compiler, cg);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block30;
                    LOGGER.debug(e.getMessage(), e);
                }
            }
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void clearCache() {
        CACHED.clear();
    }
}

