/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MethodCode {
    private String scope;
    private String name;
    private String returnType;
    private List<String> exceptions = new ArrayList<String>();
    private List<String> code = new ArrayList<String>();
    private LinkedHashMap<String, String> parameters = new LinkedHashMap();

    public String toCode() {
        Iterator<Object> iter;
        StringBuilder source = new StringBuilder();
        source.append(StringUtils.trimToEmpty(this.scope)).append(" ");
        if (StringUtils.isEmpty(this.returnType)) {
            source.append("void ");
        } else {
            source.append(this.returnType).append(" ");
        }
        source.append(this.name).append("(");
        if (!this.parameters.isEmpty()) {
            iter = this.parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                source.append(entry.getKey()).append(" ").append(entry.getValue());
                if (!iter.hasNext()) continue;
                source.append(",");
            }
        }
        source.append(") ");
        if (!this.exceptions.isEmpty()) {
            source.append("throws ");
            iter = this.exceptions.iterator();
            while (iter.hasNext()) {
                String exception = (String)iter.next();
                source.append(exception);
                if (!iter.hasNext()) continue;
                source.append(",");
            }
        }
        source.append("{").append("\n");
        for (String c : this.code) {
            source.append("    ").append(c);
        }
        source.append("}").append("\n");
        return source.toString();
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void addParameter(String type, String name) {
        this.parameters.put(type, name);
    }

    public void addException(String exception) {
        this.exceptions.add(exception);
    }

    public void appendLineCode0(String line) {
        this.code.add(line + "\n");
    }

    public void appendLineCode1(String line) {
        this.code.add(line + ";\n");
    }
}

