/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.protocol.Options;
import com.baidu.brpc.utils.BrpcConstants;

public class RpcClientOptions {
    private int protocolType = 1;
    private int connectTimeoutMillis = 1000;
    private int readTimeoutMillis = 1000;
    private int writeTimeoutMillis = 1000;
    private int maxTotalConnections = 8;
    private int minIdleConnections = 8;
    private int maxTryTimes = 3;
    private long timeBetweenEvictionRunsMillis = 300000L;
    private int loadBalanceType = 3;
    private int latencyWindowSizeOfFairLoadBalance = 30;
    private float activeInstancesRatioOfFairLoadBalance = 0.5f;
    private int healthyCheckIntervalMillis = 3000;
    private boolean keepAlive = true;
    private boolean reuseAddr = true;
    private boolean tcpNoDelay = true;
    private int soLinger = 5;
    private int backlog = 100;
    private int receiveBufferSize = 65536;
    private int sendBufferSize = 65536;
    private int keepAliveTime = 300;
    private int ioThreadNum = Runtime.getRuntime().availableProcessors();
    private int workThreadNum = Runtime.getRuntime().availableProcessors();
    private int ioEventType = BrpcConstants.IO_EVENT_JDK;
    private int futureBufferSize = 1000000;
    private String encoding = "utf-8";
    private Options.CompressType compressType = Options.CompressType.COMPRESS_TYPE_NONE;
    private ChannelType channelType = ChannelType.POOLED_CONNECTION;
    private String clientName;
    private boolean globalThreadPoolSharing = false;

    public RpcClientOptions(RpcClientOptions options) {
        this.copyFrom(options);
    }

    public void copyFrom(RpcClientOptions another) {
        this.activeInstancesRatioOfFairLoadBalance = another.activeInstancesRatioOfFairLoadBalance;
        this.backlog = another.backlog;
        this.channelType = another.channelType;
        this.compressType = another.compressType;
        this.connectTimeoutMillis = another.connectTimeoutMillis;
        this.encoding = another.encoding;
        this.futureBufferSize = another.futureBufferSize;
        this.healthyCheckIntervalMillis = another.healthyCheckIntervalMillis;
        this.ioThreadNum = another.ioThreadNum;
        this.keepAlive = another.keepAlive;
        this.keepAliveTime = another.keepAliveTime;
        this.latencyWindowSizeOfFairLoadBalance = another.latencyWindowSizeOfFairLoadBalance;
        this.loadBalanceType = another.loadBalanceType;
        this.maxTotalConnections = another.maxTotalConnections;
        this.maxTryTimes = another.maxTryTimes;
        this.minIdleConnections = another.minIdleConnections;
        this.protocolType = another.protocolType;
        this.readTimeoutMillis = another.readTimeoutMillis;
        this.receiveBufferSize = another.receiveBufferSize;
        this.reuseAddr = another.reuseAddr;
        this.sendBufferSize = another.sendBufferSize;
        this.soLinger = another.soLinger;
        this.tcpNoDelay = another.tcpNoDelay;
        this.timeBetweenEvictionRunsMillis = another.timeBetweenEvictionRunsMillis;
        this.workThreadNum = another.workThreadNum;
        this.writeTimeoutMillis = another.writeTimeoutMillis;
        this.clientName = another.clientName;
        this.globalThreadPoolSharing = another.globalThreadPoolSharing;
    }

    public void setProtocolType(int protocolType) {
        this.protocolType = protocolType;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setWriteTimeoutMillis(int writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMinIdleConnections(int minIdleConnections) {
        this.minIdleConnections = minIdleConnections;
    }

    public void setMaxTryTimes(int maxTryTimes) {
        this.maxTryTimes = maxTryTimes;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setLoadBalanceType(int loadBalanceType) {
        this.loadBalanceType = loadBalanceType;
    }

    public void setLatencyWindowSizeOfFairLoadBalance(int latencyWindowSizeOfFairLoadBalance) {
        this.latencyWindowSizeOfFairLoadBalance = latencyWindowSizeOfFairLoadBalance;
    }

    public void setActiveInstancesRatioOfFairLoadBalance(float activeInstancesRatioOfFairLoadBalance) {
        this.activeInstancesRatioOfFairLoadBalance = activeInstancesRatioOfFairLoadBalance;
    }

    public void setHealthyCheckIntervalMillis(int healthyCheckIntervalMillis) {
        this.healthyCheckIntervalMillis = healthyCheckIntervalMillis;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setIoThreadNum(int ioThreadNum) {
        this.ioThreadNum = ioThreadNum;
    }

    public void setWorkThreadNum(int workThreadNum) {
        this.workThreadNum = workThreadNum;
    }

    public void setIoEventType(int ioEventType) {
        this.ioEventType = ioEventType;
    }

    public void setFutureBufferSize(int futureBufferSize) {
        this.futureBufferSize = futureBufferSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCompressType(Options.CompressType compressType) {
        this.compressType = compressType;
    }

    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setGlobalThreadPoolSharing(boolean globalThreadPoolSharing) {
        this.globalThreadPoolSharing = globalThreadPoolSharing;
    }

    public int getProtocolType() {
        return this.protocolType;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMinIdleConnections() {
        return this.minIdleConnections;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public int getLoadBalanceType() {
        return this.loadBalanceType;
    }

    public int getLatencyWindowSizeOfFairLoadBalance() {
        return this.latencyWindowSizeOfFairLoadBalance;
    }

    public float getActiveInstancesRatioOfFairLoadBalance() {
        return this.activeInstancesRatioOfFairLoadBalance;
    }

    public int getHealthyCheckIntervalMillis() {
        return this.healthyCheckIntervalMillis;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getIoThreadNum() {
        return this.ioThreadNum;
    }

    public int getWorkThreadNum() {
        return this.workThreadNum;
    }

    public int getIoEventType() {
        return this.ioEventType;
    }

    public int getFutureBufferSize() {
        return this.futureBufferSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Options.CompressType getCompressType() {
        return this.compressType;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isGlobalThreadPoolSharing() {
        return this.globalThreadPoolSharing;
    }

    public RpcClientOptions() {
    }
}

