/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.compress;

import com.baidu.brpc.compress.Compress;
import com.baidu.brpc.compress.GzipCompress;
import com.baidu.brpc.compress.NoneCompress;
import com.baidu.brpc.compress.SnappyCompress;
import com.baidu.brpc.compress.ZlibCompress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressManager {
    private static final Logger log = LoggerFactory.getLogger(CompressManager.class);
    private static final int MAX_COMPRESS_NUM = 16;
    private static volatile CompressManager instance;
    private Compress[] compressArray = new Compress[16];
    private int compressNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompressManager getInstance() {
        if (instance != null) return instance;
        Class<CompressManager> clazz = CompressManager.class;
        synchronized (CompressManager.class) {
            if (instance != null) return instance;
            instance = new CompressManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CompressManager() {
        this.compressArray[0] = new NoneCompress();
        this.compressArray[2] = new GzipCompress();
        this.compressArray[3] = new ZlibCompress();
        this.compressArray[1] = new SnappyCompress();
        this.compressNum = 4;
    }

    public Compress getCompress(int compressType) {
        if (compressType < 0 || compressType >= this.compressNum) {
            throw new RuntimeException("out of bound");
        }
        Compress compress = this.compressArray[compressType];
        if (compress == null) {
            String errMsg = String.format("compress type=%d not support", compressType);
            log.warn(errMsg);
            throw new RuntimeException(errMsg);
        }
        return compress;
    }
}

