/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server.handler;

import com.baidu.brpc.RpcContext;
import com.baidu.brpc.interceptor.DefaultInterceptorChain;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.server.RpcServer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerWorkTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ServerWorkTask.class);
    private RpcServer rpcServer;
    private Protocol protocol;
    private Request request;
    private Response response;
    private ChannelHandlerContext ctx;

    @Override
    public void run() {
        RpcContext rpcContext = null;
        if (this.request != null) {
            this.request.setChannel(this.ctx.channel());
            rpcContext = RpcContext.getContext();
            rpcContext.setRemoteAddress(this.ctx.channel().remoteAddress());
            rpcContext.setChannel(this.ctx.channel());
            if (this.request.getBinaryAttachment() != null || this.request.getKvAttachment() != null) {
                if (this.request.getBinaryAttachment() != null) {
                    rpcContext.setRequestBinaryAttachment(this.request.getBinaryAttachment());
                }
                if (this.request.getKvAttachment() != null) {
                    rpcContext.setRequestKvAttachment(this.request.getKvAttachment());
                }
            }
            this.response.setLogId(this.request.getLogId());
            this.response.setCorrelationId(this.request.getCorrelationId());
            this.response.setCompressType(this.request.getCompressType());
            this.response.setException(this.request.getException());
            this.response.setRpcMethodInfo(this.request.getRpcMethodInfo());
        }
        if (this.response.getException() == null) {
            try {
                DefaultInterceptorChain interceptorChain = new DefaultInterceptorChain(this.rpcServer.getInterceptors());
                interceptorChain.intercept(this.request, this.response);
                if (RpcContext.isSet()) {
                    rpcContext = RpcContext.getContext();
                    if (rpcContext.getResponseBinaryAttachment() != null && rpcContext.getResponseBinaryAttachment().isReadable()) {
                        this.response.setBinaryAttachment(rpcContext.getResponseBinaryAttachment());
                    }
                    if (rpcContext.getResponseKvAttachment() != null && !rpcContext.getResponseKvAttachment().isEmpty()) {
                        this.response.setKvAttachment(rpcContext.getResponseKvAttachment());
                    }
                }
            }
            catch (Throwable ex) {
                String errorMsg = String.format("failed to execute interceptor chain, msg=%s", ex.getMessage());
                log.warn(errorMsg, ex);
                this.response.setException(ex);
            }
        }
        if (!this.request.isOneWay()) {
            try {
                ByteBuf byteBuf = this.protocol.encodeResponse(this.request, this.response);
                ChannelFuture channelFuture = this.ctx.channel().writeAndFlush(byteBuf);
                this.protocol.afterResponseSent(this.request, this.response, channelFuture);
            }
            catch (Exception ex) {
                log.warn("send response failed:", ex);
            }
        }
        if (rpcContext != null) {
            if (rpcContext.getRequestBinaryAttachment() != null && rpcContext.getRequestBinaryAttachment().refCnt() > 0) {
                rpcContext.getRequestBinaryAttachment().release();
            }
            rpcContext.reset();
        }
    }

    public void setRpcServer(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public ServerWorkTask(RpcServer rpcServer, Protocol protocol, Request request, Response response, ChannelHandlerContext ctx) {
        this.rpcServer = rpcServer;
        this.protocol = protocol;
        this.request = request;
        this.response = response;
        this.ctx = ctx;
    }
}

