/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.ProtobufFormatter;
import com.googlecode.protobuf.format.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JsonJacksonFormat
extends ProtobufFormatter {
    private static JsonFactory jsonFactory = new JsonFactory();
    private static final long MAX_UINT_VALUE = 0xFFFFFFFFL;
    private static final BigInteger MAX_ULONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.ONE);

    @Override
    public void print(Message message, OutputStream output, Charset cs) throws IOException {
        JsonGenerator generator = this.createGenerator(output);
        this.print(message, generator);
        generator.close();
    }

    public void print(Message message, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        this.printMessage(message, generator);
        generator.writeEndObject();
        generator.flush();
    }

    @Override
    public void print(UnknownFieldSet fields, OutputStream output, Charset cs) throws IOException {
        JsonGenerator generator = this.createGenerator(output);
        generator.writeStartObject();
        this.printUnknownFields(fields, generator);
        generator.writeEndObject();
        generator.close();
    }

    @Override
    public void merge(InputStream input, Charset cs, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        JsonParser parser = jsonFactory.createJsonParser(input);
        this.merge(parser, extensionRegistry, builder);
    }

    public void merge(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        JsonToken token = parser.nextToken();
        if (token.equals((Object)JsonToken.START_OBJECT)) {
            token = parser.nextToken();
        }
        while (token != null && !token.equals((Object)JsonToken.END_OBJECT)) {
            this.mergeField(parser, extensionRegistry, builder);
            token = parser.nextToken();
        }
        if (parser.nextToken() != null) {
            throw new RuntimeException("Expecting the end of the stream, but there seems to be more data!  Check the input for a valid JSON format.");
        }
    }

    protected JsonGenerator createGenerator(OutputStream output) throws IOException {
        JsonGenerator generator = jsonFactory.createJsonGenerator(output, JsonEncoding.UTF8);
        generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return generator;
    }

    protected void printMessage(Message message, JsonGenerator generator) throws IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
            this.printField(field.getKey(), field.getValue(), generator);
        }
        this.printUnknownFields(message.getUnknownFields(), generator);
    }

    public void printField(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        this.printSingleField(field, value, generator);
    }

    private void printSingleField(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        if (field.isExtension()) {
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.writeFieldName(field.getMessageType().getFullName());
            } else {
                generator.writeFieldName(field.getFullName());
            }
        } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            generator.writeFieldName(field.getMessageType().getName());
        } else {
            generator.writeFieldName(field.getName());
        }
        if (field.isRepeated()) {
            generator.writeStartArray();
            Iterator iter = ((List)value).iterator();
            while (iter.hasNext()) {
                this.printFieldValue(field, iter.next(), generator);
            }
            generator.writeEndArray();
        } else {
            this.printFieldValue(field, value, generator);
        }
    }

    private void printFieldValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                generator.writeNumber(((Integer)value).intValue());
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                generator.writeNumber(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber(((Double)value).doubleValue());
                break;
            }
            case BOOL: {
                generator.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.writeNumber(Integer.toUnsignedLong((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.writeNumber(TextUtils.unsignedLong((Long)value));
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case BYTES: {
                generator.writeBinary(((ByteString)value).toByteArray());
                break;
            }
            case ENUM: {
                generator.writeString(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                generator.writeStartObject();
                this.printMessage((Message)value, generator);
                generator.writeEndObject();
            }
        }
    }

    protected void printUnknownFields(UnknownFieldSet unknownFields, JsonGenerator generator) throws IOException {
        for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = entry.getValue();
            generator.writeArrayFieldStart(entry.getKey().toString());
            Iterator<Object> iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                generator.writeNumber(value);
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                generator.writeNumber(value);
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                generator.writeNumber(value);
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                generator.writeBinary(value.toByteArray());
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.writeStartObject();
                this.printUnknownFields(value, generator);
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
    }

    protected void mergeField(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder) throws JsonParseException, IOException {
        Descriptors.FieldDescriptor field = null;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        boolean unknown = false;
        ExtensionRegistry.ExtensionInfo extension = null;
        JsonToken token = parser.getCurrentToken();
        if (token != null) {
            String lowerName;
            String name = parser.getCurrentName();
            if (name.contains(".")) {
                extension = extensionRegistry.findExtensionByName(name);
                if (extension == null) {
                    throw new RuntimeException("Extension \"" + name + "\" not found in the ExtensionRegistry.");
                }
                if (extension.descriptor.getContainingType() != type) {
                    throw new RuntimeException("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
                }
                field = extension.descriptor;
            } else {
                field = type.findFieldByName(name);
            }
            if (field == null && (field = type.findFieldByName(lowerName = name.toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field = null;
            }
            if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name) && !field.getMessageType().getFullName().equalsIgnoreCase(name)) {
                field = null;
            }
            if (field == null && TextUtils.isDigits(name)) {
                field = type.findFieldByNumber(Integer.parseInt(name));
                unknown = true;
            }
            if (field == null) {
                UnknownFieldSet.Builder unknownsBuilder = UnknownFieldSet.newBuilder();
                this.handleMissingField(name, parser, extensionRegistry, unknownsBuilder);
                builder.setUnknownFields(unknownsBuilder.build());
            }
        }
        if (field != null) {
            token = parser.nextToken();
            boolean array = token.equals((Object)JsonToken.START_ARRAY);
            if (array) {
                token = parser.nextToken();
                while (!token.equals((Object)JsonToken.END_ARRAY)) {
                    this.handleValue(parser, extensionRegistry, builder, field, extension, unknown);
                    token = parser.nextToken();
                }
            } else {
                this.handleValue(parser, extensionRegistry, builder, field, extension, unknown);
            }
        }
    }

    private void handleMissingField(String fieldName, JsonParser parser, ExtensionRegistry extensionRegistry, UnknownFieldSet.Builder builder) throws IOException {
        JsonToken token = parser.nextToken();
        if (token.equals((Object)JsonToken.START_OBJECT)) {
            token = parser.nextToken();
            while (token != null && !token.equals((Object)JsonToken.END_OBJECT)) {
                this.handleMissingField(fieldName, parser, extensionRegistry, builder);
                token = parser.nextToken();
            }
        } else if (token.equals((Object)JsonToken.START_ARRAY)) {
            do {
                this.handleMissingField(fieldName, parser, extensionRegistry, builder);
            } while ((token = parser.getCurrentToken()) != null && !token.equals((Object)JsonToken.END_ARRAY));
        }
    }

    private void handleValue(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, boolean unknown) throws IOException {
        Object value = null;
        value = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? this.handleObject(parser, extensionRegistry, builder, field, extension, unknown) : this.handlePrimitive(parser, field);
        if (value != null) {
            if (field.isRepeated()) {
                builder.addRepeatedField(field, value);
            } else {
                builder.setField(field, value);
            }
        }
    }

    private Object handlePrimitive(JsonParser parser, Descriptors.FieldDescriptor field) throws IOException {
        Object value = null;
        JsonToken token = parser.getCurrentToken();
        if (token.equals((Object)JsonToken.VALUE_NULL)) {
            return value;
        }
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                value = parser.getIntValue();
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                value = parser.getLongValue();
                break;
            }
            case UINT32: 
            case FIXED32: {
                long valueLong = parser.getLongValue();
                if (valueLong < 0L || valueLong > 0xFFFFFFFFL) {
                    throw new NumberFormatException("Number must be positive: " + valueLong);
                }
                value = (int)valueLong;
                break;
            }
            case UINT64: 
            case FIXED64: {
                BigInteger valueBigInt = parser.getBigIntegerValue();
                if (valueBigInt.compareTo(BigInteger.ZERO) == -1 || valueBigInt.compareTo(MAX_ULONG_VALUE) == 1) {
                    throw new NumberFormatException("Number must be positive: " + valueBigInt);
                }
                value = valueBigInt.longValue();
                break;
            }
            case FLOAT: {
                value = Float.valueOf(parser.getFloatValue());
                break;
            }
            case DOUBLE: {
                value = parser.getDoubleValue();
                break;
            }
            case BOOL: {
                value = parser.getBooleanValue();
                break;
            }
            case STRING: {
                value = parser.getText();
                break;
            }
            case BYTES: {
                value = ByteString.copyFrom(parser.getBinaryValue());
                break;
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                if (token.equals((Object)JsonToken.VALUE_NUMBER_INT)) {
                    int number = parser.getIntValue();
                    value = enumType.findValueByNumber(number);
                    if (value != null) break;
                    throw new RuntimeException("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + ".");
                }
                String id = parser.getText();
                value = enumType.findValueByName(id);
                if (value != null) break;
                throw new RuntimeException("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
            }
            case MESSAGE: 
            case GROUP: {
                throw new RuntimeException("Can't get here.");
            }
        }
        return value;
    }

    private Object handleObject(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, boolean unknown) throws IOException {
        Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
        JsonToken token = parser.getCurrentToken();
        if (unknown) {
            ByteString data = ByteString.copyFrom(parser.getBinaryValue());
            try {
                subBuilder.mergeFrom(data);
                return subBuilder.build();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Failed to build " + field.getFullName() + " from " + data);
            }
        }
        if (token.equals((Object)JsonToken.START_OBJECT)) {
            token = parser.nextToken();
            while (token != null && !token.equals((Object)JsonToken.END_OBJECT)) {
                this.mergeField(parser, extensionRegistry, subBuilder);
                token = parser.nextToken();
            }
        }
        return subBuilder.build();
    }
}

