/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc;

import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.FastFutureStore;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.Response;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelInfo {
    private static final Logger log = LoggerFactory.getLogger(ChannelInfo.class);
    private static final AttributeKey<ChannelInfo> CLIENT_CHANNEL_KEY = AttributeKey.valueOf("client_key");
    private static final AttributeKey<ChannelInfo> SERVER_CHANNEL_KEY = AttributeKey.valueOf("server_key");
    private Channel channel;
    private BrpcChannel channelGroup;
    private Protocol protocol;
    private long correlationId;
    private FastFutureStore pendingRpc;
    private DynamicCompositeByteBuf recvBuf = new DynamicCompositeByteBuf(16);

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public static ChannelInfo getOrCreateClientChannelInfo(Channel channel) {
        Attribute<ChannelInfo> attribute = channel.attr(CLIENT_CHANNEL_KEY);
        ChannelInfo channelInfo = attribute.get();
        if (channelInfo == null) {
            channelInfo = new ChannelInfo();
            channelInfo.setPendingRpc(FastFutureStore.getInstance(0));
            channelInfo.setChannel(channel);
            attribute.set(channelInfo);
        }
        return channelInfo;
    }

    public static ChannelInfo getClientChannelInfo(Channel channel) {
        Attribute<ChannelInfo> attribute = channel.attr(CLIENT_CHANNEL_KEY);
        return attribute.get();
    }

    public static ChannelInfo getOrCreateServerChannelInfo(Channel channel) {
        Attribute<ChannelInfo> attribute = channel.attr(SERVER_CHANNEL_KEY);
        ChannelInfo channelInfo = attribute.get();
        if (channelInfo == null) {
            channelInfo = new ChannelInfo();
            channelInfo.setChannel(channel);
            attribute.set(channelInfo);
        }
        return channelInfo;
    }

    public static ChannelInfo getServerChannelInfo(Channel channel) {
        Attribute<ChannelInfo> attribute = channel.attr(SERVER_CHANNEL_KEY);
        return attribute.get();
    }

    public long addRpcFuture(RpcFuture future) {
        return this.pendingRpc.put(future);
    }

    public RpcFuture getRpcFuture(long correlationId) {
        return this.pendingRpc.get(correlationId);
    }

    public RpcFuture removeRpcFuture(long correlationId) {
        return this.pendingRpc.getAndRemove(correlationId);
    }

    public void handleRequestFail(ChannelType channelType, long correlationId) {
        this.removeRpcFuture(correlationId);
        if (channelType == ChannelType.SHORT_CONNECTION) {
            this.channel.close();
            this.channelGroup.close();
        } else {
            this.channelGroup.incFailedNum();
            this.returnChannelAfterRequest(channelType);
        }
    }

    public void handleRequestSuccess(ChannelType channelType) {
        this.returnChannelAfterRequest(channelType);
    }

    private void returnChannelAfterRequest(ChannelType channelType) {
        if (channelType != ChannelType.SHORT_CONNECTION && this.protocol.returnChannelBeforeResponse()) {
            this.channelGroup.returnChannel(this.channel);
        }
    }

    public void handleResponseFail() {
        this.channelGroup.incFailedNum();
        this.returnChannelAfterResponse();
    }

    public void handleResponseSuccess() {
        this.returnChannelAfterResponse();
    }

    private void returnChannelAfterResponse() {
        if (!this.protocol.returnChannelBeforeResponse()) {
            this.channelGroup.returnChannel(this.channel);
        }
    }

    public void handleChannelException(RpcException ex) {
        if (this.channelGroup != null) {
            this.channelGroup.removeChannel(this.channel);
        }
        this.pendingRpc.traverse(new ChannelErrorStoreWalker(this.channel, ex));
    }

    public void close() {
        log.debug("close the channel:{}", (Object)this.channel);
        this.channel.close();
    }

    protected ChannelInfo() {
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setChannelGroup(BrpcChannel channelGroup) {
        this.channelGroup = channelGroup;
    }

    public void setCorrelationId(long correlationId) {
        this.correlationId = correlationId;
    }

    public void setPendingRpc(FastFutureStore pendingRpc) {
        this.pendingRpc = pendingRpc;
    }

    public void setRecvBuf(DynamicCompositeByteBuf recvBuf) {
        this.recvBuf = recvBuf;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public BrpcChannel getChannelGroup() {
        return this.channelGroup;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public long getCorrelationId() {
        return this.correlationId;
    }

    public FastFutureStore getPendingRpc() {
        return this.pendingRpc;
    }

    public DynamicCompositeByteBuf getRecvBuf() {
        return this.recvBuf;
    }

    private static class ChannelErrorStoreWalker
    implements FastFutureStore.StoreWalker {
        private Channel currentChannel;
        private RpcException exception;

        public ChannelErrorStoreWalker(Channel currentChannel, RpcException exception) {
            this.currentChannel = currentChannel;
            this.exception = exception;
        }

        @Override
        public boolean visitElement(RpcFuture fut) {
            ChannelInfo chanInfo = fut.getChannelInfo();
            if (null == chanInfo) {
                return true;
            }
            return this.currentChannel != chanInfo.channel;
        }

        @Override
        public void actionAfterDelete(RpcFuture fut) {
            Response response = fut.getRpcClient().getProtocol().createResponse();
            response.setException(this.exception);
            response.setRpcFuture(fut);
            fut.handleResponse(response);
        }
    }
}

