/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.utils;

import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(CustomThreadFactory.class);
    private AtomicInteger threadNumber = new AtomicInteger(1);
    private String namePrefix;
    private ThreadGroup group;

    public CustomThreadFactory(String namePrefix) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.namePrefix + this.threadNumber.getAndIncrement();
        FastThreadLocalThread t = new FastThreadLocalThread(this.group, r, name, 0L);
        t.setDaemon(true);
        t.setPriority(5);
        log.info("create thread:{}", (Object)name);
        return t;
    }
}

