/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.utils;

import com.baidu.brpc.protocol.BrpcMeta;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMetaUtils {
    private static final Logger log = LoggerFactory.getLogger(RpcMetaUtils.class);

    public static RpcMetaInfo parseRpcMeta(Method targetMethod) {
        String methodName;
        String serviceName;
        BrpcMeta rpcMeta = targetMethod.getAnnotation(BrpcMeta.class);
        if (rpcMeta != null) {
            serviceName = rpcMeta.serviceName();
            methodName = rpcMeta.methodName();
        } else {
            serviceName = targetMethod.getDeclaringClass().getName();
            methodName = targetMethod.getName();
        }
        log.debug("serviceName={}, methodName={}", (Object)serviceName, (Object)methodName);
        RpcMetaInfo rpcMetaInfo = new RpcMetaInfo();
        rpcMetaInfo.setServiceName(serviceName);
        rpcMetaInfo.setMethodName(methodName);
        return rpcMetaInfo;
    }

    public static class RpcMetaInfo {
        private String serviceName;
        private String methodName;

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

