/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils.compiler;

import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.compiler.AbstractCompiler;
import com.baidu.bjf.remoting.protobuf.utils.compiler.ClassUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;

public class JavassistCompiler
extends AbstractCompiler {
    private Map<String, byte[]> bytesMap = new HashMap<String, byte[]>();
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+([\\w\\.\\*]+);\n");
    private static final Pattern EXTENDS_PATTERN = Pattern.compile("\\s+extends\\s+([\\w\\.]+)[^\\{]*\\{\n");
    private static final Pattern IMPLEMENTS_PATTERN = Pattern.compile("\\s+implements\\s+([\\w\\.]+)\\s*\\{\n");
    private static final Pattern METHODS_PATTERN = Pattern.compile("\n(private|public|protected)\\s+");
    private static final Pattern FIELD_PATTERN = Pattern.compile("[^\n]+=[^\n]+;");

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized Class<?> doCompile(String name, String source, OutputStream os) throws Throwable {
        String[] methods;
        String defined;
        CtClass cls;
        int i = name.lastIndexOf(46);
        String className = i < 0 ? name : name.substring(i + 1);
        ClassPool pool = new ClassPool(true);
        pool.appendClassPath(new LoaderClassPath(ClassHelper.getCallerClassLoader(this.getClass())));
        Matcher matcher = IMPORT_PATTERN.matcher(source);
        ArrayList<String> importPackages = new ArrayList<String>();
        HashMap<String, String> fullNames = new HashMap<String, String>();
        while (matcher.find()) {
            String pkg = matcher.group(1);
            if (pkg.endsWith(".*")) {
                String pkgName = pkg.substring(0, pkg.length() - 2);
                pool.importPackage(pkgName);
                importPackages.add(pkgName);
                continue;
            }
            int pi = pkg.lastIndexOf(46);
            if (pi <= 0) continue;
            String pkgName = pkg.substring(0, pi);
            pool.importPackage(pkgName);
            importPackages.add(pkgName);
            fullNames.put(pkg.substring(pi + 1), pkg);
        }
        String[] packages = importPackages.toArray(new String[0]);
        matcher = EXTENDS_PATTERN.matcher(source);
        if (matcher.find()) {
            void var13_17;
            String extend = matcher.group(1).trim();
            if (extend.contains(".")) {
                String string = extend;
            } else if (fullNames.containsKey(extend)) {
                String string = (String)fullNames.get(extend);
            } else {
                String string = ClassUtils.forName(packages, extend).getName();
            }
            cls = pool.makeClass(name, pool.get((String)var13_17));
        } else {
            cls = pool.makeClass(name);
        }
        matcher = IMPLEMENTS_PATTERN.matcher(source);
        if (matcher.find()) {
            String[] ifaces;
            for (String iface : ifaces = matcher.group(1).trim().split("\\,")) {
                String ifaceClass = (iface = iface.trim()).contains(".") ? iface : (fullNames.containsKey(iface) ? (String)fullNames.get(iface) : ClassUtils.forName(packages, iface).getName());
                cls.addInterface(pool.get(ifaceClass));
            }
        }
        if ((defined = source.substring(0, source.indexOf("{"))).indexOf("enum") != -1) {
            // empty if block
        }
        String string = source.substring(source.indexOf("{") + 1, source.length() - 1);
        for (String method : methods = METHODS_PATTERN.split(string)) {
            if ((method = method.trim()).length() <= 0) continue;
            if (method.startsWith(className)) {
                cls.addConstructor(CtNewConstructor.make("public " + method, cls));
                continue;
            }
            if (FIELD_PATTERN.matcher(method).matches()) {
                cls.addField(CtField.make("private " + method, cls));
                continue;
            }
            cls.addMethod(CtNewMethod.make("public " + method, cls));
        }
        this.bytesMap.put(name, cls.toBytecode());
        return cls.toClass(ClassHelper.getCallerClassLoader(this.getClass()), null);
    }

    @Override
    public byte[] loadBytes(String className) {
        return this.bytesMap.get(className);
    }
}

