/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.FastFutureStore;
import com.baidu.brpc.client.MethodUtils;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.instance.ServiceInstance;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.RpcRequest;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.push.RegisterService;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.net.InetSocketAddress;
import java.util.Queue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrpcChannel
implements BrpcChannel {
    private static final Logger log = LoggerFactory.getLogger(AbstractBrpcChannel.class);
    protected ServiceInstance serviceInstance;
    protected Bootstrap bootstrap;
    protected Protocol protocol;
    protected RpcClient rpcClient;

    public AbstractBrpcChannel(ServiceInstance serviceInstance, Bootstrap bootstrap, Protocol protocol, RpcClient rpcClient) {
        this.serviceInstance = serviceInstance;
        this.bootstrap = bootstrap;
        this.protocol = protocol;
        this.rpcClient = rpcClient;
    }

    @Override
    public void updateChannel(Channel channel) {
    }

    public void sendClientNameToServer(ChannelFuture channelFuture) {
        ByteBuf byteBuf;
        RpcClientOptions rpcClientOptions = this.rpcClient.getRpcClientOptions();
        RpcRequest r = new RpcRequest();
        r.setChannel(channelFuture.channel());
        r.setReadTimeoutMillis(10000);
        r.setWriteTimeoutMillis(10000);
        SPHead spHead = ((ServerPushProtocol)this.protocol).createSPHead();
        spHead.setType(4);
        r.setSpHead(spHead);
        String serviceName = RegisterService.class.getName();
        String methodName = "registerClient";
        r.setServiceName(serviceName);
        r.setMethodName(methodName);
        RpcMethodInfo rpcMethodInfo = MethodUtils.getRpcMethodInfo(RegisterService.class, methodName);
        r.setRpcMethodInfo(rpcMethodInfo);
        r.setArgs(new Object[]{this.rpcClient.getRpcClientOptions().getClientName()});
        RpcFuture registerRpcFuture = new RpcFuture();
        long correlationId = FastFutureStore.getInstance(0).put(registerRpcFuture);
        registerRpcFuture.setCorrelationId(correlationId);
        r.setCorrelationId(correlationId);
        try {
            log.debug("send sendClientNameToServer, name:{}, correlationId:{}", (Object)rpcClientOptions.getClientName(), (Object)r.getCorrelationId());
            byteBuf = this.protocol.encodeRequest(r);
        }
        catch (Exception e) {
            log.error("send report packet to server, encode packet failed, msg:", e);
            throw new RpcException(5, "rpc encode failed:", e);
        }
        channelFuture.channel().writeAndFlush(byteBuf);
    }

    @Override
    public Channel connect(final String ip, final int port) {
        final ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(ip, port));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    log.debug("future callback, connect to {}:{} success, channel={}", ip, port, channelFuture.channel());
                    if (AbstractBrpcChannel.this.protocol instanceof ServerPushProtocol) {
                        AbstractBrpcChannel.this.sendClientNameToServer(future);
                    }
                } else {
                    log.debug("future callback, connect to {}:{} failed due to {}", ip, port, channelFuture.cause().getMessage());
                }
            }
        });
        future.syncUninterruptibly();
        if (future.isSuccess()) {
            return future.channel();
        }
        log.error("connect to {}:{} failed, msg={}", ip, port, future.cause().getMessage());
        throw new RpcException(future.cause());
    }

    @Override
    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    @Override
    public long getFailedNum() {
        return 0L;
    }

    @Override
    public void incFailedNum() {
    }

    @Override
    public Queue<Integer> getLatencyWindow() {
        return null;
    }

    @Override
    public void updateLatency(int latency) {
    }

    @Override
    public void updateLatencyWithReadTimeOut() {
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.serviceInstance.getIp()).append(this.serviceInstance.getPort()).toHashCode();
    }

    @Override
    public boolean equals(Object object) {
        boolean flag = false;
        if (object != null && BrpcChannel.class.isAssignableFrom(object.getClass())) {
            BrpcChannel rhs = (BrpcChannel)object;
            flag = new EqualsBuilder().append(this.serviceInstance.getIp(), rhs.getServiceInstance().getIp()).append(this.serviceInstance.getPort(), rhs.getServiceInstance().getPort()).isEquals();
        }
        return flag;
    }
}

