/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.BrpcPooledChannel;
import com.baidu.brpc.client.channel.BrpcShortChannel;
import com.baidu.brpc.client.channel.BrpcSingleChannel;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.client.instance.ServiceInstance;

public class BrpcChannelFactory {
    public static BrpcChannel createChannel(ServiceInstance instance, RpcClient rpcClient) {
        ChannelType channelType = rpcClient.getRpcClientOptions().getChannelType();
        if (channelType == ChannelType.POOLED_CONNECTION) {
            return new BrpcPooledChannel(instance, rpcClient);
        }
        if (channelType == ChannelType.SINGLE_CONNECTION) {
            return new BrpcSingleChannel(instance, rpcClient);
        }
        if (channelType == ChannelType.SHORT_CONNECTION) {
            return new BrpcShortChannel(instance, rpcClient);
        }
        throw new IllegalArgumentException("channel type is not valid:" + channelType.getName());
    }
}

