/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol;

import com.baidu.brpc.protocol.AbstractRequest;
import com.baidu.brpc.protocol.Request;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.FastThreadLocal;

public class HttpRequest
extends AbstractRequest {
    private static final FastThreadLocal<HttpRequest> CURRENT_RPC_REQUEST = new FastThreadLocal<HttpRequest>(){

        @Override
        protected HttpRequest initialValue() {
            return new HttpRequest();
        }
    };
    private FullHttpRequest nettyHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "");

    public static HttpRequest getHttpRequest() {
        return CURRENT_RPC_REQUEST.get();
    }

    @Override
    public Object getMsg() {
        return this.nettyHttpRequest;
    }

    @Override
    public void setMsg(Object o) {
        FullHttpRequest request = (FullHttpRequest)o;
        this.nettyHttpRequest.setProtocolVersion(request.protocolVersion());
        this.nettyHttpRequest.headers().add(request.headers());
        this.nettyHttpRequest.setMethod(request.method());
        this.nettyHttpRequest.setUri(request.uri());
        this.nettyHttpRequest.content().writeBytes(request.content());
        this.nettyHttpRequest.trailingHeaders().add(request.trailingHeaders());
        this.nettyHttpRequest.setDecoderResult(request.decoderResult());
    }

    @Override
    public void reset() {
        super.reset();
        this.nettyHttpRequest.setUri("");
        this.nettyHttpRequest.content().clear();
        this.nettyHttpRequest.headers().clear();
        this.nettyHttpRequest.trailingHeaders().clear();
    }

    @Override
    public Request retain() {
        super.retain();
        this.nettyHttpRequest.retain();
        return this;
    }

    @Override
    public void release() {
        super.release();
        if (this.nettyHttpRequest.refCnt() > 0) {
            this.nettyHttpRequest.release();
        }
    }

    public HttpHeaders headers() {
        return this.nettyHttpRequest.headers();
    }

    public String uri() {
        return this.nettyHttpRequest.uri();
    }

    public ByteBuf content() {
        return this.nettyHttpRequest.content();
    }

    public FullHttpRequest getNettyHttpRequest() {
        return this.nettyHttpRequest;
    }

    public void setNettyHttpRequest(FullHttpRequest nettyHttpRequest) {
        this.nettyHttpRequest = nettyHttpRequest;
    }
}

