/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.nshead;

import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.nshead.NSHeadRpcProtocol;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSHeadProtobufProtocol
extends NSHeadRpcProtocol {
    private static final Logger log = LoggerFactory.getLogger(NSHeadProtobufProtocol.class);

    public NSHeadProtobufProtocol(String encoding) {
        super(encoding);
    }

    @Override
    public byte[] encodeBody(Object body, RpcMethodInfo rpcMethodInfo) {
        byte[] bytes;
        Validate.notNull(body, "body must not be empty", new Object[0]);
        try {
            bytes = rpcMethodInfo.getTarget() != null ? rpcMethodInfo.outputEncode(body) : rpcMethodInfo.inputEncode(body);
        }
        catch (IOException ex) {
            throw new RpcException(5, (Throwable)ex);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decodeBody(ByteBuf bodyBuf, RpcMethodInfo rpcMethodInfo) {
        try {
            Object result;
            try {
                result = rpcMethodInfo.getTarget() != null ? rpcMethodInfo.inputDecode(bodyBuf) : rpcMethodInfo.outputDecode(bodyBuf);
            }
            catch (IOException e) {
                log.warn("invoke parseFrom method error", e);
                throw new RpcException(5, (Throwable)e);
            }
            Object object = result;
            return object;
        }
        finally {
            if (bodyBuf != null) {
                bodyBuf.release();
            }
        }
    }
}

