/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.CollectionSchema;
import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Morph;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.WireFormat;
import com.dyuproject.protostuff.runtime.Delegate;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.HasSchema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.MappedSchema;
import com.dyuproject.protostuff.runtime.PolymorphicSchema;
import com.dyuproject.protostuff.runtime.PolymorphicSchemaFactories;
import com.dyuproject.protostuff.runtime.RuntimeCollectionField;
import com.dyuproject.protostuff.runtime.RuntimeEnv;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RuntimeCollectionFieldFactory {
    private static final RuntimeFieldFactory<Collection<?>> COLLECTION = new RuntimeFieldFactory<Collection<?>>(25){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            Class<?> clazz = f.getType();
            if (Modifier.isAbstract(clazz.getModifiers())) {
                if (!clazz.isInterface()) {
                    return OBJECT.create(number, name, f, strategy);
                }
                Morph morph = f.getAnnotation(Morph.class);
                if (morph == null ? RuntimeEnv.MORPH_COLLECTION_INTERFACES : morph.value()) {
                    return OBJECT.create(number, name, f, strategy);
                }
            }
            if (EnumSet.class.isAssignableFrom(f.getType())) {
                Class<?> enumType = 6.getGenericType(f, 0);
                if (enumType == null) {
                    return RuntimeFieldFactory.OBJECT.create(number, name, f, strategy);
                }
                return RuntimeCollectionFieldFactory.createCollectionEnumV(number, name, f, strategy.getEnumIO(enumType).getEnumSetFactory(), enumType, strategy);
            }
            CollectionSchema.MessageFactory messageFactory = strategy.getCollectionFactory(f.getType());
            Class<?> genericType = 6.getGenericType(f, 0);
            if (genericType == null) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, strategy.OBJECT_ELEMENT_SCHEMA, strategy.OBJECT_ELEMENT_SCHEMA.pipeSchema, strategy);
            }
            Delegate<?> inline = 6.getDelegateOrInline(genericType, strategy);
            if (inline != null) {
                return RuntimeCollectionFieldFactory.createCollectionInlineV(number, name, f, messageFactory, inline);
            }
            if (Message.class.isAssignableFrom(genericType)) {
                return RuntimeCollectionFieldFactory.createCollectionPojoV(number, name, f, messageFactory, genericType, strategy);
            }
            if (genericType.isEnum()) {
                return RuntimeCollectionFieldFactory.createCollectionEnumV(number, name, f, messageFactory, genericType, strategy);
            }
            PolymorphicSchema ps = PolymorphicSchemaFactories.getSchemaFromCollectionOrMapGenericType(genericType, strategy);
            if (ps != null) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, ps, ps.getPipeSchema(), strategy);
            }
            if (6.pojo(genericType, f.getAnnotation(Morph.class), strategy)) {
                return RuntimeCollectionFieldFactory.createCollectionPojoV(number, name, f, messageFactory, genericType, strategy);
            }
            if (genericType.isInterface()) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, strategy.OBJECT_ELEMENT_SCHEMA, strategy.OBJECT_ELEMENT_SCHEMA.pipeSchema, strategy);
            }
            return RuntimeCollectionFieldFactory.createCollectionPolymorphicV(number, name, f, messageFactory, genericType, strategy);
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<?> readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Collection<?> value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };

    private RuntimeCollectionFieldFactory() {
    }

    static RuntimeFieldFactory<Collection<?>> getFactory() {
        return COLLECTION;
    }

    private static <T> MappedSchema.Field<T> createCollectionInlineV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, final Delegate<Object> inline) {
        return new RuntimeCollectionField<T, Object>(inline.getFieldType(), number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Collection)f.get(message), this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, existing, this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, pipe, this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                collection.add(inline.readFrom(input));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                inline.writeTo(output, fieldNumber, value, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                inline.transfer(pipe, input, output, number, repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionEnumV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, IdStrategy strategy) {
        final EnumIO<? extends Enum<?>> eio = strategy.getEnumIO(genericType);
        return new RuntimeCollectionField<T, Enum<?>>(WireFormat.FieldType.ENUM, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Collection)f.get(message), this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, existing, this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, pipe, this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Enum<?>> collection) throws IOException {
                collection.add((Enum<?>)eio.readFrom(input));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Enum<?> value, boolean repeated) throws IOException {
                EnumIO.writeTo(output, fieldNumber, repeated, value);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                EnumIO.transfer(pipe, input, output, number, repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionPojoV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, IdStrategy strategy) {
        final HasSchema<Object> schemaV = strategy.getSchemaWrapper(genericType, true);
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Collection)f.get(message), this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, existing, this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, pipe, this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                collection.add(input.mergeObject(null, schemaV.getSchema()));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, schemaV.getSchema(), repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, pipe, schemaV.getPipeSchema(), repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionPolymorphicV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, final IdStrategy strategy) {
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Collection)f.get(message), this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, existing, this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, pipe, this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                Object value = input.mergeObject(collection, strategy.POLYMORPHIC_POJO_ELEMENT_SCHEMA);
                if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                    collection.add(value);
                }
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, strategy.POLYMORPHIC_POJO_ELEMENT_SCHEMA, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_POJO_ELEMENT_SCHEMA.pipeSchema, repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionObjectV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, final Schema<Object> valueSchema, final Pipe.Schema<Object> valuePipeSchema, IdStrategy strategy) {
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Collection)f.get(message), this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, existing, this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, pipe, this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                Collection<Object> value = input.mergeObject(collection, valueSchema);
                if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                    collection.add(value);
                }
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, valueSchema, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, pipe, valuePipeSchema, repeated);
            }
        };
    }
}

