/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.bedrock.backends;

import com.anthropic.backends.Backend;
import com.anthropic.core.Check;
import com.anthropic.core.ObjectMappers;
import com.anthropic.core.http.Headers;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpRequestBodies;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.errors.AnthropicException;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.eventstream.Message;
import software.amazon.eventstream.MessageDecoder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/anthropic/bedrock/backends/BedrockBackend;", "Lcom/anthropic/backends/Backend;", "awsCredentialsProvider", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "region", "Lsoftware/amazon/awssdk/regions/Region;", "(Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;Lsoftware/amazon/awssdk/regions/Region;)V", "awsCredentials", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentials;", "()Lsoftware/amazon/awssdk/auth/credentials/AwsCredentials;", "()Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "()Lsoftware/amazon/awssdk/regions/Region;", "sseThreadPool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "authorizeRequest", "Lcom/anthropic/core/http/HttpRequest;", "request", "baseUrl", "", "close", "", "prepareRequest", "prepareResponse", "Lcom/anthropic/core/http/HttpResponse;", "response", "Builder", "Companion", "anthropic-java-bedrock"})
@SourceDebugExtension(value={"SMAP\nBedrockBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockBackend.kt\ncom/anthropic/bedrock/backends/BedrockBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 HttpRequestBodies.kt\ncom/anthropic/core/http/HttpRequestBodies\n*L\n1#1,426:1\n1#2:427\n1360#3:428\n1446#3,5:429\n1855#3:436\n1855#3,2:437\n1856#3:439\n34#4:434\n46#4:435\n*S KotlinDebug\n*F\n+ 1 BedrockBackend.kt\ncom/anthropic/bedrock/backends/BedrockBackend\n*L\n170#1:428\n170#1:429,5\n217#1:436\n218#1:437,2\n217#1:439\n188#1:434\n188#1:435\n*E\n"})
public final class BedrockBackend
implements Backend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AwsCredentialsProvider awsCredentialsProvider;
    @NotNull
    private final Region region;
    @NotNull
    private final JsonMapper jsonMapper;
    private final ExecutorService sseThreadPool;
    @NotNull
    private static final String ANTHROPIC_VERSION = "bedrock-2023-05-31";
    @NotNull
    private static final String SERVICE_NAME = "bedrock-runtime";
    @NotNull
    private static final String HEADER_ANTHROPIC_BETA = "anthropic-beta";
    @NotNull
    private static final String HEADER_CONTENT_TYPE = "content-type";
    @NotNull
    private static final String CONTENT_TYPE_JSON = "application/json";
    @NotNull
    private static final String HEADER_PAYLOAD_CONTENT_TYPE = "x-amzn-bedrock-content-type";
    @NotNull
    private static final String CONTENT_TYPE_AWS_EVENT_STREAM = "application/vnd.amazon.eventstream";
    @NotNull
    private static final String CONTENT_TYPE_SSE_STREAM = "text/event-stream; charset=utf-8";

    private BedrockBackend(AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.region = region;
        this.jsonMapper = ObjectMappers.jsonMapper();
        this.sseThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            private final ThreadFactory threadFactory;
            @NotNull
            private final AtomicLong count;
            {
                this.threadFactory = Executors.defaultThreadFactory();
                this.count = new AtomicLong(0L);
            }

            @NotNull
            public Thread newThread(@NotNull Runnable runnable) {
                Thread thread;
                Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                Thread $this$newThread_u24lambda_u240 = thread = this.threadFactory.newThread(runnable);
                boolean bl = false;
                $this$newThread_u24lambda_u240.setName("bedrock-sse-pipeline-" + this.count.getAndIncrement());
                Thread thread2 = thread;
                Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"threadFactory.newThread(\u2026)}\"\n                    }");
                return thread2;
            }
        });
    }

    @JvmName(name="awsCredentialsProvider")
    @NotNull
    public final AwsCredentialsProvider awsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    @JvmName(name="region")
    @NotNull
    public final Region region() {
        return this.region;
    }

    @JvmName(name="awsCredentials")
    @NotNull
    public final AwsCredentials awsCredentials() {
        AwsCredentials awsCredentials = this.awsCredentialsProvider.resolveCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)awsCredentials, (String)"awsCredentialsProvider.resolveCredentials()");
        return awsCredentials;
    }

    @NotNull
    public String baseUrl() {
        return "https://bedrock-runtime." + this.region + ".amazonaws.com";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HttpRequest prepareRequest(@NotNull HttpRequest request) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List pathSegments = request.pathSegments();
        if (pathSegments.isEmpty()) {
            throw new AnthropicInvalidDataException("Request missing all path segments.", null, 2, null);
        }
        if (!(!Intrinsics.areEqual(pathSegments.get(0), (Object)"model"))) {
            boolean $i$a$-require-BedrockBackend$prepareRequest$22 = false;
            String $i$a$-require-BedrockBackend$prepareRequest$22 = "Request already prepared for Bedrock.";
            throw new IllegalArgumentException($i$a$-require-BedrockBackend$prepareRequest$22.toString());
        }
        if (!Intrinsics.areEqual(pathSegments.get(0), (Object)"v1")) {
            throw new AnthropicInvalidDataException("Expected first 'v1' path segment.", null, 2, null);
        }
        if (pathSegments.size() <= 1) {
            throw new AnthropicInvalidDataException("Missing service name from request URL.", null, 2, null);
        }
        String string = (String)pathSegments.get(1);
        if (Intrinsics.areEqual((Object)string, (Object)"messages")) {
            if (pathSegments.size() > 2) {
                String $i$a$-require-BedrockBackend$prepareRequest$22 = (String)pathSegments.get(2);
                if (Intrinsics.areEqual((Object)$i$a$-require-BedrockBackend$prepareRequest$22, (Object)"batches")) {
                    throw new AnthropicException("Batch API is not supported for Bedrock.", null, 2, null);
                }
                if (Intrinsics.areEqual((Object)$i$a$-require-BedrockBackend$prepareRequest$22, (Object)"count_tokens")) {
                    throw new AnthropicException("Token counting is not supported for Bedrock.", null, 2, null);
                }
            }
        } else if (!Intrinsics.areEqual((Object)string, (Object)"complete")) {
            throw new AnthropicException("Service is not supported for Bedrock: " + (String)pathSegments.get(1) + '.', null, 2, null);
        }
        ObjectNode objectNode = HttpRequestBodies.bodyToJson((ObjectMapper)((ObjectMapper)this.jsonMapper), (HttpRequestBody)request.body());
        if (objectNode == null) {
            throw new AnthropicInvalidDataException("Request has no body", null, 2, null);
        }
        ObjectNode jsonBody = objectNode;
        jsonBody.put("anthropic_version", ANTHROPIC_VERSION);
        Iterable $this$flatMap$iv = request.headers().values(HEADER_ANTHROPIC_BETA);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        String[] destination$iv$iv = (String[])new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List betaVersions = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        if (!((Collection)betaVersions).isEmpty()) {
            jsonBody.replace("anthropic_beta", this.jsonMapper.valueToTree((Object)betaVersions));
        }
        if (($i$f$flatMap = jsonBody.remove("model")) == null) {
            throw new AnthropicInvalidDataException("No model found in body.", null, 2, null);
        }
        JsonNode model = $i$f$flatMap;
        String modelId = model.asText();
        JsonNode jsonNode = jsonBody.remove("stream");
        boolean isStream = jsonNode != null ? jsonNode.asBoolean() : false;
        HttpRequest.Builder builder = request.toBuilder();
        destination$iv$iv = new String[2];
        destination$iv$iv[0] = "model";
        Intrinsics.checkNotNullExpressionValue((Object)modelId, (String)"modelId");
        destination$iv$iv[1] = modelId;
        JsonMapper jsonMapper$iv = this.jsonMapper;
        boolean $i$f$json = false;
        return builder.replaceAllPathSegments(destination$iv$iv).addPathSegment(isStream ? "invoke-with-response-stream" : "invoke").body(new HttpRequestBody(jsonMapper$iv, jsonBody){
            @NotNull
            private final Lazy bytes$delegate;
            {
                this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ Object $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                        super(0);
                    }

                    public final byte[] invoke() {
                        return this.$jsonMapper.writeValueAsBytes(this.$value);
                    }
                }));
            }

            private final byte[] getBytes() {
                Object object = this.bytes$delegate.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-bytes>(...)");
                return (byte[])object;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.getBytes());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.getBytes().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
    }

    @NotNull
    public HttpRequest authorizeRequest(@NotNull HttpRequest request) {
        SdkHttpRequest.Builder $i$a$-require-BedrockBackend$authorizeRequest$222;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(!request.headers().names().contains("Authorization"))) {
            boolean $i$a$-require-BedrockBackend$authorizeRequest$222 = false;
            String $i$a$-require-BedrockBackend$authorizeRequest$222 = "Request already authorized for Bedrock.";
            throw new IllegalArgumentException($i$a$-require-BedrockBackend$authorizeRequest$222.toString());
        }
        SdkHttpRequest.Builder $this$authorizeRequest_u24lambda_u245 = $i$a$-require-BedrockBackend$authorizeRequest$222 = SdkHttpRequest.builder().uri(request.url()).method(SdkHttpMethod.fromValue((String)request.method().toString()));
        boolean bl = false;
        if (request.headers().values(HEADER_CONTENT_TYPE).isEmpty()) {
            HttpRequestBody httpRequestBody = request.body();
            if ((httpRequestBody != null ? httpRequestBody.contentType() : null) != null) {
                HttpRequestBody httpRequestBody2 = request.body();
                Intrinsics.checkNotNull((Object)httpRequestBody2);
                $this$authorizeRequest_u24lambda_u245.appendHeader(HEADER_CONTENT_TYPE, httpRequestBody2.contentType());
            } else {
                throw new AnthropicInvalidDataException("No content type in request headers or body.", null, 2, null);
            }
        }
        Iterable $this$forEach$iv = request.headers().names();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = request.headers().values(name);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String value = (String)element$iv2;
                boolean bl3 = false;
                $this$authorizeRequest_u24lambda_u245.appendHeader(name, value);
            }
        }
        SdkHttpRequest awsSignRequest = (SdkHttpRequest)$i$a$-require-BedrockBackend$authorizeRequest$222.build();
        ByteArrayOutputStream bodyData = new ByteArrayOutputStream();
        HttpRequestBody httpRequestBody = request.body();
        if (httpRequestBody != null) {
            httpRequestBody.writeTo((OutputStream)bodyData);
        }
        SdkHttpRequest sdkHttpRequest = AwsV4HttpSigner.create().sign(arg_0 -> BedrockBackend.authorizeRequest$lambda$6(this, awsSignRequest, bodyData, arg_0)).request();
        Intrinsics.checkNotNullExpressionValue((Object)sdkHttpRequest, (String)"create()\n               \u2026               .request()");
        SdkHttpRequest awsSignedRequest = sdkHttpRequest;
        HttpRequest.Builder builder = request.toBuilder();
        Map map = awsSignedRequest.headers();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"awsSignedRequest.headers()");
        return builder.replaceAllHeaders(map).build();
    }

    @NotNull
    public HttpResponse prepareResponse(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!response.headers().values(HEADER_CONTENT_TYPE).contains(CONTENT_TYPE_AWS_EVENT_STREAM)) {
            return response;
        }
        List payloadContentType = response.headers().values(HEADER_PAYLOAD_CONTENT_TYPE);
        if (!payloadContentType.contains(CONTENT_TYPE_JSON)) {
            throw new AnthropicInvalidDataException("Expected streamed Bedrock events to have content type of application/json, but was " + payloadContentType + '.', null, 2, null);
        }
        InputStream responseInput = response.body();
        PipedInputStream pipedInput = new PipedInputStream();
        PipedOutputStream pipedOutput = new PipedOutputStream(pipedInput);
        this.sseThreadPool.execute(() -> BedrockBackend.prepareResponse$lambda$11(responseInput, pipedOutput, this));
        return new HttpResponse(response, pipedInput){
            final /* synthetic */ HttpResponse $response;
            final /* synthetic */ PipedInputStream $pipedInput;
            {
                this.$response = $response;
                this.$pipedInput = $pipedInput;
            }

            public int statusCode() {
                return this.$response.statusCode();
            }

            @NotNull
            public Headers headers() {
                return this.$response.headers().toBuilder().replace("content-type", "text/event-stream; charset=utf-8").build();
            }

            @NotNull
            public InputStream body() {
                return this.$pipedInput;
            }

            public void close() {
                this.$pipedInput.close();
            }
        };
    }

    public void close() {
        this.sseThreadPool.shutdown();
    }

    private static final void authorizeRequest$lambda$6(BedrockBackend this$0, SdkHttpRequest $awsSignRequest, ByteArrayOutputStream $bodyData, SignRequest.Builder r) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bodyData, (String)"$bodyData");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)r.identity((Identity)this$0.awsCredentials())).request($awsSignRequest)).payload((Object)ContentStreamProvider.fromByteArray((byte[])$bodyData.toByteArray()))).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"bedrock")).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this$0.region.id());
    }

    private static final void prepareResponse$lambda$11$lambda$10$lambda$9$lambda$7(BedrockBackend this$0, PipedOutputStream $output, Message message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
        byte[] byArray = Base64.getDecoder().decode(this$0.jsonMapper.readTree(message.getPayload()).get("bytes").asText());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder()\n           \u2026                        )");
        byte[] byArray2 = byArray;
        String sseJson = new String(byArray2, Charsets.UTF_8);
        String sseEventType = this$0.jsonMapper.readTree(sseJson).get("type").asText();
        String string = "event: " + sseEventType + "\ndata: " + sseJson + "\n\n";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
        $output.write(byArray3);
        $output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void prepareResponse$lambda$11(InputStream $responseInput, PipedOutputStream $pipedOutput, BedrockBackend this$0) {
        Intrinsics.checkNotNullParameter((Object)$responseInput, (String)"$responseInput");
        Intrinsics.checkNotNullParameter((Object)$pipedOutput, (String)"$pipedOutput");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Closeable closeable = $responseInput;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = $pipedOutput;
            Throwable throwable2 = null;
            try {
                PipedOutputStream output = (PipedOutputStream)closeable2;
                boolean bl2 = false;
                MessageDecoder messageDecoder = new MessageDecoder(arg_0 -> BedrockBackend.prepareResponse$lambda$11$lambda$10$lambda$9$lambda$7(this$0, output, arg_0));
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while (true) {
                    int n;
                    int it = n = input.read(buffer);
                    boolean bl3 = false;
                    bytesRead = it;
                    if (n == -1) break;
                    messageDecoder.feed(buffer, 0, bytesRead);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final BedrockBackend fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ BedrockBackend(AwsCredentialsProvider awsCredentialsProvider, Region region, DefaultConstructorMarker $constructor_marker) {
        this(awsCredentialsProvider, region);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/anthropic/bedrock/backends/BedrockBackend$Builder;", "", "()V", "awsCredentialsProvider", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "region", "Lsoftware/amazon/awssdk/regions/Region;", "awsCredentials", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentials;", "build", "Lcom/anthropic/bedrock/backends/BedrockBackend;", "fromEnv", "anthropic-java-bedrock"})
    @SourceDebugExtension(value={"SMAP\nBedrockBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockBackend.kt\ncom/anthropic/bedrock/backends/BedrockBackend$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1#2:427\n*E\n"})
    public static final class Builder {
        @Nullable
        private AwsCredentialsProvider awsCredentialsProvider;
        @Nullable
        private Region region;

        @JvmOverloads
        @NotNull
        public final Builder fromEnv(@NotNull AwsCredentialsProvider awsCredentialsProvider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
            Builder $this$fromEnv_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$fromEnv_u24lambda_u240.awsCredentialsProvider(awsCredentialsProvider);
            try {
                awsCredentialsProvider.resolveCredentials();
            }
            catch (Exception e) {
                throw new IllegalStateException("No AWS access key ID or AWS secret access key found.", e);
            }
            try {
                $this$fromEnv_u24lambda_u240.region = DefaultAwsRegionProviderChain.builder().build().getRegion();
            }
            catch (Exception e) {
                throw new IllegalStateException("No AWS region found.", e);
            }
            return builder;
        }

        public static /* synthetic */ Builder fromEnv$default(Builder builder, AwsCredentialsProvider awsCredentialsProvider, int n, Object object) {
            if ((n & 1) != 0) {
                DefaultCredentialsProvider defaultCredentialsProvider = DefaultCredentialsProvider.create();
                Intrinsics.checkNotNullExpressionValue((Object)defaultCredentialsProvider, (String)"create()");
                awsCredentialsProvider = (AwsCredentialsProvider)defaultCredentialsProvider;
            }
            return builder.fromEnv(awsCredentialsProvider);
        }

        @NotNull
        public final Builder awsCredentialsProvider(@NotNull AwsCredentialsProvider awsCredentialsProvider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
            Builder $this$awsCredentialsProvider_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$awsCredentialsProvider_u24lambda_u241.awsCredentialsProvider = awsCredentialsProvider;
            return builder;
        }

        @NotNull
        public final Builder awsCredentials(@NotNull AwsCredentials awsCredentials) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)awsCredentials, (String)"awsCredentials");
            Builder $this$awsCredentials_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$awsCredentials_u24lambda_u242.awsCredentialsProvider = Companion.providerOf$anthropic_java_bedrock(awsCredentials);
            return builder;
        }

        @NotNull
        public final Builder region(@NotNull Region region) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Builder $this$region_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$region_u24lambda_u243.region = region;
            return builder;
        }

        @NotNull
        public final BedrockBackend build() {
            return new BedrockBackend((AwsCredentialsProvider)Check.checkRequired((String)"awsCredentialsProvider", (Object)this.awsCredentialsProvider), (Region)Check.checkRequired((String)"region", (Object)this.region), null);
        }

        @JvmOverloads
        @NotNull
        public final Builder fromEnv() {
            return Builder.fromEnv$default(this, null, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/bedrock/backends/BedrockBackend$Companion;", "", "()V", "ANTHROPIC_VERSION", "", "CONTENT_TYPE_AWS_EVENT_STREAM", "CONTENT_TYPE_JSON", "CONTENT_TYPE_SSE_STREAM", "HEADER_ANTHROPIC_BETA", "HEADER_CONTENT_TYPE", "HEADER_PAYLOAD_CONTENT_TYPE", "SERVICE_NAME", "builder", "Lcom/anthropic/bedrock/backends/BedrockBackend$Builder;", "fromEnv", "Lcom/anthropic/bedrock/backends/BedrockBackend;", "providerOf", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "awsCredentials", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentials;", "providerOf$anthropic_java_bedrock", "anthropic-java-bedrock"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final BedrockBackend fromEnv() {
            return Builder.fromEnv$default(this.builder(), null, 1, null).build();
        }

        public final /* synthetic */ AwsCredentialsProvider providerOf$anthropic_java_bedrock(AwsCredentials awsCredentials) {
            Intrinsics.checkNotNullParameter((Object)awsCredentials, (String)"awsCredentials");
            return new AwsCredentialsProvider(awsCredentials){
                final /* synthetic */ AwsCredentials $awsCredentials;
                {
                    this.$awsCredentials = $awsCredentials;
                }

                @NotNull
                public AwsCredentials resolveCredentials() {
                    return this.$awsCredentials;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

