/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.client.okhttp;

import com.anthropic.backends.Backend;
import com.anthropic.core.Check;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.Timeout;
import com.anthropic.core.http.Headers;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.errors.AnthropicIoException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u000bH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u000bH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002J\f\u0010\"\u001a\u00020\t*\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/anthropic/client/okhttp/OkHttpClient;", "Lcom/anthropic/core/http/HttpClient;", "okHttpClient", "Lokhttp3/OkHttpClient;", "backend", "Lcom/anthropic/backends/Backend;", "<init>", "(Lokhttp3/OkHttpClient;Lcom/anthropic/backends/Backend;)V", "execute", "Lcom/anthropic/core/http/HttpResponse;", "request", "Lcom/anthropic/core/http/HttpRequest;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "executeAsync", "Ljava/util/concurrent/CompletableFuture;", "close", "", "prepareRequest", "newCall", "Lokhttp3/Call;", "toRequest", "Lokhttp3/Request;", "client", "requiresBody", "", "method", "Lcom/anthropic/core/http/HttpMethod;", "resolveUrl", "toUrl", "", "toRequestBody", "Lokhttp3/RequestBody;", "Lcom/anthropic/core/http/HttpRequestBody;", "toResponse", "Lokhttp3/Response;", "toHeaders", "Lcom/anthropic/core/http/Headers;", "Lokhttp3/Headers;", "Companion", "Builder", "anthropic-java-client-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClient.kt\ncom/anthropic/client/okhttp/OkHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1#2:242\n1863#3:243\n1863#3,2:244\n1864#3:246\n1863#3,2:247\n1863#3:249\n1863#3,2:250\n1864#3:252\n1863#3,2:253\n*S KotlinDebug\n*F\n+ 1 OkHttpClient.kt\ncom/anthropic/client/okhttp/OkHttpClient\n*L\n124#1:243\n125#1:244,2\n124#1:246\n166#1:247,2\n167#1:249\n168#1:250,2\n167#1:252\n205#1:253,2\n*E\n"})
public final class OkHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final okhttp3.OkHttpClient okHttpClient;
    @NotNull
    private final Backend backend;

    private OkHttpClient(okhttp3.OkHttpClient okHttpClient, Backend backend) {
        this.okHttpClient = okHttpClient;
        this.backend = backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request, @NotNull RequestOptions requestOptions) {
        HttpResponse httpResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        HttpRequest preparedRequest = this.prepareRequest(request);
        Call call = this.newCall(preparedRequest, requestOptions);
        try {
            httpResponse = this.backend.prepareResponse(this.toResponse(call.execute()));
        }
        catch (IOException e) {
            throw new AnthropicIoException("Request failed", (Throwable)e);
        }
        finally {
            HttpRequestBody httpRequestBody = preparedRequest.body();
            if (httpRequestBody != null) {
                httpRequestBody.close();
            }
        }
        return httpResponse;
    }

    @NotNull
    public CompletableFuture<HttpResponse> executeAsync(@NotNull HttpRequest request, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        HttpRequest preparedRequest = this.prepareRequest(request);
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        HttpRequestBody httpRequestBody = preparedRequest.body();
        if (httpRequestBody != null) {
            HttpRequestBody $this$executeAsync_u24lambda_u242 = httpRequestBody;
            boolean bl = false;
            future.whenComplete((arg_0, arg_1) -> OkHttpClient.executeAsync$lambda$2$lambda$1((arg_0, arg_1) -> OkHttpClient.executeAsync$lambda$2$lambda$0($this$executeAsync_u24lambda_u242, arg_0, arg_1), arg_0, arg_1));
        }
        this.newCall(preparedRequest, requestOptions).enqueue(new Callback(future, this){
            final /* synthetic */ CompletableFuture<HttpResponse> $future;
            final /* synthetic */ OkHttpClient this$0;
            {
                this.$future = $future;
                this.this$0 = $receiver;
            }

            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(OkHttpClient.access$getBackend$p(this.this$0).prepareResponse(OkHttpClient.access$toResponse(this.this$0, response)));
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally((Throwable)new AnthropicIoException("Request failed", (Throwable)e));
            }
        });
        return future;
    }

    public void close() {
        block0: {
            this.backend.close();
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
            Cache cache = this.okHttpClient.cache();
            if (cache == null) break block0;
            cache.close();
        }
    }

    private final HttpRequest prepareRequest(HttpRequest request) {
        HttpRequest preparedRequest = this.backend.prepareRequest(request);
        HttpRequest resolvedRequest = this.resolveUrl(preparedRequest);
        HttpRequest authorizedRequest = this.backend.authorizeRequest(resolvedRequest);
        return authorizedRequest;
    }

    /*
     * WARNING - void declaration
     */
    private final Call newCall(HttpRequest request, RequestOptions requestOptions) {
        HttpLoggingInterceptor.Level logLevel;
        String string;
        String string2;
        OkHttpClient.Builder clientBuilder = this.okHttpClient.newBuilder();
        String string3 = System.getenv("ANTHROPIC_LOG");
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = string = null;
        }
        Object object = Intrinsics.areEqual((Object)string, (Object)"info") ? HttpLoggingInterceptor.Level.BASIC : (logLevel = Intrinsics.areEqual((Object)string, (Object)"debug") ? HttpLoggingInterceptor.Level.BODY : null);
        if (logLevel != null) {
            void $this$newCall_u24lambda_u243;
            String string5 = string = new HttpLoggingInterceptor(null, 1, null).setLevel(logLevel);
            OkHttpClient.Builder builder = clientBuilder;
            boolean bl = false;
            $this$newCall_u24lambda_u243.redactHeader("X-Api-Key");
            $this$newCall_u24lambda_u243.redactHeader("Authorization");
            builder.addNetworkInterceptor((Interceptor)string);
        }
        Timeout timeout = requestOptions.getTimeout();
        if (timeout != null) {
            Timeout it = timeout;
            boolean bl = false;
            clientBuilder.connectTimeout(it.connect()).readTimeout(it.read()).writeTimeout(it.write()).callTimeout(it.request());
        }
        okhttp3.OkHttpClient client = clientBuilder.build();
        return client.newCall(this.toRequest(request, client));
    }

    private final Request toRequest(HttpRequest $this$toRequest, okhttp3.OkHttpClient client) {
        RequestBody body;
        HttpRequestBody httpRequestBody = $this$toRequest.body();
        RequestBody requestBody = body = httpRequestBody != null ? this.toRequestBody(httpRequestBody) : null;
        if (body == null && this.requiresBody($this$toRequest.method())) {
            body = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)"", null, (int)1, null);
        }
        Request.Builder builder = new Request.Builder();
        String string = $this$toRequest.url();
        if (string == null) {
            string = "";
        }
        Request.Builder builder2 = builder.url(string).method($this$toRequest.method().name(), body);
        Iterable $this$forEach$iv = $this$toRequest.headers().names();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $this$toRequest.headers().values(name);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                builder2.header(name, it);
            }
        }
        if (!$this$toRequest.headers().names().contains("X-Stainless-Read-Timeout") && client.readTimeoutMillis() != 0) {
            builder2.header("X-Stainless-Read-Timeout", String.valueOf(Duration.ofMillis(client.readTimeoutMillis()).getSeconds()));
        }
        if (!$this$toRequest.headers().names().contains("X-Stainless-Timeout") && client.callTimeoutMillis() != 0) {
            builder2.header("X-Stainless-Timeout", String.valueOf(Duration.ofMillis(client.callTimeoutMillis()).getSeconds()));
        }
        return builder2.build();
    }

    private final boolean requiresBody(HttpMethod method) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final HttpRequest resolveUrl(HttpRequest $this$resolveUrl) {
        return $this$resolveUrl.toBuilder().url(this.toUrl($this$resolveUrl)).build();
    }

    private final String toUrl(HttpRequest $this$toUrl) {
        String string = $this$toUrl.url();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        HttpUrl.Builder builder = HttpUrl.Companion.get(this.backend.baseUrl()).newBuilder();
        Iterable $this$forEach$iv = $this$toUrl.pathSegments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            builder.addPathSegment(p0);
        }
        $this$forEach$iv = $this$toUrl.queryParams().keys();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $this$toUrl.queryParams().values(key);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                builder.addQueryParameter(key, it);
            }
        }
        return builder.toString();
    }

    private final RequestBody toRequestBody(HttpRequestBody $this$toRequestBody) {
        String string = $this$toRequestBody.contentType();
        MediaType mediaType = string != null ? MediaType.Companion.get(string) : null;
        long length = $this$toRequestBody.contentLength();
        return new RequestBody(mediaType, length, $this$toRequestBody){
            final /* synthetic */ MediaType $mediaType;
            final /* synthetic */ long $length;
            final /* synthetic */ HttpRequestBody $this_toRequestBody;
            {
                this.$mediaType = $mediaType;
                this.$length = $length;
                this.$this_toRequestBody = $receiver;
            }

            public MediaType contentType() {
                return this.$mediaType;
            }

            public long contentLength() {
                return this.$length;
            }

            public boolean isOneShot() {
                return !this.$this_toRequestBody.repeatable();
            }

            public void writeTo(BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                this.$this_toRequestBody.writeTo(sink.outputStream());
            }
        };
    }

    private final HttpResponse toResponse(Response $this$toResponse) {
        Headers headers = this.toHeaders($this$toResponse.headers());
        return new HttpResponse($this$toResponse, headers){
            final /* synthetic */ Response $this_toResponse;
            final /* synthetic */ Headers $headers;
            {
                this.$this_toResponse = $receiver;
                this.$headers = $headers;
            }

            public int statusCode() {
                return this.$this_toResponse.code();
            }

            public Headers headers() {
                return this.$headers;
            }

            public InputStream body() {
                ResponseBody responseBody = this.$this_toResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                return responseBody.byteStream();
            }

            public void close() {
                ResponseBody responseBody = this.$this_toResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
            }
        };
    }

    private final Headers toHeaders(okhttp3.Headers $this$toHeaders) {
        Headers.Builder headersBuilder = Headers.Companion.builder();
        Iterable $this$forEach$iv = (Iterable)$this$toHeaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            headersBuilder.put(name, value);
        }
        return headersBuilder.build();
    }

    private static final Unit executeAsync$lambda$2$lambda$0(HttpRequestBody $this_run, HttpResponse httpResponse, Throwable throwable) {
        $this_run.close();
        return Unit.INSTANCE;
    }

    private static final void executeAsync$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public static final /* synthetic */ Backend access$getBackend$p(OkHttpClient $this) {
        return $this.backend;
    }

    public static final /* synthetic */ HttpResponse access$toResponse(OkHttpClient $this, Response $receiver) {
        return $this.toResponse($receiver);
    }

    public /* synthetic */ OkHttpClient(okhttp3.OkHttpClient okHttpClient, Backend backend, DefaultConstructorMarker $constructor_marker) {
        this(okHttpClient, backend);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\nJ\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/anthropic/client/okhttp/OkHttpClient$Builder;", "", "<init>", "()V", "timeout", "Lcom/anthropic/core/Timeout;", "proxy", "Ljava/net/Proxy;", "backend", "Lcom/anthropic/backends/Backend;", "Ljava/time/Duration;", "build", "Lcom/anthropic/client/okhttp/OkHttpClient;", "anthropic-java-client-okhttp"})
    @SourceDebugExtension(value={"SMAP\nOkHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClient.kt\ncom/anthropic/client/okhttp/OkHttpClient$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
    public static final class Builder {
        @NotNull
        private Timeout timeout = Timeout.Companion.default();
        @Nullable
        private Proxy proxy;
        @Nullable
        private Backend backend;

        @NotNull
        public final Builder timeout(@NotNull Timeout timeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            Builder $this$timeout_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$timeout_u24lambda_u240.timeout = timeout;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Duration timeout) {
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            return this.timeout(Timeout.Companion.builder().request(timeout).build());
        }

        @NotNull
        public final Builder proxy(@Nullable Proxy proxy) {
            Builder builder;
            Builder $this$proxy_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$proxy_u24lambda_u241.proxy = proxy;
            return builder;
        }

        @NotNull
        public final Builder backend(@NotNull Backend backend) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
            Builder $this$backend_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$backend_u24lambda_u242.backend = backend;
            return builder;
        }

        @NotNull
        public final OkHttpClient build() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            Duration duration = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
            return new OkHttpClient(builder.pingInterval(duration).connectTimeout(this.timeout.connect()).readTimeout(this.timeout.read()).writeTimeout(this.timeout.write()).callTimeout(this.timeout.request()).proxy(this.proxy).build(), (Backend)Check.checkRequired((String)"backend", (Object)this.backend), null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/anthropic/client/okhttp/OkHttpClient$Companion;", "", "<init>", "()V", "builder", "Lcom/anthropic/client/okhttp/OkHttpClient$Builder;", "anthropic-java-client-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

