/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.Check;
import com.anthropic.core.ExcludeMissing;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonMissing;
import com.anthropic.core.NoAutoDetect;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.Base64PdfSource;
import com.anthropic.models.CacheControlEphemeral;
import com.anthropic.models.CitationsConfigParam;
import com.anthropic.models.ContentBlockSource;
import com.anthropic.models.DocumentBlockParam;
import com.anthropic.models.PlainTextSource;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NoAutoDetect
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 )2\u00020\u0001:\u0004()*+B}\b\u0003\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0003\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u000e\b\u0003\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u0014\b\u0003\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0007J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0007J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0!J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0!J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0!J\u0013\u0010\"\u001a\u00020\u00192\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0002\u001a\u00020\u0004J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0!J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\fH\u0016J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/anthropic/models/DocumentBlockParam;", "", "source", "Lcom/anthropic/core/JsonField;", "Lcom/anthropic/models/DocumentBlockParam$Source;", "type", "Lcom/anthropic/models/DocumentBlockParam$Type;", "cacheControl", "Lcom/anthropic/models/CacheControlEphemeral;", "citations", "Lcom/anthropic/models/CitationsConfigParam;", "context", "", "title", "additionalProperties", "", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonField;Lcom/anthropic/core/JsonField;Lcom/anthropic/core/JsonField;Lcom/anthropic/core/JsonField;Lcom/anthropic/core/JsonField;Lcom/anthropic/core/JsonField;Ljava/util/Map;)V", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "validated", "", "_additionalProperties", "_cacheControl", "_citations", "_context", "_source", "_title", "_type", "Ljava/util/Optional;", "equals", "other", "toBuilder", "Lcom/anthropic/models/DocumentBlockParam$Builder;", "toString", "validate", "Builder", "Companion", "Source", "Type", "anthropic-java-core"})
public final class DocumentBlockParam {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonField<Source> source;
    @NotNull
    private final JsonField<Type> type;
    @NotNull
    private final JsonField<CacheControlEphemeral> cacheControl;
    @NotNull
    private final JsonField<CitationsConfigParam> citations;
    @NotNull
    private final JsonField<String> context;
    @NotNull
    private final JsonField<String> title;
    @NotNull
    private final Map<String, com.anthropic.core.JsonValue> additionalProperties;
    private boolean validated;
    @NotNull
    private final Lazy hashCode$delegate;

    @JsonCreator
    private DocumentBlockParam(@JsonProperty(value="source") @ExcludeMissing JsonField<Source> source, @JsonProperty(value="type") @ExcludeMissing JsonField<Type> type, @JsonProperty(value="cache_control") @ExcludeMissing JsonField<CacheControlEphemeral> cacheControl, @JsonProperty(value="citations") @ExcludeMissing JsonField<CitationsConfigParam> citations2, @JsonProperty(value="context") @ExcludeMissing JsonField<String> context, @JsonProperty(value="title") @ExcludeMissing JsonField<String> title, @JsonAnySetter Map<String, ? extends com.anthropic.core.JsonValue> additionalProperties) {
        this.source = source;
        this.type = type;
        this.cacheControl = cacheControl;
        this.citations = citations2;
        this.context = context;
        this.title = title;
        this.additionalProperties = additionalProperties;
        this.hashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DocumentBlockParam this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                Object[] objectArray = new Object[]{DocumentBlockParam.access$getSource$p(this.this$0), DocumentBlockParam.access$getType$p(this.this$0), DocumentBlockParam.access$getCacheControl$p(this.this$0), DocumentBlockParam.access$getCitations$p(this.this$0), DocumentBlockParam.access$getContext$p(this.this$0), DocumentBlockParam.access$getTitle$p(this.this$0), DocumentBlockParam.access$getAdditionalProperties$p(this.this$0)};
                return Objects.hash(objectArray);
            }
        }));
    }

    /* synthetic */ DocumentBlockParam(JsonField jsonField, JsonField jsonField2, JsonField jsonField3, JsonField jsonField4, JsonField jsonField5, JsonField jsonField6, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jsonField = JsonMissing.Companion.of();
        }
        if ((n & 2) != 0) {
            jsonField2 = JsonMissing.Companion.of();
        }
        if ((n & 4) != 0) {
            jsonField3 = JsonMissing.Companion.of();
        }
        if ((n & 8) != 0) {
            jsonField4 = JsonMissing.Companion.of();
        }
        if ((n & 0x10) != 0) {
            jsonField5 = JsonMissing.Companion.of();
        }
        if ((n & 0x20) != 0) {
            jsonField6 = JsonMissing.Companion.of();
        }
        if ((n & 0x40) != 0) {
            map2 = Utils.immutableEmptyMap();
        }
        this(jsonField, jsonField2, jsonField3, jsonField4, jsonField5, jsonField6, map2);
    }

    @NotNull
    public final Source source() {
        return (Source)this.source.getRequired$anthropic_java_core("source");
    }

    @NotNull
    public final Type type() {
        return (Type)this.type.getRequired$anthropic_java_core("type");
    }

    @NotNull
    public final Optional<CacheControlEphemeral> cacheControl() {
        Optional<Object> optional = Optional.ofNullable(this.cacheControl.getNullable$anthropic_java_core("cache_control"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<CitationsConfigParam> citations() {
        Optional<Object> optional = Optional.ofNullable(this.citations.getNullable$anthropic_java_core("citations"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<String> context() {
        Optional<Object> optional = Optional.ofNullable(this.context.getNullable$anthropic_java_core("context"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<String> title() {
        Optional<Object> optional = Optional.ofNullable(this.title.getNullable$anthropic_java_core("title"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @JsonProperty(value="source")
    @ExcludeMissing
    @NotNull
    public final JsonField<Source> _source() {
        return this.source;
    }

    @JsonProperty(value="type")
    @ExcludeMissing
    @NotNull
    public final JsonField<Type> _type() {
        return this.type;
    }

    @JsonProperty(value="cache_control")
    @ExcludeMissing
    @NotNull
    public final JsonField<CacheControlEphemeral> _cacheControl() {
        return this.cacheControl;
    }

    @JsonProperty(value="citations")
    @ExcludeMissing
    @NotNull
    public final JsonField<CitationsConfigParam> _citations() {
        return this.citations;
    }

    @JsonProperty(value="context")
    @ExcludeMissing
    @NotNull
    public final JsonField<String> _context() {
        return this.context;
    }

    @JsonProperty(value="title")
    @ExcludeMissing
    @NotNull
    public final JsonField<String> _title() {
        return this.title;
    }

    @JsonAnyGetter
    @ExcludeMissing
    @NotNull
    public final Map<String, com.anthropic.core.JsonValue> _additionalProperties() {
        return this.additionalProperties;
    }

    @NotNull
    public final DocumentBlockParam validate() {
        DocumentBlockParam documentBlockParam;
        DocumentBlockParam $this$validate_u24lambda_u242 = documentBlockParam = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u242.validated) {
            $this$validate_u24lambda_u242.source().validate();
            $this$validate_u24lambda_u242.type();
            $this$validate_u24lambda_u242.cacheControl().ifPresent(arg_0 -> DocumentBlockParam.validate$lambda$2$lambda$0(validate.1.1.INSTANCE, arg_0));
            $this$validate_u24lambda_u242.citations().ifPresent(arg_0 -> DocumentBlockParam.validate$lambda$2$lambda$1(validate.1.2.INSTANCE, arg_0));
            $this$validate_u24lambda_u242.context();
            $this$validate_u24lambda_u242.title();
            $this$validate_u24lambda_u242.validated = true;
        }
        return documentBlockParam;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$anthropic_java_core(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DocumentBlockParam && Intrinsics.areEqual(this.source, ((DocumentBlockParam)other).source) && Intrinsics.areEqual(this.type, ((DocumentBlockParam)other).type) && Intrinsics.areEqual(this.cacheControl, ((DocumentBlockParam)other).cacheControl) && Intrinsics.areEqual(this.citations, ((DocumentBlockParam)other).citations) && Intrinsics.areEqual(this.context, ((DocumentBlockParam)other).context) && Intrinsics.areEqual(this.title, ((DocumentBlockParam)other).title) && Intrinsics.areEqual(this.additionalProperties, ((DocumentBlockParam)other).additionalProperties);
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int hashCode() {
        return this.getHashCode();
    }

    @NotNull
    public String toString() {
        return "DocumentBlockParam{source=" + this.source + ", type=" + this.type + ", cacheControl=" + this.cacheControl + ", citations=" + this.citations + ", context=" + this.context + ", title=" + this.title + ", additionalProperties=" + this.additionalProperties + '}';
    }

    private static final void validate$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void validate$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ DocumentBlockParam(JsonField source, JsonField type, JsonField cacheControl, JsonField citations2, JsonField context, JsonField title, Map additionalProperties, DefaultConstructorMarker $constructor_marker) {
        this(source, type, cacheControl, citations2, context, title, additionalProperties);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\tJ\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0015J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0006J\u001a\u0010\u001c\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005J\u0014\u0010\u001e\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 J\u0014\u0010\r\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Builder;", "", "()V", "additionalProperties", "", "", "Lcom/anthropic/core/JsonValue;", "cacheControl", "Lcom/anthropic/core/JsonField;", "Lcom/anthropic/models/CacheControlEphemeral;", "citations", "Lcom/anthropic/models/CitationsConfigParam;", "context", "source", "Lcom/anthropic/models/DocumentBlockParam$Source;", "title", "type", "Lcom/anthropic/models/DocumentBlockParam$Type;", "", "build", "Lcom/anthropic/models/DocumentBlockParam;", "Ljava/util/Optional;", "from", "documentBlockParam", "from$anthropic_java_core", "putAdditionalProperty", "key", "value", "putAllAdditionalProperties", "removeAdditionalProperty", "removeAllAdditionalProperties", "keys", "", "base64Pdf", "Lcom/anthropic/models/Base64PdfSource;", "contentBlock", "Lcom/anthropic/models/ContentBlockSource;", "plainText", "Lcom/anthropic/models/PlainTextSource;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nDocumentBlockParam.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentBlockParam.kt\ncom/anthropic/models/DocumentBlockParam$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n1#2:477\n1855#3,2:478\n*S KotlinDebug\n*F\n+ 1 DocumentBlockParam.kt\ncom/anthropic/models/DocumentBlockParam$Builder\n*L\n191#1:478,2\n*E\n"})
    public static final class Builder {
        @Nullable
        private JsonField<Source> source;
        @Nullable
        private JsonField<Type> type;
        @NotNull
        private JsonField<CacheControlEphemeral> cacheControl = JsonMissing.Companion.of();
        @NotNull
        private JsonField<CitationsConfigParam> citations = JsonMissing.Companion.of();
        @NotNull
        private JsonField<String> context = JsonMissing.Companion.of();
        @NotNull
        private JsonField<String> title = JsonMissing.Companion.of();
        @NotNull
        private Map<String, com.anthropic.core.JsonValue> additionalProperties = new LinkedHashMap();

        public final /* synthetic */ Builder from$anthropic_java_core(DocumentBlockParam documentBlockParam) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)documentBlockParam, (String)"documentBlockParam");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.source = documentBlockParam.source;
            $this$from_u24lambda_u240.type = documentBlockParam.type;
            $this$from_u24lambda_u240.cacheControl = documentBlockParam.cacheControl;
            $this$from_u24lambda_u240.citations = documentBlockParam.citations;
            $this$from_u24lambda_u240.context = documentBlockParam.context;
            $this$from_u24lambda_u240.title = documentBlockParam.title;
            $this$from_u24lambda_u240.additionalProperties = MapsKt.toMutableMap((Map)documentBlockParam.additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder source(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return this.source(JsonField.Companion.of(source));
        }

        @NotNull
        public final Builder source(@NotNull JsonField<Source> source) {
            Builder builder;
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Builder $this$source_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$source_u24lambda_u241.source = source;
            return builder;
        }

        @NotNull
        public final Builder source(@NotNull Base64PdfSource base64Pdf) {
            Intrinsics.checkNotNullParameter((Object)base64Pdf, (String)"base64Pdf");
            return this.source(Source.Companion.ofBase64Pdf(base64Pdf));
        }

        @NotNull
        public final Builder source(@NotNull PlainTextSource plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return this.source(Source.Companion.ofPlainText(plainText));
        }

        @NotNull
        public final Builder source(@NotNull ContentBlockSource contentBlock) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            return this.source(Source.Companion.ofContentBlock(contentBlock));
        }

        @NotNull
        public final Builder type(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.type(JsonField.Companion.of(type));
        }

        @NotNull
        public final Builder type(@NotNull JsonField<Type> type) {
            Builder builder;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Builder $this$type_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$type_u24lambda_u242.type = type;
            return builder;
        }

        @NotNull
        public final Builder cacheControl(@Nullable CacheControlEphemeral cacheControl) {
            return this.cacheControl(JsonField.Companion.ofNullable(cacheControl));
        }

        @NotNull
        public final Builder cacheControl(@NotNull Optional<CacheControlEphemeral> cacheControl) {
            Intrinsics.checkNotNullParameter(cacheControl, (String)"cacheControl");
            return this.cacheControl((CacheControlEphemeral)cacheControl.orElse(null));
        }

        @NotNull
        public final Builder cacheControl(@NotNull JsonField<CacheControlEphemeral> cacheControl) {
            Builder builder;
            Intrinsics.checkNotNullParameter(cacheControl, (String)"cacheControl");
            Builder $this$cacheControl_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$cacheControl_u24lambda_u243.cacheControl = cacheControl;
            return builder;
        }

        @NotNull
        public final Builder citations(@NotNull CitationsConfigParam citations2) {
            Intrinsics.checkNotNullParameter((Object)citations2, (String)"citations");
            return this.citations(JsonField.Companion.of(citations2));
        }

        @NotNull
        public final Builder citations(@NotNull JsonField<CitationsConfigParam> citations2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(citations2, (String)"citations");
            Builder $this$citations_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$citations_u24lambda_u244.citations = citations2;
            return builder;
        }

        @NotNull
        public final Builder context(@Nullable String context) {
            return this.context(JsonField.Companion.ofNullable(context));
        }

        @NotNull
        public final Builder context(@NotNull Optional<String> context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return this.context((String)context.orElse(null));
        }

        @NotNull
        public final Builder context(@NotNull JsonField<String> context) {
            Builder builder;
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Builder $this$context_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$context_u24lambda_u245.context = context;
            return builder;
        }

        @NotNull
        public final Builder title(@Nullable String title) {
            return this.title(JsonField.Companion.ofNullable(title));
        }

        @NotNull
        public final Builder title(@NotNull Optional<String> title) {
            Intrinsics.checkNotNullParameter(title, (String)"title");
            return this.title((String)title.orElse(null));
        }

        @NotNull
        public final Builder title(@NotNull JsonField<String> title) {
            Builder builder;
            Intrinsics.checkNotNullParameter(title, (String)"title");
            Builder $this$title_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$title_u24lambda_u246.title = title;
            return builder;
        }

        @NotNull
        public final Builder additionalProperties(@NotNull Map<String, ? extends com.anthropic.core.JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$additionalProperties_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$additionalProperties_u24lambda_u247.additionalProperties.clear();
            $this$additionalProperties_u24lambda_u247.putAllAdditionalProperties(additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalProperty(@NotNull String key, @NotNull com.anthropic.core.JsonValue value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalProperty_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$putAdditionalProperty_u24lambda_u248.additionalProperties.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalProperties(@NotNull Map<String, ? extends com.anthropic.core.JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$putAllAdditionalProperties_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalProperties_u24lambda_u249.additionalProperties.putAll(additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalProperty(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeAdditionalProperty_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$removeAdditionalProperty_u24lambda_u2410.additionalProperties.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalProperties(@NotNull Set<String> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$removeAllAdditionalProperties_u24lambda_u2411 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl2 = false;
                $this$removeAllAdditionalProperties_u24lambda_u2411.removeAdditionalProperty(p0);
            }
            return builder;
        }

        @NotNull
        public final DocumentBlockParam build() {
            return new DocumentBlockParam(Check.checkRequired("source", this.source), Check.checkRequired("type", this.type), this.cacheControl, this.citations, this.context, this.title, Utils.toImmutable(this.additionalProperties), null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Companion;", "", "()V", "builder", "Lcom/anthropic/models/DocumentBlockParam$Builder;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000  2\u00020\u0001:\u0004 !\"#B7\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u001f\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0005J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u0013\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\fJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Source;", "", "base64Pdf", "Lcom/anthropic/models/Base64PdfSource;", "plainText", "Lcom/anthropic/models/PlainTextSource;", "contentBlock", "Lcom/anthropic/models/ContentBlockSource;", "_json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/models/Base64PdfSource;Lcom/anthropic/models/PlainTextSource;Lcom/anthropic/models/ContentBlockSource;Lcom/anthropic/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/anthropic/models/DocumentBlockParam$Source$Visitor;", "(Lcom/anthropic/models/DocumentBlockParam$Source$Visitor;)Ljava/lang/Object;", "asBase64Pdf", "asContentBlock", "asPlainText", "equals", "other", "hashCode", "", "isBase64Pdf", "isContentBlock", "isPlainText", "toString", "", "validate", "Companion", "Deserializer", "Serializer", "Visitor", "anthropic-java-core"})
    public static final class Source {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Base64PdfSource base64Pdf;
        @Nullable
        private final PlainTextSource plainText;
        @Nullable
        private final ContentBlockSource contentBlock;
        @Nullable
        private final com.anthropic.core.JsonValue _json;
        private boolean validated;

        private Source(Base64PdfSource base64Pdf, PlainTextSource plainText, ContentBlockSource contentBlock, com.anthropic.core.JsonValue _json) {
            this.base64Pdf = base64Pdf;
            this.plainText = plainText;
            this.contentBlock = contentBlock;
            this._json = _json;
        }

        /* synthetic */ Source(Base64PdfSource base64PdfSource, PlainTextSource plainTextSource, ContentBlockSource contentBlockSource, com.anthropic.core.JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                base64PdfSource = null;
            }
            if ((n & 2) != 0) {
                plainTextSource = null;
            }
            if ((n & 4) != 0) {
                contentBlockSource = null;
            }
            if ((n & 8) != 0) {
                jsonValue = null;
            }
            this(base64PdfSource, plainTextSource, contentBlockSource, jsonValue);
        }

        @NotNull
        public final Optional<Base64PdfSource> base64Pdf() {
            Optional<Base64PdfSource> optional = Optional.ofNullable(this.base64Pdf);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        @NotNull
        public final Optional<PlainTextSource> plainText() {
            Optional<PlainTextSource> optional = Optional.ofNullable(this.plainText);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        @NotNull
        public final Optional<ContentBlockSource> contentBlock() {
            Optional<ContentBlockSource> optional = Optional.ofNullable(this.contentBlock);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final boolean isBase64Pdf() {
            return this.base64Pdf != null;
        }

        public final boolean isPlainText() {
            return this.plainText != null;
        }

        public final boolean isContentBlock() {
            return this.contentBlock != null;
        }

        @NotNull
        public final Base64PdfSource asBase64Pdf() {
            return (Base64PdfSource)Utils.getOrThrow(this.base64Pdf, "base64Pdf");
        }

        @NotNull
        public final PlainTextSource asPlainText() {
            return (PlainTextSource)Utils.getOrThrow(this.plainText, "plainText");
        }

        @NotNull
        public final ContentBlockSource asContentBlock() {
            return (ContentBlockSource)Utils.getOrThrow(this.contentBlock, "contentBlock");
        }

        @NotNull
        public final Optional<com.anthropic.core.JsonValue> _json() {
            Optional<com.anthropic.core.JsonValue> optional = Optional.ofNullable(this._json);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return this.base64Pdf != null ? visitor.visitBase64Pdf(this.base64Pdf) : (this.plainText != null ? visitor.visitPlainText(this.plainText) : (this.contentBlock != null ? visitor.visitContentBlock(this.contentBlock) : visitor.unknown(this._json)));
        }

        @NotNull
        public final Source validate() {
            Source source;
            Source $this$validate_u24lambda_u240 = source = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u240.validated) {
                $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                    public void visitBase64Pdf(@NotNull Base64PdfSource base64Pdf) {
                        Intrinsics.checkNotNullParameter((Object)base64Pdf, (String)"base64Pdf");
                        base64Pdf.validate();
                    }

                    public void visitPlainText(@NotNull PlainTextSource plainText) {
                        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
                        plainText.validate();
                    }

                    public void visitContentBlock(@NotNull ContentBlockSource contentBlock) {
                        Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
                        contentBlock.validate();
                    }
                });
                $this$validate_u24lambda_u240.validated = true;
            }
            return source;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Source && Intrinsics.areEqual((Object)this.base64Pdf, (Object)((Source)other).base64Pdf) && Intrinsics.areEqual((Object)this.plainText, (Object)((Source)other).plainText) && Intrinsics.areEqual((Object)this.contentBlock, (Object)((Source)other).contentBlock);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.base64Pdf, this.plainText, this.contentBlock};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            String string;
            if (this.base64Pdf != null) {
                string = "Source{base64Pdf=" + this.base64Pdf + '}';
            } else if (this.plainText != null) {
                string = "Source{plainText=" + this.plainText + '}';
            } else if (this.contentBlock != null) {
                string = "Source{contentBlock=" + this.contentBlock + '}';
            } else if (this._json != null) {
                string = "Source{_unknown=" + this._json + '}';
            } else {
                throw new IllegalStateException("Invalid Source");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public static final Source ofBase64Pdf(@NotNull Base64PdfSource base64Pdf) {
            return Companion.ofBase64Pdf(base64Pdf);
        }

        @JvmStatic
        @NotNull
        public static final Source ofPlainText(@NotNull PlainTextSource plainText) {
            return Companion.ofPlainText(plainText);
        }

        @JvmStatic
        @NotNull
        public static final Source ofContentBlock(@NotNull ContentBlockSource contentBlock) {
            return Companion.ofContentBlock(contentBlock);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Source$Companion;", "", "()V", "ofBase64Pdf", "Lcom/anthropic/models/DocumentBlockParam$Source;", "base64Pdf", "Lcom/anthropic/models/Base64PdfSource;", "ofContentBlock", "contentBlock", "Lcom/anthropic/models/ContentBlockSource;", "ofPlainText", "plainText", "Lcom/anthropic/models/PlainTextSource;", "anthropic-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Source ofBase64Pdf(@NotNull Base64PdfSource base64Pdf) {
                Intrinsics.checkNotNullParameter((Object)base64Pdf, (String)"base64Pdf");
                return new Source(base64Pdf, null, null, null, 14, null);
            }

            @JvmStatic
            @NotNull
            public final Source ofPlainText(@NotNull PlainTextSource plainText) {
                Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
                return new Source(null, plainText, null, null, 13, null);
            }

            @JvmStatic
            @NotNull
            public final Source ofContentBlock(@NotNull ContentBlockSource contentBlock) {
                Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
                return new Source(null, null, contentBlock, null, 11, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Source$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/DocumentBlockParam$Source;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
        @SourceDebugExtension(value={"SMAP\nDocumentBlockParam.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentBlockParam.kt\ncom/anthropic/models/DocumentBlockParam$Source$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,476:1\n51#2:477\n51#2:478\n51#2:479\n*S KotlinDebug\n*F\n+ 1 DocumentBlockParam.kt\ncom/anthropic/models/DocumentBlockParam$Source$Deserializer\n*L\n332#1:477\n338#1:478\n344#1:479\n*E\n"})
        public static final class Deserializer
        extends BaseDeserializer<Source> {
            public Deserializer() {
                super(Reflection.getOrCreateKotlinClass(Source.class));
            }

            @Override
            @NotNull
            protected Source deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
                com.anthropic.core.JsonValue json2;
                block13: {
                    String type;
                    Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    json2 = com.anthropic.core.JsonValue.Companion.fromJsonNode(node);
                    Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                    String string = type = object != null && (object = (com.anthropic.core.JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                    if (string == null) break block13;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1396204209: {
                            if (string.equals("base64")) {
                                n = 1;
                            }
                            break;
                        }
                        case 3556653: {
                            if (string.equals("text")) {
                                n = 2;
                            }
                            break;
                        }
                        case 951530617: {
                            if (string.equals("content")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            boolean $i$f$jacksonTypeRef = false;
                            Base64PdfSource base64PdfSource = (Base64PdfSource)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<Base64PdfSource>(){}, (Function1)deserialize.1.INSTANCE);
                            if (base64PdfSource == null) break;
                            Base64PdfSource it = base64PdfSource;
                            boolean bl = false;
                            return new Source(it, null, null, json2, 6, null);
                        }
                        case 2: {
                            boolean $i$f$jacksonTypeRef = false;
                            PlainTextSource plainTextSource = (PlainTextSource)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PlainTextSource>(){}, (Function1)deserialize.3.INSTANCE);
                            if (plainTextSource == null) break;
                            PlainTextSource it = plainTextSource;
                            boolean bl = false;
                            return new Source(null, it, null, json2, 5, null);
                        }
                        case 3: {
                            boolean $i$f$jacksonTypeRef = false;
                            ContentBlockSource contentBlockSource = (ContentBlockSource)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ContentBlockSource>(){}, (Function1)deserialize.5.INSTANCE);
                            if (contentBlockSource == null) break;
                            ContentBlockSource it = contentBlockSource;
                            boolean bl = false;
                            return new Source(null, null, it, json2, 3, null);
                        }
                    }
                }
                return new Source(null, null, null, json2, 7, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Source$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/DocumentBlockParam$Source;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
        public static final class Serializer
        extends BaseSerializer<Source> {
            public Serializer() {
                super(Reflection.getOrCreateKotlinClass(Source.class));
            }

            public void serialize(@NotNull Source value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                if (value.base64Pdf != null) {
                    generator.writeObject((Object)value.base64Pdf);
                } else if (value.plainText != null) {
                    generator.writeObject((Object)value.plainText);
                } else if (value.contentBlock != null) {
                    generator.writeObject((Object)value.contentBlock);
                } else if (value._json != null) {
                    generator.writeObject((Object)value._json);
                } else {
                    throw new IllegalStateException("Invalid Source");
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Source$Visitor;", "T", "", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "visitBase64Pdf", "base64Pdf", "Lcom/anthropic/models/Base64PdfSource;", "(Lcom/anthropic/models/Base64PdfSource;)Ljava/lang/Object;", "visitContentBlock", "contentBlock", "Lcom/anthropic/models/ContentBlockSource;", "(Lcom/anthropic/models/ContentBlockSource;)Ljava/lang/Object;", "visitPlainText", "plainText", "Lcom/anthropic/models/PlainTextSource;", "(Lcom/anthropic/models/PlainTextSource;)Ljava/lang/Object;", "anthropic-java-core"})
        public static interface Visitor<T> {
            public T visitBase64Pdf(@NotNull Base64PdfSource var1);

            public T visitPlainText(@NotNull PlainTextSource var1);

            public T visitContentBlock(@NotNull ContentBlockSource var1);

            default public T unknown(@Nullable com.anthropic.core.JsonValue json2) {
                throw new AnthropicInvalidDataException("Unknown Source: " + json2, null, 2, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0015\b\u0003\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0006\u0010\u0007\u001a\u00020\u0004J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0006\u0010\u0002\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Type;", "Lcom/anthropic/core/Enum;", "value", "Lcom/anthropic/core/JsonField;", "", "(Lcom/anthropic/core/JsonField;)V", "_value", "asString", "equals", "", "other", "", "hashCode", "", "known", "Lcom/anthropic/models/DocumentBlockParam$Type$Known;", "toString", "Lcom/anthropic/models/DocumentBlockParam$Type$Value;", "Companion", "Known", "Value", "anthropic-java-core"})
    public static final class Type
    implements com.anthropic.core.Enum {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JsonField<String> value;
        @JvmField
        @NotNull
        public static final Type DOCUMENT = Companion.of("document");

        @JsonCreator
        private Type(JsonField<String> value) {
            this.value = value;
        }

        @JsonValue
        @NotNull
        public final JsonField<String> _value() {
            return this.value;
        }

        @NotNull
        public final Value value() {
            return Intrinsics.areEqual((Object)this, (Object)DOCUMENT) ? Value.DOCUMENT : Value._UNKNOWN;
        }

        @NotNull
        public final Known known() {
            if (!Intrinsics.areEqual((Object)this, (Object)DOCUMENT)) {
                throw new AnthropicInvalidDataException("Unknown Type: " + this.value, null, 2, null);
            }
            return Known.DOCUMENT;
        }

        @NotNull
        public final String asString() {
            return this._value().asStringOrThrow();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Type && Intrinsics.areEqual(this.value, ((Type)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @NotNull
        public String toString() {
            return this.value.toString();
        }

        @JvmStatic
        @NotNull
        public static final Type of(@NotNull String value) {
            return Companion.of(value);
        }

        public /* synthetic */ Type(JsonField value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Type$Companion;", "", "()V", "DOCUMENT", "Lcom/anthropic/models/DocumentBlockParam$Type;", "of", "value", "", "anthropic-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Type of(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Type(JsonField.Companion.of(value), null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Type$Known;", "", "(Ljava/lang/String;I)V", "DOCUMENT", "anthropic-java-core"})
        public static final class Known
        extends Enum<Known> {
            public static final /* enum */ Known DOCUMENT = new Known();
            private static final /* synthetic */ Known[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Known[] values() {
                return (Known[])$VALUES.clone();
            }

            public static Known valueOf(String value) {
                return Enum.valueOf(Known.class, value);
            }

            @NotNull
            public static EnumEntries<Known> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = knownArray = new Known[]{Known.DOCUMENT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/anthropic/models/DocumentBlockParam$Type$Value;", "", "(Ljava/lang/String;I)V", "DOCUMENT", "_UNKNOWN", "anthropic-java-core"})
        public static final class Value
        extends Enum<Value> {
            public static final /* enum */ Value DOCUMENT = new Value();
            public static final /* enum */ Value _UNKNOWN = new Value();
            private static final /* synthetic */ Value[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Value[] values() {
                return (Value[])$VALUES.clone();
            }

            public static Value valueOf(String value) {
                return Enum.valueOf(Value.class, value);
            }

            @NotNull
            public static EnumEntries<Value> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = valueArray = new Value[]{Value.DOCUMENT, Value._UNKNOWN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

