/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core;

import com.anthropic.core.Enum;
import com.anthropic.core.JsonValue;
import com.anthropic.core.MultipartFormValue;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.errors.AnthropicException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u0002H\u0080\b\u00a2\u0006\u0002\u0010\u0006\u001a)\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"json", "Lcom/anthropic/core/http/HttpRequestBody;", "T", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "value", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/lang/Object;)Lcom/anthropic/core/http/HttpRequestBody;", "multipartFormData", "parts", "", "Lcom/anthropic/core/MultipartFormValue;", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;[Lcom/anthropic/core/MultipartFormValue;)Lcom/anthropic/core/http/HttpRequestBody;", "anthropic-java-core"})
@JvmName(name="HttpRequestBodies")
@SourceDebugExtension(value={"SMAP\nHttpRequestBodies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestBodies.kt\ncom/anthropic/core/HttpRequestBodies\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,112:1\n13309#2,2:113\n*S KotlinDebug\n*F\n+ 1 HttpRequestBodies.kt\ncom/anthropic/core/HttpRequestBodies\n*L\n55#1:113,2\n*E\n"})
public final class HttpRequestBodies {
    public static final /* synthetic */ <T> HttpRequestBody json(JsonMapper jsonMapper, T value) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$json = false;
        return new HttpRequestBody(jsonMapper, value){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new AnthropicException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        };
    }

    public static final /* synthetic */ HttpRequestBody multipartFormData(JsonMapper jsonMapper, MultipartFormValue[] parts) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        MultipartFormValue[] $this$forEach$iv = parts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MultipartFormValue element$iv;
            MultipartFormValue part = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            MultipartFormValue multipartFormValue = part;
            if ((multipartFormValue != null ? multipartFormValue.getValue() : null) == null) continue;
            Object t = part.getValue();
            if (t instanceof JsonValue) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    jsonMapper.writeValue((OutputStream)buffer, part.getValue());
                }
                catch (Exception e) {
                    throw new AnthropicException("Error serializing value to json", e);
                }
                builder.addBinaryBody(part.getName(), buffer.toByteArray(), part.getContentType(), part.getFilename());
                continue;
            }
            if (t instanceof Boolean) {
                builder.addTextBody(part.getName(), (Boolean)part.getValue() != false ? "true" : "false", part.getContentType());
                continue;
            }
            if (t instanceof Integer) {
                builder.addTextBody(part.getName(), part.getValue().toString(), part.getContentType());
                continue;
            }
            if (t instanceof Long) {
                builder.addTextBody(part.getName(), part.getValue().toString(), part.getContentType());
                continue;
            }
            if (t instanceof Double) {
                builder.addTextBody(part.getName(), part.getValue().toString(), part.getContentType());
                continue;
            }
            if (t instanceof byte[]) {
                builder.addBinaryBody(part.getName(), (byte[])part.getValue(), part.getContentType(), part.getFilename());
                continue;
            }
            if (t instanceof String) {
                builder.addTextBody(part.getName(), (String)part.getValue(), part.getContentType());
                continue;
            }
            if (t instanceof Enum) {
                builder.addTextBody(part.getName(), part.getValue().toString(), part.getContentType());
                continue;
            }
            throw new IllegalArgumentException("Unsupported content type: " + part.getValue().getClass().getSimpleName());
        }
        HttpEntity entity = builder.build();
        return new HttpRequestBody(entity){
            final /* synthetic */ HttpEntity $entity;
            {
                this.$entity = $entity;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                try {
                    this.$entity.writeTo(outputStream);
                    return;
                }
                catch (Exception e) {
                    throw new AnthropicException("Error writing request", e);
                }
            }

            @NotNull
            public String contentType() {
                String string = this.$entity.getContentType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentType(...)");
                return string;
            }

            public long contentLength() {
                return -1L;
            }

            public boolean repeatable() {
                return this.$entity.isRepeatable();
            }

            public void close() {
                this.$entity.close();
            }
        };
    }
}

