/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonValue;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.ContentBlock;
import com.anthropic.models.ContentBlockParam;
import com.anthropic.models.TextBlock;
import com.anthropic.models.ToolUseBlock;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001e\u001f !B+\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0005J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0006\u0010\u001d\u001a\u00020\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/anthropic/models/ContentBlock;", "", "textBlock", "Lcom/anthropic/models/TextBlock;", "toolUseBlock", "Lcom/anthropic/models/ToolUseBlock;", "_json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/models/TextBlock;Lcom/anthropic/models/ToolUseBlock;Lcom/anthropic/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/anthropic/models/ContentBlock$Visitor;", "(Lcom/anthropic/models/ContentBlock$Visitor;)Ljava/lang/Object;", "asTextBlock", "asToolUseBlock", "equals", "other", "hashCode", "", "isTextBlock", "isToolUseBlock", "toParam", "Lcom/anthropic/models/ContentBlockParam;", "toString", "", "validate", "Companion", "Deserializer", "Serializer", "Visitor", "anthropic-java-core"})
public final class ContentBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TextBlock textBlock;
    @Nullable
    private final ToolUseBlock toolUseBlock;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private ContentBlock(TextBlock textBlock, ToolUseBlock toolUseBlock, JsonValue _json) {
        this.textBlock = textBlock;
        this.toolUseBlock = toolUseBlock;
        this._json = _json;
    }

    /* synthetic */ ContentBlock(TextBlock textBlock, ToolUseBlock toolUseBlock, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            textBlock = null;
        }
        if ((n & 2) != 0) {
            toolUseBlock = null;
        }
        if ((n & 4) != 0) {
            jsonValue = null;
        }
        this(textBlock, toolUseBlock, jsonValue);
    }

    @NotNull
    public final ContentBlockParam toParam() {
        return (ContentBlockParam)this.accept((Visitor)new Visitor<ContentBlockParam>(){

            @NotNull
            public ContentBlockParam visitTextBlock(@NotNull TextBlock textBlock) {
                Intrinsics.checkNotNullParameter((Object)textBlock, (String)"textBlock");
                return ContentBlockParam.Companion.ofTextBlockParam(textBlock.toParam());
            }

            @NotNull
            public ContentBlockParam visitToolUseBlock(@NotNull ToolUseBlock toolUseBlock) {
                Intrinsics.checkNotNullParameter((Object)toolUseBlock, (String)"toolUseBlock");
                return ContentBlockParam.Companion.ofToolUseBlockParam(toolUseBlock.toParam());
            }
        });
    }

    @NotNull
    public final Optional<TextBlock> textBlock() {
        Optional<TextBlock> optional = Optional.ofNullable(this.textBlock);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<ToolUseBlock> toolUseBlock() {
        Optional<ToolUseBlock> optional = Optional.ofNullable(this.toolUseBlock);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isTextBlock() {
        return this.textBlock != null;
    }

    public final boolean isToolUseBlock() {
        return this.toolUseBlock != null;
    }

    @NotNull
    public final TextBlock asTextBlock() {
        return (TextBlock)Utils.getOrThrow(this.textBlock, "textBlock");
    }

    @NotNull
    public final ToolUseBlock asToolUseBlock() {
        return (ToolUseBlock)Utils.getOrThrow(this.toolUseBlock, "toolUseBlock");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.textBlock != null ? visitor.visitTextBlock(this.textBlock) : (this.toolUseBlock != null ? visitor.visitToolUseBlock(this.toolUseBlock) : visitor.unknown(this._json));
    }

    @NotNull
    public final ContentBlock validate() {
        ContentBlock contentBlock;
        ContentBlock $this$validate_u24lambda_u240 = contentBlock = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitTextBlock(@NotNull TextBlock textBlock) {
                    Intrinsics.checkNotNullParameter((Object)textBlock, (String)"textBlock");
                    textBlock.validate();
                }

                public void visitToolUseBlock(@NotNull ToolUseBlock toolUseBlock) {
                    Intrinsics.checkNotNullParameter((Object)toolUseBlock, (String)"toolUseBlock");
                    toolUseBlock.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return contentBlock;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentBlock && Intrinsics.areEqual((Object)this.textBlock, (Object)((ContentBlock)other).textBlock) && Intrinsics.areEqual((Object)this.toolUseBlock, (Object)((ContentBlock)other).toolUseBlock);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.textBlock, this.toolUseBlock};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.textBlock != null) {
            string = "ContentBlock{textBlock=" + this.textBlock + '}';
        } else if (this.toolUseBlock != null) {
            string = "ContentBlock{toolUseBlock=" + this.toolUseBlock + '}';
        } else if (this._json != null) {
            string = "ContentBlock{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid ContentBlock");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ContentBlock ofTextBlock(@NotNull TextBlock textBlock) {
        return Companion.ofTextBlock(textBlock);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlock ofToolUseBlock(@NotNull ToolUseBlock toolUseBlock) {
        return Companion.ofToolUseBlock(toolUseBlock);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/anthropic/models/ContentBlock$Companion;", "", "()V", "ofTextBlock", "Lcom/anthropic/models/ContentBlock;", "textBlock", "Lcom/anthropic/models/TextBlock;", "ofToolUseBlock", "toolUseBlock", "Lcom/anthropic/models/ToolUseBlock;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ContentBlock ofTextBlock(@NotNull TextBlock textBlock) {
            Intrinsics.checkNotNullParameter((Object)textBlock, (String)"textBlock");
            return new ContentBlock(textBlock, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlock ofToolUseBlock(@NotNull ToolUseBlock toolUseBlock) {
            Intrinsics.checkNotNullParameter((Object)toolUseBlock, (String)"toolUseBlock");
            return new ContentBlock(null, toolUseBlock, null, 5, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/anthropic/models/ContentBlock$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/ContentBlock;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nContentBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentBlock.kt\ncom/anthropic/models/ContentBlock$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,162:1\n51#2:163\n51#2:164\n*S KotlinDebug\n*F\n+ 1 ContentBlock.kt\ncom/anthropic/models/ContentBlock$Deserializer\n*L\n129#1:163\n135#1:164\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<ContentBlock> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(ContentBlock.class));
        }

        @Override
        @NotNull
        protected ContentBlock deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            String type;
            Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
            Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
            String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
            if (Intrinsics.areEqual(string, (Object)"text")) {
                boolean $i$f$jacksonTypeRef = false;
                TextBlock textBlock = (TextBlock)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TextBlock>(){}, (Function1)deserialize.1.INSTANCE);
                if (textBlock != null) {
                    TextBlock it = textBlock;
                    boolean bl = false;
                    return new ContentBlock(it, null, json2, 2, null);
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)"tool_use")) {
                boolean $i$f$jacksonTypeRef = false;
                ToolUseBlock toolUseBlock = (ToolUseBlock)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ToolUseBlock>(){}, (Function1)deserialize.3.INSTANCE);
                if (toolUseBlock != null) {
                    ToolUseBlock it = toolUseBlock;
                    boolean bl = false;
                    return new ContentBlock(null, it, json2, 1, null);
                }
            }
            return new ContentBlock(null, null, json2, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/models/ContentBlock$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/ContentBlock;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
    public static final class Serializer
    extends BaseSerializer<ContentBlock> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(ContentBlock.class));
        }

        public void serialize(@NotNull ContentBlock value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.textBlock != null) {
                generator.writeObject((Object)value.textBlock);
            } else if (value.toolUseBlock != null) {
                generator.writeObject((Object)value.toolUseBlock);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid ContentBlock");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/ContentBlock$Visitor;", "T", "", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "visitTextBlock", "textBlock", "Lcom/anthropic/models/TextBlock;", "(Lcom/anthropic/models/TextBlock;)Ljava/lang/Object;", "visitToolUseBlock", "toolUseBlock", "Lcom/anthropic/models/ToolUseBlock;", "(Lcom/anthropic/models/ToolUseBlock;)Ljava/lang/Object;", "anthropic-java-core"})
    public static interface Visitor<T> {
        public T visitTextBlock(@NotNull TextBlock var1);

        public T visitToolUseBlock(@NotNull ToolUseBlock var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new AnthropicInvalidDataException("Unknown ContentBlock: " + json2, null, 2, null);
        }
    }
}

