/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonValue;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.ApiErrorObject;
import com.anthropic.models.AuthenticationError;
import com.anthropic.models.BillingError;
import com.anthropic.models.ErrorObject;
import com.anthropic.models.GatewayTimeoutError;
import com.anthropic.models.InvalidRequestError;
import com.anthropic.models.NotFoundError;
import com.anthropic.models.OverloadedError;
import com.anthropic.models.PermissionError;
import com.anthropic.models.RateLimitError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 82\u00020\u0001:\u000489:;B\u007f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J\u001f\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d\u00a2\u0006\u0002\u0010\u001eJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019J\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u000fJ\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u0013J\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\rJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019J\u0013\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\b\u0010*\u001a\u00020+H\u0016J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u0018J\u0006\u0010.\u001a\u00020\u0018J\u0006\u0010/\u001a\u00020\u0018J\u0006\u00100\u001a\u00020\u0018J\u0006\u00101\u001a\u00020\u0018J\u0006\u00102\u001a\u00020\u0018J\u0006\u00103\u001a\u00020\u0018J\u0006\u00104\u001a\u00020\u0018J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J\b\u00105\u001a\u000206H\u0016J\u0006\u00107\u001a\u00020\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/anthropic/models/ErrorObject;", "", "invalidRequestError", "Lcom/anthropic/models/InvalidRequestError;", "authenticationError", "Lcom/anthropic/models/AuthenticationError;", "billingError", "Lcom/anthropic/models/BillingError;", "permissionError", "Lcom/anthropic/models/PermissionError;", "notFoundError", "Lcom/anthropic/models/NotFoundError;", "rateLimitError", "Lcom/anthropic/models/RateLimitError;", "gatewayTimeoutError", "Lcom/anthropic/models/GatewayTimeoutError;", "apiErrorObject", "Lcom/anthropic/models/ApiErrorObject;", "overloadedError", "Lcom/anthropic/models/OverloadedError;", "_json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/models/InvalidRequestError;Lcom/anthropic/models/AuthenticationError;Lcom/anthropic/models/BillingError;Lcom/anthropic/models/PermissionError;Lcom/anthropic/models/NotFoundError;Lcom/anthropic/models/RateLimitError;Lcom/anthropic/models/GatewayTimeoutError;Lcom/anthropic/models/ApiErrorObject;Lcom/anthropic/models/OverloadedError;Lcom/anthropic/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/anthropic/models/ErrorObject$Visitor;", "(Lcom/anthropic/models/ErrorObject$Visitor;)Ljava/lang/Object;", "asApiErrorObject", "asAuthenticationError", "asBillingError", "asGatewayTimeoutError", "asInvalidRequestError", "asNotFoundError", "asOverloadedError", "asPermissionError", "asRateLimitError", "equals", "other", "hashCode", "", "isApiErrorObject", "isAuthenticationError", "isBillingError", "isGatewayTimeoutError", "isInvalidRequestError", "isNotFoundError", "isOverloadedError", "isPermissionError", "isRateLimitError", "toString", "", "validate", "Companion", "Deserializer", "Serializer", "Visitor", "anthropic-java-core"})
public final class ErrorObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final InvalidRequestError invalidRequestError;
    @Nullable
    private final AuthenticationError authenticationError;
    @Nullable
    private final BillingError billingError;
    @Nullable
    private final PermissionError permissionError;
    @Nullable
    private final NotFoundError notFoundError;
    @Nullable
    private final RateLimitError rateLimitError;
    @Nullable
    private final GatewayTimeoutError gatewayTimeoutError;
    @Nullable
    private final ApiErrorObject apiErrorObject;
    @Nullable
    private final OverloadedError overloadedError;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private ErrorObject(InvalidRequestError invalidRequestError, AuthenticationError authenticationError, BillingError billingError, PermissionError permissionError, NotFoundError notFoundError, RateLimitError rateLimitError, GatewayTimeoutError gatewayTimeoutError, ApiErrorObject apiErrorObject, OverloadedError overloadedError, JsonValue _json) {
        this.invalidRequestError = invalidRequestError;
        this.authenticationError = authenticationError;
        this.billingError = billingError;
        this.permissionError = permissionError;
        this.notFoundError = notFoundError;
        this.rateLimitError = rateLimitError;
        this.gatewayTimeoutError = gatewayTimeoutError;
        this.apiErrorObject = apiErrorObject;
        this.overloadedError = overloadedError;
        this._json = _json;
    }

    /* synthetic */ ErrorObject(InvalidRequestError invalidRequestError, AuthenticationError authenticationError, BillingError billingError, PermissionError permissionError, NotFoundError notFoundError, RateLimitError rateLimitError, GatewayTimeoutError gatewayTimeoutError, ApiErrorObject apiErrorObject, OverloadedError overloadedError, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            invalidRequestError = null;
        }
        if ((n & 2) != 0) {
            authenticationError = null;
        }
        if ((n & 4) != 0) {
            billingError = null;
        }
        if ((n & 8) != 0) {
            permissionError = null;
        }
        if ((n & 0x10) != 0) {
            notFoundError = null;
        }
        if ((n & 0x20) != 0) {
            rateLimitError = null;
        }
        if ((n & 0x40) != 0) {
            gatewayTimeoutError = null;
        }
        if ((n & 0x80) != 0) {
            apiErrorObject = null;
        }
        if ((n & 0x100) != 0) {
            overloadedError = null;
        }
        if ((n & 0x200) != 0) {
            jsonValue = null;
        }
        this(invalidRequestError, authenticationError, billingError, permissionError, notFoundError, rateLimitError, gatewayTimeoutError, apiErrorObject, overloadedError, jsonValue);
    }

    @NotNull
    public final Optional<InvalidRequestError> invalidRequestError() {
        Optional<InvalidRequestError> optional = Optional.ofNullable(this.invalidRequestError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<AuthenticationError> authenticationError() {
        Optional<AuthenticationError> optional = Optional.ofNullable(this.authenticationError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<BillingError> billingError() {
        Optional<BillingError> optional = Optional.ofNullable(this.billingError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<PermissionError> permissionError() {
        Optional<PermissionError> optional = Optional.ofNullable(this.permissionError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<NotFoundError> notFoundError() {
        Optional<NotFoundError> optional = Optional.ofNullable(this.notFoundError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<RateLimitError> rateLimitError() {
        Optional<RateLimitError> optional = Optional.ofNullable(this.rateLimitError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<GatewayTimeoutError> gatewayTimeoutError() {
        Optional<GatewayTimeoutError> optional = Optional.ofNullable(this.gatewayTimeoutError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<ApiErrorObject> apiErrorObject() {
        Optional<ApiErrorObject> optional = Optional.ofNullable(this.apiErrorObject);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<OverloadedError> overloadedError() {
        Optional<OverloadedError> optional = Optional.ofNullable(this.overloadedError);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isInvalidRequestError() {
        return this.invalidRequestError != null;
    }

    public final boolean isAuthenticationError() {
        return this.authenticationError != null;
    }

    public final boolean isBillingError() {
        return this.billingError != null;
    }

    public final boolean isPermissionError() {
        return this.permissionError != null;
    }

    public final boolean isNotFoundError() {
        return this.notFoundError != null;
    }

    public final boolean isRateLimitError() {
        return this.rateLimitError != null;
    }

    public final boolean isGatewayTimeoutError() {
        return this.gatewayTimeoutError != null;
    }

    public final boolean isApiErrorObject() {
        return this.apiErrorObject != null;
    }

    public final boolean isOverloadedError() {
        return this.overloadedError != null;
    }

    @NotNull
    public final InvalidRequestError asInvalidRequestError() {
        return (InvalidRequestError)Utils.getOrThrow(this.invalidRequestError, "invalidRequestError");
    }

    @NotNull
    public final AuthenticationError asAuthenticationError() {
        return (AuthenticationError)Utils.getOrThrow(this.authenticationError, "authenticationError");
    }

    @NotNull
    public final BillingError asBillingError() {
        return (BillingError)Utils.getOrThrow(this.billingError, "billingError");
    }

    @NotNull
    public final PermissionError asPermissionError() {
        return (PermissionError)Utils.getOrThrow(this.permissionError, "permissionError");
    }

    @NotNull
    public final NotFoundError asNotFoundError() {
        return (NotFoundError)Utils.getOrThrow(this.notFoundError, "notFoundError");
    }

    @NotNull
    public final RateLimitError asRateLimitError() {
        return (RateLimitError)Utils.getOrThrow(this.rateLimitError, "rateLimitError");
    }

    @NotNull
    public final GatewayTimeoutError asGatewayTimeoutError() {
        return (GatewayTimeoutError)Utils.getOrThrow(this.gatewayTimeoutError, "gatewayTimeoutError");
    }

    @NotNull
    public final ApiErrorObject asApiErrorObject() {
        return (ApiErrorObject)Utils.getOrThrow(this.apiErrorObject, "apiErrorObject");
    }

    @NotNull
    public final OverloadedError asOverloadedError() {
        return (OverloadedError)Utils.getOrThrow(this.overloadedError, "overloadedError");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.invalidRequestError != null ? visitor.visitInvalidRequestError(this.invalidRequestError) : (this.authenticationError != null ? visitor.visitAuthenticationError(this.authenticationError) : (this.billingError != null ? visitor.visitBillingError(this.billingError) : (this.permissionError != null ? visitor.visitPermissionError(this.permissionError) : (this.notFoundError != null ? visitor.visitNotFoundError(this.notFoundError) : (this.rateLimitError != null ? visitor.visitRateLimitError(this.rateLimitError) : (this.gatewayTimeoutError != null ? visitor.visitGatewayTimeoutError(this.gatewayTimeoutError) : (this.apiErrorObject != null ? visitor.visitApiErrorObject(this.apiErrorObject) : (this.overloadedError != null ? visitor.visitOverloadedError(this.overloadedError) : visitor.unknown(this._json)))))))));
    }

    @NotNull
    public final ErrorObject validate() {
        ErrorObject errorObject;
        ErrorObject $this$validate_u24lambda_u240 = errorObject = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitInvalidRequestError(@NotNull InvalidRequestError invalidRequestError) {
                    Intrinsics.checkNotNullParameter((Object)invalidRequestError, (String)"invalidRequestError");
                    invalidRequestError.validate();
                }

                public void visitAuthenticationError(@NotNull AuthenticationError authenticationError) {
                    Intrinsics.checkNotNullParameter((Object)authenticationError, (String)"authenticationError");
                    authenticationError.validate();
                }

                public void visitBillingError(@NotNull BillingError billingError) {
                    Intrinsics.checkNotNullParameter((Object)billingError, (String)"billingError");
                    billingError.validate();
                }

                public void visitPermissionError(@NotNull PermissionError permissionError) {
                    Intrinsics.checkNotNullParameter((Object)permissionError, (String)"permissionError");
                    permissionError.validate();
                }

                public void visitNotFoundError(@NotNull NotFoundError notFoundError) {
                    Intrinsics.checkNotNullParameter((Object)notFoundError, (String)"notFoundError");
                    notFoundError.validate();
                }

                public void visitRateLimitError(@NotNull RateLimitError rateLimitError) {
                    Intrinsics.checkNotNullParameter((Object)rateLimitError, (String)"rateLimitError");
                    rateLimitError.validate();
                }

                public void visitGatewayTimeoutError(@NotNull GatewayTimeoutError gatewayTimeoutError) {
                    Intrinsics.checkNotNullParameter((Object)gatewayTimeoutError, (String)"gatewayTimeoutError");
                    gatewayTimeoutError.validate();
                }

                public void visitApiErrorObject(@NotNull ApiErrorObject apiErrorObject) {
                    Intrinsics.checkNotNullParameter((Object)apiErrorObject, (String)"apiErrorObject");
                    apiErrorObject.validate();
                }

                public void visitOverloadedError(@NotNull OverloadedError overloadedError) {
                    Intrinsics.checkNotNullParameter((Object)overloadedError, (String)"overloadedError");
                    overloadedError.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return errorObject;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ErrorObject && Intrinsics.areEqual((Object)this.invalidRequestError, (Object)((ErrorObject)other).invalidRequestError) && Intrinsics.areEqual((Object)this.authenticationError, (Object)((ErrorObject)other).authenticationError) && Intrinsics.areEqual((Object)this.billingError, (Object)((ErrorObject)other).billingError) && Intrinsics.areEqual((Object)this.permissionError, (Object)((ErrorObject)other).permissionError) && Intrinsics.areEqual((Object)this.notFoundError, (Object)((ErrorObject)other).notFoundError) && Intrinsics.areEqual((Object)this.rateLimitError, (Object)((ErrorObject)other).rateLimitError) && Intrinsics.areEqual((Object)this.gatewayTimeoutError, (Object)((ErrorObject)other).gatewayTimeoutError) && Intrinsics.areEqual((Object)this.apiErrorObject, (Object)((ErrorObject)other).apiErrorObject) && Intrinsics.areEqual((Object)this.overloadedError, (Object)((ErrorObject)other).overloadedError);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.invalidRequestError, this.authenticationError, this.billingError, this.permissionError, this.notFoundError, this.rateLimitError, this.gatewayTimeoutError, this.apiErrorObject, this.overloadedError};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.invalidRequestError != null) {
            string = "ErrorObject{invalidRequestError=" + this.invalidRequestError + '}';
        } else if (this.authenticationError != null) {
            string = "ErrorObject{authenticationError=" + this.authenticationError + '}';
        } else if (this.billingError != null) {
            string = "ErrorObject{billingError=" + this.billingError + '}';
        } else if (this.permissionError != null) {
            string = "ErrorObject{permissionError=" + this.permissionError + '}';
        } else if (this.notFoundError != null) {
            string = "ErrorObject{notFoundError=" + this.notFoundError + '}';
        } else if (this.rateLimitError != null) {
            string = "ErrorObject{rateLimitError=" + this.rateLimitError + '}';
        } else if (this.gatewayTimeoutError != null) {
            string = "ErrorObject{gatewayTimeoutError=" + this.gatewayTimeoutError + '}';
        } else if (this.apiErrorObject != null) {
            string = "ErrorObject{apiErrorObject=" + this.apiErrorObject + '}';
        } else if (this.overloadedError != null) {
            string = "ErrorObject{overloadedError=" + this.overloadedError + '}';
        } else if (this._json != null) {
            string = "ErrorObject{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid ErrorObject");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofInvalidRequestError(@NotNull InvalidRequestError invalidRequestError) {
        return Companion.ofInvalidRequestError(invalidRequestError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofAuthenticationError(@NotNull AuthenticationError authenticationError) {
        return Companion.ofAuthenticationError(authenticationError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofBillingError(@NotNull BillingError billingError) {
        return Companion.ofBillingError(billingError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofPermissionError(@NotNull PermissionError permissionError) {
        return Companion.ofPermissionError(permissionError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofNotFoundError(@NotNull NotFoundError notFoundError) {
        return Companion.ofNotFoundError(notFoundError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofRateLimitError(@NotNull RateLimitError rateLimitError) {
        return Companion.ofRateLimitError(rateLimitError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofGatewayTimeoutError(@NotNull GatewayTimeoutError gatewayTimeoutError) {
        return Companion.ofGatewayTimeoutError(gatewayTimeoutError);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofApiErrorObject(@NotNull ApiErrorObject apiErrorObject) {
        return Companion.ofApiErrorObject(apiErrorObject);
    }

    @JvmStatic
    @NotNull
    public static final ErrorObject ofOverloadedError(@NotNull OverloadedError overloadedError) {
        return Companion.ofOverloadedError(overloadedError);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u00a8\u0006\u001f"}, d2={"Lcom/anthropic/models/ErrorObject$Companion;", "", "()V", "ofApiErrorObject", "Lcom/anthropic/models/ErrorObject;", "apiErrorObject", "Lcom/anthropic/models/ApiErrorObject;", "ofAuthenticationError", "authenticationError", "Lcom/anthropic/models/AuthenticationError;", "ofBillingError", "billingError", "Lcom/anthropic/models/BillingError;", "ofGatewayTimeoutError", "gatewayTimeoutError", "Lcom/anthropic/models/GatewayTimeoutError;", "ofInvalidRequestError", "invalidRequestError", "Lcom/anthropic/models/InvalidRequestError;", "ofNotFoundError", "notFoundError", "Lcom/anthropic/models/NotFoundError;", "ofOverloadedError", "overloadedError", "Lcom/anthropic/models/OverloadedError;", "ofPermissionError", "permissionError", "Lcom/anthropic/models/PermissionError;", "ofRateLimitError", "rateLimitError", "Lcom/anthropic/models/RateLimitError;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofInvalidRequestError(@NotNull InvalidRequestError invalidRequestError) {
            Intrinsics.checkNotNullParameter((Object)invalidRequestError, (String)"invalidRequestError");
            return new ErrorObject(invalidRequestError, null, null, null, null, null, null, null, null, null, 1022, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofAuthenticationError(@NotNull AuthenticationError authenticationError) {
            Intrinsics.checkNotNullParameter((Object)authenticationError, (String)"authenticationError");
            return new ErrorObject(null, authenticationError, null, null, null, null, null, null, null, null, 1021, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofBillingError(@NotNull BillingError billingError) {
            Intrinsics.checkNotNullParameter((Object)billingError, (String)"billingError");
            return new ErrorObject(null, null, billingError, null, null, null, null, null, null, null, 1019, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofPermissionError(@NotNull PermissionError permissionError) {
            Intrinsics.checkNotNullParameter((Object)permissionError, (String)"permissionError");
            return new ErrorObject(null, null, null, permissionError, null, null, null, null, null, null, 1015, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofNotFoundError(@NotNull NotFoundError notFoundError) {
            Intrinsics.checkNotNullParameter((Object)notFoundError, (String)"notFoundError");
            return new ErrorObject(null, null, null, null, notFoundError, null, null, null, null, null, 1007, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofRateLimitError(@NotNull RateLimitError rateLimitError) {
            Intrinsics.checkNotNullParameter((Object)rateLimitError, (String)"rateLimitError");
            return new ErrorObject(null, null, null, null, null, rateLimitError, null, null, null, null, 991, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofGatewayTimeoutError(@NotNull GatewayTimeoutError gatewayTimeoutError) {
            Intrinsics.checkNotNullParameter((Object)gatewayTimeoutError, (String)"gatewayTimeoutError");
            return new ErrorObject(null, null, null, null, null, null, gatewayTimeoutError, null, null, null, 959, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofApiErrorObject(@NotNull ApiErrorObject apiErrorObject) {
            Intrinsics.checkNotNullParameter((Object)apiErrorObject, (String)"apiErrorObject");
            return new ErrorObject(null, null, null, null, null, null, null, apiErrorObject, null, null, 895, null);
        }

        @JvmStatic
        @NotNull
        public final ErrorObject ofOverloadedError(@NotNull OverloadedError overloadedError) {
            Intrinsics.checkNotNullParameter((Object)overloadedError, (String)"overloadedError");
            return new ErrorObject(null, null, null, null, null, null, null, null, overloadedError, null, 767, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/anthropic/models/ErrorObject$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/ErrorObject;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nErrorObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorObject.kt\ncom/anthropic/models/ErrorObject$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,344:1\n51#2:345\n51#2:346\n51#2:347\n51#2:348\n51#2:349\n51#2:350\n51#2:351\n51#2:352\n51#2:353\n*S KotlinDebug\n*F\n+ 1 ErrorObject.kt\ncom/anthropic/models/ErrorObject$Deserializer\n*L\n259#1:345\n265#1:346\n271#1:347\n277#1:348\n283#1:349\n289#1:350\n295#1:351\n301#1:352\n307#1:353\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<ErrorObject> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(ErrorObject.class));
        }

        @Override
        @NotNull
        protected ErrorObject deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block31: {
                String type;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block31;
                int n = -1;
                switch (string.hashCode()) {
                    case 1258890136: {
                        if (string.equals("permission_error")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1266459263: {
                        if (string.equals("authentication_error")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1888290719: {
                        if (string.equals("not_found_error")) {
                            n = 3;
                        }
                        break;
                    }
                    case -88001629: {
                        if (string.equals("api_error")) {
                            n = 4;
                        }
                        break;
                    }
                    case -656062448: {
                        if (string.equals("invalid_request_error")) {
                            n = 5;
                        }
                        break;
                    }
                    case 1700738474: {
                        if (string.equals("timeout_error")) {
                            n = 6;
                        }
                        break;
                    }
                    case -1194176700: {
                        if (string.equals("billing_error")) {
                            n = 7;
                        }
                        break;
                    }
                    case 729998245: {
                        if (string.equals("rate_limit_error")) {
                            n = 8;
                        }
                        break;
                    }
                    case 579677218: {
                        if (string.equals("overloaded_error")) {
                            n = 9;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 5: {
                        boolean $i$f$jacksonTypeRef = false;
                        InvalidRequestError invalidRequestError = (InvalidRequestError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<InvalidRequestError>(){}, (Function1)deserialize.1.INSTANCE);
                        if (invalidRequestError == null) break;
                        InvalidRequestError it = invalidRequestError;
                        boolean bl = false;
                        return new ErrorObject(it, null, null, null, null, null, null, null, null, json2, 510, null);
                    }
                    case 2: {
                        boolean $i$f$jacksonTypeRef = false;
                        AuthenticationError authenticationError = (AuthenticationError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<AuthenticationError>(){}, (Function1)deserialize.3.INSTANCE);
                        if (authenticationError == null) break;
                        AuthenticationError it = authenticationError;
                        boolean bl = false;
                        return new ErrorObject(null, it, null, null, null, null, null, null, null, json2, 509, null);
                    }
                    case 7: {
                        boolean $i$f$jacksonTypeRef = false;
                        BillingError billingError = (BillingError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BillingError>(){}, (Function1)deserialize.5.INSTANCE);
                        if (billingError == null) break;
                        BillingError it = billingError;
                        boolean bl = false;
                        return new ErrorObject(null, null, it, null, null, null, null, null, null, json2, 507, null);
                    }
                    case 1: {
                        boolean $i$f$jacksonTypeRef = false;
                        PermissionError permissionError = (PermissionError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PermissionError>(){}, (Function1)deserialize.7.INSTANCE);
                        if (permissionError == null) break;
                        PermissionError it = permissionError;
                        boolean bl = false;
                        return new ErrorObject(null, null, null, it, null, null, null, null, null, json2, 503, null);
                    }
                    case 3: {
                        boolean $i$f$jacksonTypeRef = false;
                        NotFoundError notFoundError = (NotFoundError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<NotFoundError>(){}, (Function1)deserialize.9.INSTANCE);
                        if (notFoundError == null) break;
                        NotFoundError it = notFoundError;
                        boolean bl = false;
                        return new ErrorObject(null, null, null, null, it, null, null, null, null, json2, 495, null);
                    }
                    case 8: {
                        boolean $i$f$jacksonTypeRef = false;
                        RateLimitError rateLimitError = (RateLimitError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<RateLimitError>(){}, (Function1)deserialize.11.INSTANCE);
                        if (rateLimitError == null) break;
                        RateLimitError it = rateLimitError;
                        boolean bl = false;
                        return new ErrorObject(null, null, null, null, null, it, null, null, null, json2, 479, null);
                    }
                    case 6: {
                        boolean $i$f$jacksonTypeRef = false;
                        GatewayTimeoutError gatewayTimeoutError = (GatewayTimeoutError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<GatewayTimeoutError>(){}, (Function1)deserialize.13.INSTANCE);
                        if (gatewayTimeoutError == null) break;
                        GatewayTimeoutError it = gatewayTimeoutError;
                        boolean bl = false;
                        return new ErrorObject(null, null, null, null, null, null, it, null, null, json2, 447, null);
                    }
                    case 4: {
                        boolean $i$f$jacksonTypeRef = false;
                        ApiErrorObject apiErrorObject = (ApiErrorObject)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ApiErrorObject>(){}, (Function1)deserialize.15.INSTANCE);
                        if (apiErrorObject == null) break;
                        ApiErrorObject it = apiErrorObject;
                        boolean bl = false;
                        return new ErrorObject(null, null, null, null, null, null, null, it, null, json2, 383, null);
                    }
                    case 9: {
                        boolean $i$f$jacksonTypeRef = false;
                        OverloadedError overloadedError = (OverloadedError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<OverloadedError>(){}, (Function1)deserialize.17.INSTANCE);
                        if (overloadedError == null) break;
                        OverloadedError it = overloadedError;
                        boolean bl = false;
                        return new ErrorObject(null, null, null, null, null, null, null, null, it, json2, 255, null);
                    }
                }
            }
            return new ErrorObject(null, null, null, null, null, null, null, null, null, json2, 511, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/models/ErrorObject$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/ErrorObject;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
    public static final class Serializer
    extends BaseSerializer<ErrorObject> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(ErrorObject.class));
        }

        public void serialize(@NotNull ErrorObject value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.invalidRequestError != null) {
                generator.writeObject((Object)value.invalidRequestError);
            } else if (value.authenticationError != null) {
                generator.writeObject((Object)value.authenticationError);
            } else if (value.billingError != null) {
                generator.writeObject((Object)value.billingError);
            } else if (value.permissionError != null) {
                generator.writeObject((Object)value.permissionError);
            } else if (value.notFoundError != null) {
                generator.writeObject((Object)value.notFoundError);
            } else if (value.rateLimitError != null) {
                generator.writeObject((Object)value.rateLimitError);
            } else if (value.gatewayTimeoutError != null) {
                generator.writeObject((Object)value.gatewayTimeoutError);
            } else if (value.apiErrorObject != null) {
                generator.writeObject((Object)value.apiErrorObject);
            } else if (value.overloadedError != null) {
                generator.writeObject((Object)value.overloadedError);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid ErrorObject");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019H&\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H&\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%H&\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020)H&\u00a2\u0006\u0002\u0010*\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006+\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/ErrorObject$Visitor;", "T", "", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "visitApiErrorObject", "apiErrorObject", "Lcom/anthropic/models/ApiErrorObject;", "(Lcom/anthropic/models/ApiErrorObject;)Ljava/lang/Object;", "visitAuthenticationError", "authenticationError", "Lcom/anthropic/models/AuthenticationError;", "(Lcom/anthropic/models/AuthenticationError;)Ljava/lang/Object;", "visitBillingError", "billingError", "Lcom/anthropic/models/BillingError;", "(Lcom/anthropic/models/BillingError;)Ljava/lang/Object;", "visitGatewayTimeoutError", "gatewayTimeoutError", "Lcom/anthropic/models/GatewayTimeoutError;", "(Lcom/anthropic/models/GatewayTimeoutError;)Ljava/lang/Object;", "visitInvalidRequestError", "invalidRequestError", "Lcom/anthropic/models/InvalidRequestError;", "(Lcom/anthropic/models/InvalidRequestError;)Ljava/lang/Object;", "visitNotFoundError", "notFoundError", "Lcom/anthropic/models/NotFoundError;", "(Lcom/anthropic/models/NotFoundError;)Ljava/lang/Object;", "visitOverloadedError", "overloadedError", "Lcom/anthropic/models/OverloadedError;", "(Lcom/anthropic/models/OverloadedError;)Ljava/lang/Object;", "visitPermissionError", "permissionError", "Lcom/anthropic/models/PermissionError;", "(Lcom/anthropic/models/PermissionError;)Ljava/lang/Object;", "visitRateLimitError", "rateLimitError", "Lcom/anthropic/models/RateLimitError;", "(Lcom/anthropic/models/RateLimitError;)Ljava/lang/Object;", "anthropic-java-core"})
    public static interface Visitor<T> {
        public T visitInvalidRequestError(@NotNull InvalidRequestError var1);

        public T visitAuthenticationError(@NotNull AuthenticationError var1);

        public T visitBillingError(@NotNull BillingError var1);

        public T visitPermissionError(@NotNull PermissionError var1);

        public T visitNotFoundError(@NotNull NotFoundError var1);

        public T visitRateLimitError(@NotNull RateLimitError var1);

        public T visitGatewayTimeoutError(@NotNull GatewayTimeoutError var1);

        public T visitApiErrorObject(@NotNull ApiErrorObject var1);

        public T visitOverloadedError(@NotNull OverloadedError var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new AnthropicInvalidDataException("Unknown ErrorObject: " + json2, null, 2, null);
        }
    }
}

