/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.services.blocking;

import com.anthropic.core.ClientOptions;
import com.anthropic.core.JsonValue;
import com.anthropic.core.PrepareRequest;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.handlers.ErrorHandler;
import com.anthropic.core.handlers.SseHandler;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.core.http.StreamResponse;
import com.anthropic.core.http.StreamResponseKt;
import com.anthropic.errors.AnthropicError;
import com.anthropic.errors.AnthropicException;
import com.anthropic.models.Message;
import com.anthropic.models.MessageCountTokensParams;
import com.anthropic.models.MessageCreateParams;
import com.anthropic.models.MessageTokensCount;
import com.anthropic.models.RawMessageStreamEvent;
import com.anthropic.services.blocking.MessageService;
import com.anthropic.services.blocking.MessageServiceImpl;
import com.anthropic.services.blocking.MessageServiceImpl$special$;
import com.anthropic.services.blocking.messages.BatchService;
import com.anthropic.services.blocking.messages.BatchServiceImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/anthropic/services/blocking/MessageServiceImpl;", "Lcom/anthropic/services/blocking/MessageService;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "(Lcom/anthropic/core/ClientOptions;)V", "batches", "Lcom/anthropic/services/blocking/messages/BatchService;", "getBatches", "()Lcom/anthropic/services/blocking/messages/BatchService;", "batches$delegate", "Lkotlin/Lazy;", "countTokensHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/models/MessageTokensCount;", "createHandler", "Lcom/anthropic/models/Message;", "createStreamingHandler", "Lcom/anthropic/core/http/StreamResponse;", "Lcom/anthropic/models/RawMessageStreamEvent;", "errorHandler", "Lcom/anthropic/errors/AnthropicError;", "countTokens", "params", "Lcom/anthropic/models/MessageCountTokensParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "create", "Lcom/anthropic/models/MessageCreateParams;", "createStreaming", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nMessageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageServiceImpl.kt\ncom/anthropic/services/blocking/MessageServiceImpl\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n+ 3 SseHandler.kt\ncom/anthropic/core/handlers/SseHandler\n+ 4 HttpRequestBodies.kt\ncom/anthropic/core/HttpRequestBodies\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n13#2,9:154\n13#2,9:173\n112#3,10:163\n17#4:182\n17#4:184\n17#4:185\n1#5:183\n*S KotlinDebug\n*F\n+ 1 MessageServiceImpl.kt\ncom/anthropic/services/blocking/MessageServiceImpl\n*L\n42#1:154,9\n124#1:173,9\n76#1:163,10\n55#1:182\n94#1:184\n140#1:185\n*E\n"})
public final class MessageServiceImpl
implements MessageService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<AnthropicError> errorHandler;
    @NotNull
    private final Lazy batches$delegate;
    @NotNull
    private final HttpResponse.Handler<Message> createHandler;
    @NotNull
    private final HttpResponse.Handler<StreamResponse<RawMessageStreamEvent>> createStreamingHandler;
    @NotNull
    private final HttpResponse.Handler<MessageTokensCount> countTokensHandler;

    public MessageServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.batches$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BatchServiceImpl>(this){
            final /* synthetic */ MessageServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BatchServiceImpl invoke() {
                return new BatchServiceImpl(MessageServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Message>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Message handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Message>(){});
                }
                catch (Exception e) {
                    throw new AnthropicException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        HttpResponse.Handler $this$mapJson$iv = SseHandler.sseHandler(this.clientOptions.jsonMapper());
        boolean $i$f$mapJson = false;
        this.createStreamingHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<StreamResponse<RawMessageStreamEvent>>($this$mapJson$iv){
            final /* synthetic */ HttpResponse.Handler $this_mapJson;
            {
                this.$this_mapJson = $receiver;
            }

            @NotNull
            public StreamResponse<RawMessageStreamEvent> handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return StreamResponseKt.map((StreamResponse)this.$this_mapJson.handle(response), special$$inlined$mapJson$1$1.INSTANCE);
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.countTokensHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<MessageTokensCount>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public MessageTokensCount handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<MessageTokensCount>(){});
                }
                catch (Exception e) {
                    throw new AnthropicException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final BatchService getBatches() {
        Lazy lazy = this.batches$delegate;
        return (BatchService)lazy.getValue();
    }

    @Override
    @NotNull
    public BatchService batches() {
        return this.getBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Message create(@NotNull MessageCreateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "messages"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        MessageCreateParams.MessageCreateBody value$iv = params._body$anthropic_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request2 = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new AnthropicException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build(), this.clientOptions, params);
        HttpClient httpClient = this.clientOptions.httpClient();
        RequestOptions.Builder builder2 = RequestOptions.Companion.builder();
        Duration duration = Duration.ofMillis(600000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        HttpResponse response = httpClient.execute(request2, requestOptions.applyDefaults(builder2.timeout(duration).build()));
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl = false;
            it = this.createHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            $i$f$json22 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((Message)it).validate();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StreamResponse<RawMessageStreamEvent> createStreaming(@NotNull MessageCreateParams params, @NotNull RequestOptions requestOptions) {
        HttpResponse response;
        void value$iv;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "messages"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        MessageCreateParams.MessageCreateBody messageCreateBody = params._body$anthropic_java_core().toBuilder().putAdditionalProperty("stream", JsonValue.Companion.from(true)).build();
        boolean $i$f$json = false;
        HttpRequest request2 = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
        HttpClient httpClient = this.clientOptions.httpClient();
        RequestOptions.Builder builder2 = RequestOptions.Companion.builder();
        Duration duration = Duration.ofMillis(600000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        HttpResponse it = response = httpClient.execute(request2, requestOptions.applyDefaults(builder2.timeout(duration).build()));
        boolean bl = false;
        StreamResponse streamResponse = this.createStreamingHandler.handle(it);
        boolean bl2 = false;
        Boolean bl3 = requestOptions.getResponseValidation();
        return (bl3 != null ? bl3.booleanValue() : this.clientOptions.responseValidation()) ? StreamResponseKt.map(streamResponse, createStreaming.2.1.INSTANCE) : streamResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MessageTokensCount countTokens(@NotNull MessageCountTokensParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "messages", "count_tokens"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        MessageCountTokensParams.MessageCountTokensBody value$iv = params._body$anthropic_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request2 = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl = false;
            it = this.countTokensHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            $i$f$json22 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((MessageTokensCount)it).validate();
        }
        return object;
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(MessageServiceImpl $this) {
        return $this.clientOptions;
    }
}

