/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.services.blocking;

import com.anthropic.core.ClientOptions;
import com.anthropic.core.JsonValue;
import com.anthropic.core.PrepareRequest;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.handlers.ErrorHandler;
import com.anthropic.core.handlers.SseHandler;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.core.http.StreamResponse;
import com.anthropic.core.http.StreamResponseKt;
import com.anthropic.errors.AnthropicError;
import com.anthropic.errors.AnthropicException;
import com.anthropic.models.Message;
import com.anthropic.models.MessageCountTokensParams;
import com.anthropic.models.MessageCreateParams;
import com.anthropic.models.MessageTokensCount;
import com.anthropic.models.RawMessageStreamEvent;
import com.anthropic.services.blocking.MessageService;
import com.anthropic.services.blocking.MessageServiceImpl$special$;
import com.anthropic.services.blocking.messages.BatchService;
import com.anthropic.services.blocking.messages.BatchServiceImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/anthropic/services/blocking/MessageServiceImpl;", "Lcom/anthropic/services/blocking/MessageService;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "<init>", "(Lcom/anthropic/core/ClientOptions;)V", "errorHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/errors/AnthropicError;", "batches", "Lcom/anthropic/services/blocking/messages/BatchService;", "getBatches", "()Lcom/anthropic/services/blocking/messages/BatchService;", "batches$delegate", "Lkotlin/Lazy;", "createHandler", "Lcom/anthropic/models/Message;", "create", "params", "Lcom/anthropic/models/MessageCreateParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "createStreamingHandler", "Lcom/anthropic/core/http/StreamResponse;", "Lcom/anthropic/models/RawMessageStreamEvent;", "createStreaming", "countTokensHandler", "Lcom/anthropic/models/MessageTokensCount;", "countTokens", "Lcom/anthropic/models/MessageCountTokensParams;", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nMessageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageServiceImpl.kt\ncom/anthropic/services/blocking/MessageServiceImpl\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n+ 3 SseHandler.kt\ncom/anthropic/core/handlers/SseHandler\n+ 4 HttpRequestBodies.kt\ncom/anthropic/core/HttpRequestBodies\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n13#2,9:152\n13#2,9:171\n112#3,10:161\n14#4:180\n14#4:182\n14#4:183\n1#5:181\n*S KotlinDebug\n*F\n+ 1 MessageServiceImpl.kt\ncom/anthropic/services/blocking/MessageServiceImpl\n*L\n40#1:152,9\n122#1:171,9\n74#1:161,10\n53#1:180\n92#1:182\n138#1:183\n*E\n"})
public final class MessageServiceImpl
implements MessageService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<AnthropicError> errorHandler;
    @NotNull
    private final Lazy batches$delegate;
    @NotNull
    private final HttpResponse.Handler<Message> createHandler;
    @NotNull
    private final HttpResponse.Handler<StreamResponse<RawMessageStreamEvent>> createStreamingHandler;
    @NotNull
    private final HttpResponse.Handler<MessageTokensCount> countTokensHandler;

    public MessageServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.batches$delegate = LazyKt.lazy(() -> MessageServiceImpl.batches_delegate$lambda$0(this));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Message>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Message handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Message>(){});
                }
                catch (Exception e) {
                    throw new AnthropicException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        HttpResponse.Handler $this$mapJson$iv = SseHandler.sseHandler(this.clientOptions.jsonMapper());
        boolean $i$f$mapJson = false;
        this.createStreamingHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<StreamResponse<RawMessageStreamEvent>>($this$mapJson$iv){
            final /* synthetic */ HttpResponse.Handler $this_mapJson;
            {
                this.$this_mapJson = $receiver;
            }

            public StreamResponse<RawMessageStreamEvent> handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return StreamResponseKt.map((StreamResponse)this.$this_mapJson.handle(response), special$$inlined$mapJson$1$1.INSTANCE);
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.countTokensHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<MessageTokensCount>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public MessageTokensCount handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<MessageTokensCount>(){});
                }
                catch (Exception e) {
                    throw new AnthropicException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final BatchService getBatches() {
        Lazy lazy = this.batches$delegate;
        return (BatchService)lazy.getValue();
    }

    @Override
    @NotNull
    public BatchService batches() {
        return this.getBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Message create(@NotNull MessageCreateParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "messages"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        MessageCreateParams.Body value$iv = params._body$anthropic_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new AnthropicException("Error writing request", e);
                }
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build(), this.clientOptions, params);
        HttpClient httpClient = this.clientOptions.httpClient();
        RequestOptions.Builder builder2 = RequestOptions.Companion.builder();
        Duration duration = Duration.ofMillis(600000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        HttpResponse response = httpClient.execute(request, requestOptions.applyDefaults(builder2.timeout(duration).build()));
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.createHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$f$json22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((Message)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StreamResponse<RawMessageStreamEvent> createStreaming(@NotNull MessageCreateParams params, @NotNull RequestOptions requestOptions) {
        HttpResponse response;
        void value$iv;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "messages"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        MessageCreateParams.Body body = params._body$anthropic_java_core().toBuilder().putAdditionalProperty("stream", JsonValue.Companion.from(true)).build();
        boolean $i$f$json = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
        HttpClient httpClient = this.clientOptions.httpClient();
        RequestOptions.Builder builder2 = RequestOptions.Companion.builder();
        Duration duration = Duration.ofMillis(600000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        HttpResponse it = response = httpClient.execute(request, requestOptions.applyDefaults(builder2.timeout(duration).build()));
        boolean bl = false;
        StreamResponse streamResponse = this.createStreamingHandler.handle(it);
        boolean bl2 = false;
        Boolean bl3 = requestOptions.getResponseValidation();
        return (bl3 != null ? bl3.booleanValue() : this.clientOptions.responseValidation()) ? StreamResponseKt.map(streamResponse, MessageServiceImpl::createStreaming$lambda$5$lambda$4) : streamResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MessageTokensCount countTokens(@NotNull MessageCountTokensParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "messages", "count_tokens"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        MessageCountTokensParams.Body value$iv = params._body$anthropic_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.countTokensHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$f$json22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((MessageTokensCount)it2).validate();
        }
        return object;
    }

    private static final BatchServiceImpl batches_delegate$lambda$0(MessageServiceImpl this$0) {
        return new BatchServiceImpl(this$0.clientOptions);
    }

    private static final RawMessageStreamEvent createStreaming$lambda$5$lambda$4(RawMessageStreamEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.validate();
    }
}

