/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.JsonArray;
import com.anthropic.core.JsonBoolean;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonMissing;
import com.anthropic.core.JsonNull;
import com.anthropic.core.JsonNumber;
import com.anthropic.core.JsonObject;
import com.anthropic.core.JsonString;
import com.anthropic.core.ObjectMappers;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0011\u0012\u0013B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000f\u00a2\u0006\u0002\u0010\u0010\u0082\u0001\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/anthropic/core/JsonValue;", "Lcom/anthropic/core/JsonField;", "", "<init>", "()V", "convert", "R", "", "type", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "accept", "visitor", "Lcom/anthropic/core/JsonValue$Visitor;", "(Lcom/anthropic/core/JsonValue$Visitor;)Ljava/lang/Object;", "Visitor", "Companion", "Deserializer", "Lcom/anthropic/core/JsonArray;", "Lcom/anthropic/core/JsonBoolean;", "Lcom/anthropic/core/JsonMissing;", "Lcom/anthropic/core/JsonNull;", "Lcom/anthropic/core/JsonNumber;", "Lcom/anthropic/core/JsonObject;", "Lcom/anthropic/core/JsonString;", "anthropic-java-core"})
public abstract class JsonValue
extends JsonField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JsonMapper JSON_MAPPER = ObjectMappers.jsonMapper();

    private JsonValue() {
        super(null);
    }

    @Nullable
    public final <R> R convert(@NotNull TypeReference<R> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (R)JSON_MAPPER.convertValue((Object)this, type);
    }

    @Nullable
    public final <R> R convert(@NotNull Class<R> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (R)JSON_MAPPER.convertValue((Object)this, type);
    }

    public final <R> R accept(@NotNull Visitor<? extends R> visitor) {
        R r;
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        JsonValue jsonValue = this;
        if (jsonValue instanceof JsonMissing) {
            r = visitor.visitMissing();
        } else if (jsonValue instanceof JsonNull) {
            r = visitor.visitNull();
        } else if (jsonValue instanceof JsonBoolean) {
            r = visitor.visitBoolean(((JsonBoolean)this).value());
        } else if (jsonValue instanceof JsonNumber) {
            r = visitor.visitNumber(((JsonNumber)this).value());
        } else if (jsonValue instanceof JsonString) {
            r = visitor.visitString(((JsonString)this).value());
        } else if (jsonValue instanceof JsonArray) {
            r = visitor.visitArray(((JsonArray)this).values());
        } else if (jsonValue instanceof JsonObject) {
            r = visitor.visitObject(((JsonObject)this).values());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return r;
    }

    @JvmStatic
    @NotNull
    public static final JsonValue from(@Nullable Object value) {
        return Companion.from(value);
    }

    @JvmStatic
    @NotNull
    public static final JsonValue fromJsonNode(@NotNull JsonNode node) {
        return Companion.fromJsonNode(node);
    }

    public /* synthetic */ JsonValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/anthropic/core/JsonValue$Companion;", "", "<init>", "()V", "JSON_MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "from", "Lcom/anthropic/core/JsonValue;", "value", "fromJsonNode", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonValue from(@Nullable Object value) {
            JsonValue jsonValue;
            Object object = value;
            if (object == null) {
                jsonValue = JsonNull.Companion.of();
            } else if (object instanceof JsonValue) {
                jsonValue = (JsonValue)value;
            } else {
                Object object2 = JSON_MAPPER.convertValue(value, JsonValue.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"convertValue(...)");
                jsonValue = (JsonValue)object2;
            }
            return jsonValue;
        }

        @JvmStatic
        @NotNull
        public final JsonValue fromJsonNode(@NotNull JsonNode node) {
            JsonValue jsonValue;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JsonNodeType jsonNodeType = node.getNodeType();
            switch (jsonNodeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                case 1: {
                    jsonValue = JsonMissing.Companion.of();
                    break;
                }
                case 2: {
                    jsonValue = JsonNull.Companion.of();
                    break;
                }
                case 3: {
                    jsonValue = JsonBoolean.Companion.of(node.booleanValue());
                    break;
                }
                case 4: {
                    Number number = node.numberValue();
                    Intrinsics.checkNotNullExpressionValue((Object)number, (String)"numberValue(...)");
                    jsonValue = JsonNumber.Companion.of(number);
                    break;
                }
                case 5: {
                    String string = node.textValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
                    jsonValue = JsonString.Companion.of(string);
                    break;
                }
                case 6: {
                    Iterator iterator2 = node.elements();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"elements(...)");
                    jsonValue = JsonArray.Companion.of(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator2), Companion::fromJsonNode$lambda$0)));
                    break;
                }
                case 7: {
                    Iterator iterator3 = node.fields();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"fields(...)");
                    jsonValue = JsonObject.Companion.of(MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator3), Companion::fromJsonNode$lambda$1)));
                    break;
                }
                case -1: 
                case 8: 
                case 9: {
                    throw new IllegalStateException("Unexpected JsonNode type: " + node.getNodeType());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return jsonValue;
        }

        private static final JsonValue fromJsonNode$lambda$0(JsonNode it) {
            Intrinsics.checkNotNull((Object)it);
            return Companion.fromJsonNode(it);
        }

        private static final Pair fromJsonNode$lambda$1(Map.Entry it) {
            Object k = it.getKey();
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            return TuplesKt.to(k, (Object)Companion.fromJsonNode((JsonNode)v));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonNodeType.values().length];
                try {
                    nArray[JsonNodeType.MISSING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.NULL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.BOOLEAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.NUMBER.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.STRING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.ARRAY.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.OBJECT.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.BINARY.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.POJO.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/anthropic/core/JsonValue$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/core/JsonValue;", "<init>", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "getNullValue", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "anthropic-java-core"})
    public static final class Deserializer
    extends BaseDeserializer<JsonValue> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(JsonValue.class));
        }

        @Override
        @NotNull
        protected JsonValue deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return Companion.fromJsonNode(node);
        }

        @NotNull
        public JsonValue getNullValue(@Nullable DeserializationContext context) {
            return JsonNull.Companion.of();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\r\u0010\u0003\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00028\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00028\u00002\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/core/JsonValue$Visitor;", "R", "", "visitNull", "()Ljava/lang/Object;", "visitMissing", "visitBoolean", "value", "", "(Z)Ljava/lang/Object;", "visitNumber", "", "(Ljava/lang/Number;)Ljava/lang/Object;", "visitString", "", "(Ljava/lang/String;)Ljava/lang/Object;", "visitArray", "values", "", "Lcom/anthropic/core/JsonValue;", "(Ljava/util/List;)Ljava/lang/Object;", "visitObject", "", "(Ljava/util/Map;)Ljava/lang/Object;", "visitDefault", "anthropic-java-core"})
    public static interface Visitor<R> {
        default public R visitNull() {
            return this.visitDefault();
        }

        default public R visitMissing() {
            return this.visitDefault();
        }

        default public R visitBoolean(boolean value) {
            return this.visitDefault();
        }

        default public R visitNumber(@NotNull Number value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.visitDefault();
        }

        default public R visitString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.visitDefault();
        }

        default public R visitArray(@NotNull List<? extends JsonValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.visitDefault();
        }

        default public R visitObject(@NotNull Map<String, ? extends JsonValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.visitDefault();
        }

        default public R visitDefault() {
            throw new RuntimeException("Unexpected value");
        }
    }
}

